/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\ruc\u0001\u0002\u0016,\u0001YB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005+\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003_\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011!\u0004!Q1A\u0005\u0002%D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t]\u0002\u0011)\u0019!C\u0001_\"A1\u000f\u0001B\u0001B\u0003%\u0001\u000f\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!a\bA!A!\u0002\u00131\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005\u0015\u0001A!A!\u0002\u0013y\bBCA\u0004\u0001\t\u0015\r\u0011b\u0001\u0002\n!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\u0003\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA)\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\t)\u0010\u0001C!\u0003oDqA!\u0002\u0001\t\u0003\u00129\u0001C\u0004\u0003\u0010\u0001!\tE!\u0005\t\u000f\tE\u0002\u0001\"\u0011\u00034!9!\u0011\b\u0001\u0005B\tm\u0002b\u0002B$\u0001\u0011\u0005#\u0011\n\u0005\b\u00053\u0002A\u0011\tB.\u0011\u001d\u0011\t\u0007\u0001C!\u0005GBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\te\u0004\u0001\"\u0011\u0003|!9!Q\u0013\u0001\u0005B\t]\u0005b\u0002BV\u0001\u0011\u0005#Q\u0016\u0005\b\u0005c\u0003A\u0011\tBZ\u0011\u001d\u0011Y\f\u0001C!\u0005{CqA!5\u0001\t\u0003\u0012\u0019\u000eC\u0004\u0003l\u0002!\tEa5\t\u000f\tE\b\u0001\"\u0011\u0003t\"91q\u0001\u0001\u0005B\r%\u0001bBB\r\u0001\u0011\u000531\u0004\u0005\b\u0007\u0017\u0002A\u0011IB'\u0005E\u0019\u0016\u000f\u001c+bg.\u0014V\r]8tSR|'/\u001f\u0006\u0003Y5\n1a]9m\u0015\tqs&\u0001\u0006sKB|7/\u001b;pefT!\u0001M\u0019\u0002\u0013ad'/\u001a7fCN,'B\u0001\u001a4\u0003%AXMY5bY\u0006\u00147OC\u00015\u0003\r\u0019w.\\\u0002\u0001'\u001d\u0001q'P!F\u0011.\u0003\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 @\u001b\u0005i\u0013B\u0001!.\u00059!\u0016m]6SKB|7/\u001b;pef\u0004\"AQ\"\u000e\u0003-J!\u0001R\u0016\u00033\t\u000b7/\u001a*fY\u0016\f7/Z%uK6\u0014V\r]8tSR|'/\u001f\t\u0003\u0005\u001aK!aR\u0016\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"AQ%\n\u0005)[#AH\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3t'V\u0004\bo\u001c:u!\ta\u0015+D\u0001N\u0015\tqu*A\u0003tY\u001a$$NC\u0001Q\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001*N\u0005\u001daunZ4j]\u001e\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002YW\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tQvK\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\u0013!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u000b\u0002=B\u0011akX\u0005\u0003A^\u0013Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,W#\u00013\u0011\u0005Y+\u0017B\u00014X\u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u0005;bg.\u0004VM]:jgR,gnY3!\u0003E\u0019w.\\7f]R\u0014V\r]8tSR|'/_\u000b\u0002UB\u0011ah[\u0005\u0003Y6\u0012\u0011cQ8n[\u0016tGOU3q_NLGo\u001c:z\u0003I\u0019w.\\7f]R\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001q!\t\u0011\u0015/\u0003\u0002sW\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!_,\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\tY\bPA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u00074bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ,\u0012a \t\u0004}\u0005\u0005\u0011bAA\u0002[\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s\u0003i1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:!\u0003\u001d!\u0017.\u00197fGR,\"!a\u0003\u0011\t\u00055\u00111\u0007\b\u0005\u0003\u001f\tiC\u0004\u0003\u0002\u0012\u0005%b\u0002BA\n\u0003KqA!!\u0006\u0002$9!\u0011qCA\u0011\u001d\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fk\u00051AH]8pizJ\u0011\u0001N\u0005\u0003eMJ!\u0001M\u0019\n\u0007\u0005\u001dr&\u0001\u0002eE&\u0019A&a\u000b\u000b\u0007\u0005\u001dr&\u0003\u0003\u00020\u0005E\u0012AC*rY\n+\u0018\u000e\u001c3fe*\u0019A&a\u000b\n\t\u0005U\u0012q\u0007\u0002\b\t&\fG.Z2u\u0015\u0011\ty#!\r\u0002\u0011\u0011L\u0017\r\\3di\u0002\na\u0001P5oSRtDCEA \u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u00131JA'\u0003\u001f\u0002\"A\u0011\u0001\t\u000bM\u000b\u0002\u0019A+\t\u000bq\u000b\u0002\u0019\u00010\t\u000b\t\f\u0002\u0019\u00013\t\u000b!\f\u0002\u0019\u00016\t\u000b9\f\u0002\u0019\u00019\t\u000bQ\f\u0002\u0019\u0001<\t\u000bu\f\u0002\u0019A@\t\u000f\u0005\u001d\u0011\u0003q\u0001\u0002\f\u0005Aa-\u001b8e\u0005fLE-\u0006\u0003\u0002V\u0005mC\u0003BA,\u0003g\u0002B!!\u0017\u0002\\1\u0001AaBA/%\t\u0007\u0011q\f\u0002\u0002)F!\u0011\u0011MA4!\rA\u00141M\u0005\u0004\u0003KJ$a\u0002(pi\"Lgn\u001a\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011QN\u0018\u0002\r\u0011|W.Y5o\u0013\u0011\t\t(a\u001b\u0003\tQ\u000b7o\u001b\u0005\b\u0003k\u0012\u0002\u0019AA<\u0003\u0019!\u0018m]6JIB!\u0011\u0011PAA\u001d\u0011\tY(! \u0011\u0007\u0005e\u0011(C\u0002\u0002\u0000e\na\u0001\u0015:fI\u00164\u0017\u0002BAB\u0003\u000b\u0013aa\u0015;sS:<'bAA@s!\u001a!#!#\u0011\t\u0005-\u0015\u0011T\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005M\u0015QS\u0001\b[\u0016$(/[2t\u0015\r\t9jM\u0001\tG>$\u0017\r[1mK&!\u00111TAG\u0005\u0015!\u0016.\\3e+\u0011\ty*a)\u0015\r\u0005\u0005\u0016QUAT!\u0011\tI&a)\u0005\u000f\u0005u3C1\u0001\u0002`!9\u0011QO\nA\u0002\u0005]\u0004bBAU'\u0001\u0007\u00111V\u0001\u000fe\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8t!\u0011\ti+!/\u000e\u0005\u0005=&b\u0001\u0018\u00022*!\u00111WA[\u0003\u0011Q7o\u001c8\u000b\u0007\u0005]v&A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0003w\u000byK\u0001\bSKN|GN^3PaRLwN\\:)\u0007M\tI)\u0001\ngS:$G+Y:lg\n\u000b7/[2ECR\fG\u0003BAb\u0003?\u0004b!!2\u0002P\u0006MWBAAd\u0015\u0011\tI-a3\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\fAA[1wC&!\u0011\u0011[Ad\u0005\u0011a\u0015n\u001d;\u0011\t\u0005U\u00171\\\u0007\u0003\u0003/T1!!7.\u0003\u0015\tX/\u001a:z\u0013\u0011\ti.a6\u0003\u001bQ\u000b7o\u001b\"bg&\u001cG)\u0019;b\u0011\u001d\t\t\u000f\u0006a\u0001\u0003G\fq\u0001^1tW&#7\u000f\u0005\u0004\u0002F\u0006=\u0017q\u000f\u0015\u0004)\u0005\u001d\b\u0003BAu\u0003_l!!a;\u000b\t\u00055\u0018\u0011G\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002r\u0006-(AC%t%\u0016\fGm\u00148ms\"\u001aA#!#\u0002\r\u0015D\u0018n\u001d;t)\u0011\tI0a@\u0011\u0007a\nY0C\u0002\u0002~f\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002vU\u0001\r!a\u001e)\u0007U\t9\u000fK\u0002\u0016\u0003\u0013\u000ba!\u001e9eCR,G\u0003BA4\u0005\u0013AqAa\u0003\u0017\u0001\u0004\t9'\u0001\u0003uCN\\\u0007f\u0001\f\u0002\n\u0006YQ\u000f\u001d3bi\u0016$\u0016m]6t)\u0011\u0011\u0019B!\u0007\u0011\u0007a\u0012)\"C\u0002\u0003\u0018e\u0012A!\u00168ji\"9!1D\fA\u0002\tu\u0011!\u0002;bg.\u001c\b#\u0002\u001d\u0003 \u0005\u001d\u0014b\u0001B\u0011s\tQAH]3qK\u0006$X\r\u001a )\u0007]\u0011)\u0003\u0005\u0003\u0003(\t-RB\u0001B\u0015\u0015\r\ty)O\u0005\u0005\u0005[\u0011ICA\u0004wCJ\f'oZ:)\u0007]\tI)\u0001\u000bva\u0012\fG/\u001a+bg.\u0004&o\u001c9feRLWm\u001d\u000b\u0005\u0005'\u0011)\u0004C\u0004\u0003\fa\u0001\r!a\u001a)\u0007a\tI)A\rcCR\u001c\u0007.\u00169eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\n\u0005{AqAa\u0007\u001a\u0001\u0004\u0011y\u0004\u0005\u0004\u0002z\t\u0005\u0013qM\u0005\u0005\u0005\u0007\n)IA\u0002TKRD3!GAE\u0003y)\b\u000fZ1uKR\u000b7o[!oIJ+G.Z1tK\u001ac\u0017mZ*uCR,8\u000f\u0006\u0004\u0002h\t-#Q\n\u0005\b\u0005\u0017Q\u0002\u0019AA4\u0011\u001d\u0011yE\u0007a\u0001\u0005#\nqA]3mK\u0006\u001cX\r\u0005\u0003\u0002j\tM\u0013\u0002\u0002B+\u0003W\u0012qAU3mK\u0006\u001cX\rK\u0002\u001b\u0003\u0013\u000b!\"\u001e9eCR,G+\u001f9f)\u0011\t9G!\u0018\t\u000f\t-1\u00041\u0001\u0002h!\u001a1$!#\u0002\r\u0011,G.\u001a;f)\u0011\u0011\u0019B!\u001a\t\u000f\t-A\u00041\u0001\u0002h!\u001aA$!#\u0002\u0015\r\u0014X-\u0019;f)\u0006\u001c8\u000e\u0006\u0003\u0002h\t5\u0004b\u0002B8;\u0001\u0007\u0011qM\u0001\b]\u0016<H+Y:l\u0003\u0019\u0019'/Z1uKR!\u0011q\rB;\u0011\u001d\u0011yG\ba\u0001\u0003OB3AHAE\u0003!iwN^3UCN\\GCCA4\u0005{\u0012\tI!\"\u0003\u0010\"9!qP\u0010A\u0002\u0005\u001d\u0014A\u0003;bg.$v.T8wK\"9!1Q\u0010A\u0002\u0005\u001d\u0014!C7pm\u0016$G+Y:l\u0011\u001d\u00119i\ba\u0001\u0005\u0013\u000ba#\u001e9eCR,Gm\u0014:jO&t7i\u001c8uC&tWM\u001d\t\u0005\u0003S\u0012Y)\u0003\u0003\u0003\u000e\u0006-$!\u0004+bg.\u001cuN\u001c;bS:,'\u000fC\u0004\u0003\u0012~\u0001\rA!#\u0002-U\u0004H-\u0019;fIR\u000b'oZ3u\u0007>tG/Y5oKJD3aHAE\u0003Y1\u0017N\u001c3BM\u001a,7\r^3e\u0005f\u0014E.Y2l_V$H\u0003BAr\u00053CqAa'!\u0001\u0004\u0011i*\u0001\u0005cY\u0006\u001c7n\\;u!\u0011\u0011yJ!*\u000e\u0005\t\u0005&\u0002\u0002BR\u0003W\n\u0001bY1mK:$\u0017M]\u0005\u0005\u0005O\u0013\tK\u0001\u0005CY\u0006\u001c7n\\;uQ\r\u0001\u0013\u0011R\u0001\u001bM&tG\rU3oI&tw\rV1tWN<\u0016\u000e\u001e5GC\u000e,Go\u001d\u000b\u0003\u0003GD3!IAE\u0003!9W\r\u001e+ji2,G\u0003BA<\u0005kCq!!\u001e#\u0001\u0004\t9\bK\u0002#\u0003OD3AIAE\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0005\u007f\u0013\u0019\r\u0005\u0004\u0002F\n\u0005\u0017qO\u0005\u0005\u0005\u0007\n9\rC\u0004\u0003F\u000e\u0002\rAa2\u0002\u00171LW.\u001b;Ok6\u0014WM\u001d\t\u0004q\t%\u0017b\u0001Bfs\t\u0019\u0011J\u001c;)\u0007\r\n9\u000fK\u0002$\u0003\u0013\u000b!CZ5oI>3XM\u001d3vKR\u000b7o[%egR\u0011!Q\u001b\t\u0007\u0005/\u0014\t/a\u001e\u000f\t\te'Q\u001c\b\u0005\u00033\u0011Y.C\u0001;\u0013\r\u0011y.O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019O!:\u0003\u0007M+\u0017OC\u0002\u0003`fB3\u0001JAtQ\r!\u0013\u0011R\u0001\u0013M&tG\rR;f'>|g\u000eV1tW&#7\u000fK\u0002&\u0003OD3!JAE\u0003%9W\r^*uCR,8\u000f\u0006\u0003\u0003v\u000e\u0005\u0001\u0003\u0002B|\u0005{l!A!?\u000b\t\tm\u00181N\u0001\u0007gR\fG/^:\n\t\t}(\u0011 \u0002\u000b)\u0006\u001c8n\u0015;biV\u001c\bbBA;M\u0001\u0007\u0011q\u000f\u0015\u0004M\u0005\u001d\bf\u0001\u0014\u0002\n\u0006yq-\u001a;UCN\\7\u000b^1ukN,7\u000f\u0006\u0003\u0004\f\rE\u0001\u0003CAc\u0007\u001b\t9H!>\n\t\r=\u0011q\u0019\u0002\u0004\u001b\u0006\u0004\bbBB\nO\u0001\u0007\u0011qO\u0001\ne\u0016dW-Y:f\u0013\u0012D3aJAtQ\r9\u0013\u0011R\u0001(M&tG\rV1tW&#7OQ=UCN\\G+\u001f9f'R\fG/^:B]\u0012\u001cF/\u0019:u\t\u0006$X\r\u0006\u0005\u0003V\u000eu1\u0011HB\u001f\u0011\u001d\u0019y\u0002\u000ba\u0001\u0007C\t\u0001\u0002^1tWRK\b/\u001a\t\u0005\u0007G\u0019)$\u0004\u0002\u0004&)!1qEB\u0015\u0003\u001d\u0011XM\u001a7fGRTAaa\u000b\u0004.\u0005\u0019\u0011\r]5\u000b\t\r=2\u0011G\u0001\u0007a2,x-\u001b8\u000b\u0007\rM\u0012'\u0001\u0005eKBdw._5u\u0013\u0011\u00199d!\n\u0003\tQK\b/\u001a\u0005\b\u0007wA\u0003\u0019\u0001B{\u0003)!\u0018m]6Ti\u0006$Xo\u001d\u0005\b\u0007\u007fA\u0003\u0019AB!\u00035\u0019H/\u0019:uK\u0012\u0014UMZ8sKB!\u0011QYB\"\u0013\u0011\u0019)%a2\u0003\t\u0011\u000bG/\u001a\u0015\u0004Q\u0005\u001d\bf\u0001\u0015\u0002\n\u0006!R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d'j]\u0016$bAa\u0005\u0004P\rE\u0003bBA;S\u0001\u0007\u0011q\u000f\u0005\b\u0007'J\u0003\u0019AA<\u0003)\u0019H/\u0019;vg2Kg.\u001a\u0015\u0004\u0001\r]\u0003\u0003BAu\u00073JAaa\u0017\u0002l\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, ResolveOptions$.MODULE$.WITH_DECORATORS());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return None$.MODULE$;
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return None$.MODULE$;
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
            })).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void batchUpdateTaskProperties(scala.collection.immutable.Set<Task> tasks) {
        this.taskPersistence().batchUpdateTaskProperties(tasks);
        Tuple2 tuple2 = ((IterableOps)tasks.flatMap((Function1 & Serializable)x$2 -> syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(x$2)))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isArchived()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set archivedDeps = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set otherDeps = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)archivedDeps, (Object)otherDeps);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Set archivedDeps2 = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set otherDeps2 = (scala.collection.immutable.Set)tuple23._2();
        this.dependencyPersistence().batchDeleteDependencies((scala.collection.immutable.Set<Dependency>)archivedDeps2);
        this.dependencyPersistence().batchUpdateDependencies((scala.collection.immutable.Set<Dependency>)otherDeps2);
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$5)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)releaseData -> this.tryDeserializeRelease((ReleaseRow)releaseData))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$6 -> x$6.getId())).asJava();
    }

    @Timed
    public List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskStatus[]{TaskStatus.PENDING})))).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findTaskIdsByTaskTypeStatusAndStartDate(Type taskType, TaskStatus taskStatus, Date startedBefore) {
        return this.taskPersistence().findTaskIdsByTaskTypeStatusAndStartDate(taskType, taskStatus, startedBefore);
    }

    public void updateTaskStatusLine(String taskId, String statusLine) {
        this.taskPersistence().updateStatusLine(taskId, statusLine);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$5) {
        String string = x$5.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

