/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.ReferencedEntity;
import com.xebialabs.xlrelease.repository.sql.SqlConfigurationRepository$;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ReleaseConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.validation.ExtendedValidationContextImpl;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0011=b\u0001\u0002 @\u0001)C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"A!\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0019\bA!A!\u0002\u0013!\b\"\u0002=\u0001\t\u0003I\bbCA\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007A1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Y\u0011\u0011\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0003\u0011%\tI\u0004\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA\u001f\u0011%\t)\u0006\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA\u001f\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0004\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA\u001f\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA1\u0011\u001d\t9\b\u0001C!\u0003sBq!a\u001e\u0001\t\u0003\ny\u000bC\u0004\u0002f\u0002!I!a:\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u0005\u0013\u0001A\u0011\tB\f\u0011\u001d\u0011)\u0003\u0001C!\u0005OAqA!\u0018\u0001\t\u0003\u0012y\u0006C\u0004\u0003^\u0001!\tE!\u001d\t\u0013\t5\u0005!%A\u0005\u0002\t=\u0005b\u0002BT\u0001\u0011%!\u0011\u0016\u0005\b\u0005\u001b\u0004A\u0011\u0001Bh\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;DqAa9\u0001\t\u0003\u0011)\u000fC\u0005\u0004\u0006\u0001\t\n\u0011\"\u0001\u0004\b!911\u0002\u0001\u0005B\r5\u0001bBB\u0006\u0001\u0011\u00053q\u0004\u0005\b\u0007\u0003\u0002A\u0011IB\"\u0011\u001d\u0019Y\u0005\u0001C\u0005\u0007\u001bBqaa\u001e\u0001\t\u0003\u001aI\bC\u0004\u0004\u0000\u0001!\ta!!\t\u000f\r5\u0005\u0001\"\u0011\u0004\u0010\"911\u0015\u0001\u0005\n\r\u0015\u0006bBBc\u0001\u0011\u00053q\u0019\u0005\b\u0007\u001b\u0004A\u0011IBh\u0011\u001d\u00199\u000e\u0001C\u0005\u00073<qa!:@\u0011\u0003\u00199O\u0002\u0004?\u007f!\u00051\u0011\u001e\u0005\u0007q:\"\taa;\u0007\r\r5h&BBx\u0011)\u0019\t\u0010\rB\u0001B\u0003%!1\t\u0005\u0007qB\"\taa=\t\u000f\rm\b\u0007\"\u0001\u0004~\"91q \u0019\u0005\u0002\u0011\u0005\u0001\"\u0003C\u0004]\u0005\u0005I1\u0002C\u0005\r\u0019!iAL\u0003\u0005\u0010!QA\u0011\u0003\u001c\u0003\u0002\u0003\u0006I!!$\t\ra4D\u0011\u0001C\n\u0011%\u0011\tE\u000eb\u0001\n\u0013!I\u0002\u0003\u0005\u0005\u001cY\u0002\u000b\u0011\u0002B\"\u0011\u001d\u0019YP\u000eC\u0001\u0007{Dq\u0001\"\b7\t\u0003!y\u0002C\u0005\u0005*9\n\t\u0011b\u0003\u0005,\tQ2+\u001d7D_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss*\u0011\u0001)Q\u0001\u0004gFd'B\u0001\"D\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\t\u0016\u000b\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0019;\u0015!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0015aA2p[\u000e\u00011\u0003\u0002\u0001L#V\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013a!\u00118z%\u00164\u0007C\u0001*T\u001b\u0005\t\u0015B\u0001+B\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002W76\tqK\u0003\u0002Y3\u0006)1\u000f\u001c45U*\t!,\u0001\u0005he&T(\u0010\\3e\u0013\tavKA\u0004M_\u001e<\u0017N\\4\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T!aY \u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003K\u0002\u0014\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003!\u0012X\r\\3bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\ty\u0006.\u0003\u0002jA\nA#+\u001a7fCN,7i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006ACO]5hO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dKB\u0011q\f\\\u0005\u0003[\u0002\u0014\u0001\u0006\u0016:jO\u001e,'oQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\fAc]9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\bC\u00019r\u001b\u0005y\u0014B\u0001:@\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005U4X\"\u00012\n\u0005]\u0014'!\u0005$pY\u0012,'\u000fU3sg&\u001cH/\u001a8dK\u00061A(\u001b8jiz\"bA_>}{z|\bC\u00019\u0001\u0011\u0015if\u00011\u0001_\u0011\u00151g\u00011\u0001h\u0011\u0015Qg\u00011\u0001l\u0011\u0015qg\u00011\u0001p\u0011\u0015\u0019h\u00011\u0001u\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u000b\u00012AUA\u0004\u0013\r\tI!\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018!\u0006:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss~#S-\u001d\u000b\u0005\u0003\u001f\t)\u0002E\u0002M\u0003#I1!a\u0005N\u0005\u0011)f.\u001b;\t\u0013\u0005]\u0001\"!AA\u0002\u0005\u0015\u0011a\u0001=%c\u0005\u0011\"/\u001a7fCN,'+\u001a9pg&$xN]=!Q\rI\u0011Q\u0004\t\u0005\u0003?\t)$\u0004\u0002\u0002\")!\u00111EA\u0013\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003O\tI#A\u0004gC\u000e$xN]=\u000b\t\u0005-\u0012QF\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003_\t\t$A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t\u0019$A\u0002pe\u001eLA!a\u000e\u0002\"\tI\u0011)\u001e;po&\u0014X\rZ\u0001\b%\u0016cU)Q*F+\t\ti\u0004\u0005\u0003\u0002@\u00055c\u0002BA!\u0003\u0013\u00022!a\u0011N\u001b\t\t)EC\u0002\u0002H%\u000ba\u0001\u0010:p_Rt\u0014bAA&\u001b\u00061\u0001K]3eK\u001aLA!a\u0014\u0002R\t11\u000b\u001e:j]\u001eT1!a\u0013N\u0003!\u0011V\tT#B'\u0016\u0003\u0013\u0001\u0003+F\u001bBc\u0015\tV#\u0002\u0013Q+U\n\u0015'B)\u0016\u0003\u0013a\u0002+S\u0013\u001e;UIU\u0001\t)JKuiR#SA\u00051Q.\u00199qKJ,\"!!\u0019\u0011\t\u0005\r\u0014\u0011O\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005AA-\u0019;bE&tGM\u0003\u0003\u0002l\u00055\u0014a\u00026bG.\u001cxN\u001c\u0006\u0004\u0003_:\u0015!\u00034bgR,'\u000f_7m\u0013\u0011\t\u0019(!\u001a\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000f5\f\u0007\u000f]3sA\u000511M]3bi\u0016,B!a\u001f\u0002\u0002R!\u0011QPAM!\u0011\ty(!!\r\u0001\u00119\u00111\u0011\nC\u0002\u0005\u0015%!\u0001+\u0012\t\u0005\u001d\u0015Q\u0012\t\u0004\u0019\u0006%\u0015bAAF\u001b\n9aj\u001c;iS:<\u0007\u0003BAH\u0003+k!!!%\u000b\u0007\u0005M5)\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003/\u000b\tJA\tCCN,7i\u001c8gS\u001e,(/\u0019;j_:Da!\u0019\nA\u0002\u0005u\u0004f\u0001\n\u0002\u001eB!\u0011qTAV\u001b\t\t\tK\u0003\u0003\u0002$\u0005\r&\u0002BAS\u0003O\u000bq!\\3ue&\u001c7OC\u0002\u0002*\u001e\u000b\u0001bY8eC\"\fG.Z\u0005\u0005\u0003[\u000b\tKA\u0003US6,G-\u0006\u0003\u00022\u0006UFCBAZ\u0003o\u000bI\f\u0005\u0003\u0002\u0000\u0005UFaBAB'\t\u0007\u0011Q\u0011\u0005\u0007CN\u0001\r!a-\t\u000f\u0005m6\u00031\u0001\u0002>\u0006Yam\u001c7eKJ\u001c\u0015.V5e!\u0011\ty,!8\u000f\t\u0005\u0005\u0017\u0011\u001c\b\u0005\u0003\u0007\f9N\u0004\u0003\u0002F\u0006Ug\u0002BAd\u0003'tA!!3\u0002R:!\u00111ZAh\u001d\u0011\t\u0019%!4\n\u0003!K!AR$\n\u0005\u0011+\u0015B\u0001\"D\u0013\t\u0001\u0015)\u0003\u0002d\u007f%\u0019\u00111\u001c2\u0002\u000fA\f7m[1hK&!\u0011q\\Aq\u0005\u0015\u0019\u0015.V5e\u0015\r\tYN\u0019\u0015\u0004'\u0005u\u0015AD4fi\u001a{G\u000eZ3s\u0007&,\u0016\u000e\u001a\u000b\u0005\u0003{\u000bI\u000fC\u0004\u0002lR\u0001\r!!\u0010\u0002\u0011\u0019|G\u000eZ3s\u0013\u0012\f\u0001c\u00195fG.\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=\u0016\t\u0005E\u0018q\u001f\u000b\u0005\u0003\u001f\t\u0019\u0010\u0003\u0004b+\u0001\u0007\u0011Q\u001f\t\u0005\u0003\u007f\n9\u0010B\u0004\u0002\u0004V\u0011\r!!\"\u0002\tI,\u0017\rZ\u000b\u0005\u0003{\u0014\t\u0001\u0006\u0003\u0002\u0000\n\r\u0001\u0003BA@\u0005\u0003!q!a!\u0017\u0005\u0004\t)\tC\u0004\u0003\u0006Y\u0001\r!!\u0010\u0002\u001f\r|gNZ5hkJ\fG/[8o\u0013\u0012D3AFAO\u0003\u0019)\b\u000fZ1uKV!!Q\u0002B\t)\u0011\u0011yAa\u0005\u0011\t\u0005}$\u0011\u0003\u0003\b\u0003\u0007;\"\u0019AAC\u0011\u0019\tw\u00031\u0001\u0003\u0010!\u001aq#!(\u0016\t\te!Q\u0004\u000b\u0007\u00057\u0011yB!\t\u0011\t\u0005}$Q\u0004\u0003\b\u0003\u0007C\"\u0019AAC\u0011\u0019\t\u0007\u00041\u0001\u0003\u001c!9\u00111\u0018\rA\u0002\u0005u\u0006f\u0001\r\u0002\u001e\u0006ia-\u001b8e\u00032d')\u001f+za\u0016,BA!\u000b\u0003>Q!!1\u0006B !\u0019\u0011iCa\u000e\u0003<5\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$\u0001\u0003vi&d'B\u0001B\u001b\u0003\u0011Q\u0017M^1\n\t\te\"q\u0006\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0000\tuBaBAB3\t\u0007\u0011Q\u0011\u0005\b\u0005\u0003J\u0002\u0019\u0001B\"\u0003\u0019\u0019\u0017\u000eV=qKB!!Q\tB,\u001b\t\u00119E\u0003\u0003\u0003J\t-\u0013a\u0002:fM2,7\r\u001e\u0006\u0005\u0005\u001b\u0012y%A\u0002ba&TAA!\u0015\u0003T\u00051\u0001\u000f\\;hS:T1A!\u0016F\u0003!!W\r\u001d7ps&$\u0018\u0002\u0002B-\u0005\u000f\u0012A\u0001V=qK\"\u001a\u0011$!(\u0002+\u0019Lg\u000eZ!mY\nKH+\u001f9f\u0003:$G+\u001b;mKV!!\u0011\rB4)\u0019\u0011\u0019G!\u001b\u0003lA1!Q\u0006B\u001c\u0005K\u0002B!a \u0003h\u00119\u00111\u0011\u000eC\u0002\u0005\u0015\u0005b\u0002B!5\u0001\u0007!1\t\u0005\b\u0005[R\u0002\u0019AA\u001f\u0003\u0015!\u0018\u000e\u001e7fQ\rQ\u0012QT\u000b\u0005\u0005g\u0012I\b\u0006\u0006\u0003v\tm$Q\u0010B@\u0005\u0003\u0003bA!\f\u00038\t]\u0004\u0003BA@\u0005s\"q!a!\u001c\u0005\u0004\t)\tC\u0004\u0003Bm\u0001\rAa\u0011\t\u0013\t54\u0004%AA\u0002\u0005u\u0002bBAv7\u0001\u0007\u0011Q\b\u0005\b\u0005\u0007[\u0002\u0019\u0001BC\u0003)1w\u000e\u001c3fe>sG.\u001f\t\u0004\u0019\n\u001d\u0015b\u0001BE\u001b\n9!i\\8mK\u0006t\u0007fA\u000e\u0002\u001e\u0006yb-\u001b8e\u00032d')\u001f+za\u0016\fe\u000e\u001a+ji2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tE%QU\u000b\u0003\u0005'SC!!\u0010\u0003\u0016.\u0012!q\u0013\t\u0005\u00053\u0013\t+\u0004\u0002\u0003\u001c*!!Q\u0014BP\u0003%)hn\u00195fG.,GMC\u0002\u0002$5KAAa)\u0003\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005\rED1\u0001\u0002\u0006\u0006\t\"/Z1e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\t\t-&Q\u0017\u000b\u0005\u0005[\u00139\fE\u0003M\u0005_\u0013\u0019,C\u0002\u000326\u0013aa\u00149uS>t\u0007\u0003BA@\u0005k#q!a!\u001e\u0005\u0004\t)\tC\u0004\u0003:v\u0001\rAa/\u0002\u0007I|w\u000f\u0005\u0003\u0003>\n\u001dg\u0002\u0002B`\u0005\u0007tA!!1\u0003B&\u0011\u0011MY\u0005\u0004\u0005\u000b\u0004\u0017\u0001G\"p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK&!!\u0011\u001aBf\u0005A\u0019uN\u001c4jOV\u0014\u0018\r^5p]J{wOC\u0002\u0003F\u0002\f\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0005#\u00149\u000e\u0006\u0003\u0002\u0010\tM\u0007b\u0002Bk=\u0001\u0007\u0011QH\u0001\tG>tg-[4JI\u00129\u00111\u0011\u0010C\u0002\u0005\u0015\u0005f\u0001\u0010\u0002\u001e\u0006Qb-\u001b8e\u0007>tg-[4ve\u0006$\u0018n\u001c8USRdWMQ=JIR!\u0011Q\bBp\u0011\u001d\u0011)n\ba\u0001\u0003{A3aHAO\u0003Q)\u00070[:ug\nKH+\u001f9f\u0003:$G+\u001b;mKV!!q\u001dBw)\u0019\u0011)I!;\u0003l\"9!\u0011\t\u0011A\u0002\t\r\u0003\"\u0003B7AA\u0005\t\u0019AA\u001f\t\u001d\t\u0019\t\tb\u0001\u0003\u000bC3\u0001\tBy!\u0011\u0011\u0019Pa@\u000e\u0005\tU(\u0002\u0002B|\u0005s\f1\u0002\u001e:b]N\f7\r^5p]*\u0019\u0001Ia?\u000b\u0007\tu8)\u0001\u0002eE&!1\u0011\u0001B{\u0005)I5OU3bI>sG.\u001f\u0015\u0004A\u0005u\u0015AH3ySN$8OQ=UsB,\u0017I\u001c3USRdW\r\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011\tj!\u0003\u0005\u000f\u0005\r\u0015E1\u0001\u0002\u0006\u0006ya-\u001b8e\r&\u00148\u000f\u001e\"z)f\u0004X-\u0006\u0003\u0004\u0010\reA\u0003BB\t\u00077\u0001bA!\f\u0004\u0014\r]\u0011\u0002BB\u000b\u0005_\u0011\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003\u007f\u001aI\u0002B\u0004\u0002\u0004\n\u0012\r!!\"\t\u000f\t\u0005#\u00051\u0001\u0003D!\u001a!%!(\u0016\t\r\u00052q\u0005\u000b\u0007\u0007G\u0019Ica\u000b\u0011\r\t521CB\u0013!\u0011\tyha\n\u0005\u000f\u0005\r5E1\u0001\u0002\u0006\"9!\u0011I\u0012A\u0002\t\r\u0003bBB\u0017G\u0001\u00071qF\u0001\bG>tG/\u001a=u!\u0011\u0019\tda\u000f\u000e\u0005\rM\"\u0002BB\u001b\u0007o\tQb]3sS\u0006d\u0017N_1uS>t'\u0002BB\u001d\u0005'\n\u0001\u0002\u001d7v[\nLgnZ\u0005\u0005\u0007{\u0019\u0019DA\tSKN|G.\u001e;j_:\u001cuN\u001c;fqRD3aIAO\u0003\u0019)\u00070[:ugR!!QQB#\u0011\u001d\u0011)\u0001\na\u0001\u0003{A3\u0001\nByQ\r!\u0013QT\u0001\u0018O\u0016$8i\u001c8gS\u001e\u0014VMZ3sK:\u001cW\r\u001a*poN$baa\u0014\u0004l\r5\u0004CBB)\u00073\u001ayF\u0004\u0003\u0004T\r]c\u0002BA\"\u0007+J\u0011AT\u0005\u0004\u00037l\u0015\u0002BB.\u0007;\u00121aU3r\u0015\r\tY.\u0014\t\u0005\u0007C\u001a9'\u0004\u0002\u0004d)\u00191Q\r2\u0002\t\u0011\fG/Y\u0005\u0005\u0007S\u001a\u0019GA\rD_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f%><\bb\u0002B\u0003K\u0001\u0007\u0011Q\b\u0005\b\u0007_*\u0003\u0019AB9\u0003\u0005\u001awN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\ry61O\u0005\u0004\u0007k\u0002'!I\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002\u0010\rm\u0004b\u0002B\u0003M\u0001\u0007\u0011Q\b\u0015\u0004M\u0005u\u0015\u0001H4fi\u000e{gNZ5h%\u00164WM]3oG\u0016\u001c\u0018J\u001c*fY\u0016\f7/\u001a\u000b\u0005\u0007\u0007\u001bY\t\u0005\u0004\u0004R\re3Q\u0011\t\u0004a\u000e\u001d\u0015bABE\u007f\t\u0001\"+\u001a4fe\u0016t7-\u001a3F]RLG/\u001f\u0005\b\u0005\u000b9\u0003\u0019AA\u001f\u0003Q9W\r\u001e*fM\u0016\u0014XM\\2f%\u0016dW-Y:fgR!1\u0011SBP!\u0019\u0011iCa\u000e\u0004\u0014B!1QSBN\u001b\t\u00199JC\u0002\u0004\u001a\u0006\u000bQ!];fefLAa!(\u0004\u0018\n\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\b\u0005\u000bA\u0003\u0019AA\u001fQ\rA\u0013QT\u0001\u0011O\u0016$\u0018\t\u001c7Tk\n$\u0016\u0010]3t\u001f\u001a,Baa*\u0004DR!1\u0011VBa!\u0019\u0019Yk!.\u000486\u00111Q\u0016\u0006\u0005\u0007_\u001b\t,A\u0005j[6,H/\u00192mK*\u001911W'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004\\\r5\u0006\u0003BB]\u0007\u007fk!aa/\u000b\t\ru&1G\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\rm\u0006b\u0002B!S\u0001\u0007!1\t\u0003\b\u0003\u0007K#\u0019AAC\u0003-9W\r^!mYRK\b/Z:\u0016\u0005\r%\u0007CBB)\u00073\ni\u0004K\u0002+\u0003;\u000bQ\u0002Z3mKR,')\u001f+za\u0016\u001cH\u0003BA\b\u0007#Dqaa5,\u0001\u0004\u0019I-A\u0004dSRK\b/Z:)\u0007-\ni*\u0001\u0005wC2LG-\u0019;f)\u0011\tyaa7\t\r\u0005d\u0003\u0019AAGQ\r\u00011q\u001c\t\u0005\u0005g\u001c\t/\u0003\u0003\u0004d\nU(aD%t)J\fgn]1di&|g.\u00197\u00025M\u000bHnQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005At3C\u0001\u0018L)\t\u00199OA\u0004UsB,w\n]:\u0014\u0005AZ\u0015A\u0002=m)f\u0004X\r\u0006\u0003\u0004v\u000ee\bcAB|a5\ta\u0006C\u0004\u0004rJ\u0002\rAa\u0011\u0002\u001d!\f7oQ1sI&t\u0017\r\\5usV\u0011!QQ\u0001\fQ\u0006\u001c\bK]8qKJ$\u0018\u0010\u0006\u0003\u0003\u0006\u0012\r\u0001b\u0002C\u0003i\u0001\u0007\u0011QH\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\b)f\u0004Xm\u00149t)\u0011\u0019)\u0010b\u0003\t\u000f\rEX\u00071\u0001\u0003D\t!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN\u001c\"AN&\u0002\u0005\rLG\u0003\u0002C\u000b\t/\u00012aa>7\u0011\u001d!\t\u0002\u000fa\u0001\u0003\u001b+\"Aa\u0011\u0002\u000f\rLG+\u001f9fA\u0005qq-\u001a;DCJ$\u0017N\\1mSRLXC\u0001C\u0011!\u0015a%q\u0016C\u0012!\raEQE\u0005\u0004\tOi%aA%oi\u0006!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN$B\u0001\"\u0006\u0005.!9A\u0011C\u001fA\u0002\u00055\u0005")
public class SqlConfigurationRepository
implements ConfigurationRepository,
Logging {
    private final ConfigurationPersistence configurationPersistence;
    private final ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final FolderPersistence folderPersistence;
    @Autowired
    private ReleaseRepository releaseRepository;
    private final String RELEASE;
    private final String TEMPLATE;
    private final String TRIGGER;
    private final ObjectMapper mapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ThemeSettings getThemeSettings() {
        return ConfigurationRepository.getThemeSettings$((ConfigurationRepository)this);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<BaseConfiguration> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfigurationRepository sqlConfigurationRepository = this;
        synchronized (sqlConfigurationRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public void releaseRepository_$eq(ReleaseRepository x$1) {
        this.releaseRepository = x$1;
    }

    private String RELEASE() {
        return this.RELEASE;
    }

    private String TEMPLATE() {
        return this.TEMPLATE;
    }

    private String TRIGGER() {
        return this.TRIGGER;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration) {
        return this.create(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration, Integer folderCiUid) {
        this.checkCardinality(configuration);
        this.validate(configuration);
        this.interceptCreate((ConfigurationItem)configuration);
        this.configurationPersistence.insert(configuration, folderCiUid);
        this.afterCreate((ConfigurationItem)configuration);
        return configuration;
    }

    private Integer getFolderCiUid(String folderId) {
        Integer n;
        block3: {
            String string = folderId;
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string != null) break;
                    n = null;
                    break block3;
                }
            }
            n = this.folderPersistence.getUid(string);
        }
        return n;
    }

    private <T extends BaseConfiguration> void checkCardinality(T configuration) {
        Type configurationType = Type.valueOf(BaseConfiguration.class);
        if (SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).hasCardinality()) {
            Type configGroupType = (Type)SqlConfigurationRepository.groupType$1(configuration, configurationType).getOrElse((Function0 & Serializable)() -> configuration.getType());
            Buffer foundConfigs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.findAllByTypeAndTitle(configGroupType, null, configuration.getFolderId(), false)).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$3(configuration, x$2)));
            Option<Object> cardinality = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).getCardinality();
            if (cardinality.isDefined() && foundConfigs.size() >= BoxesRunTime.unboxToInt((Object)cardinality.get())) {
                String folderId = configuration.getFolderId() == null ? Ids.ROOT_FOLDER_ID : configuration.getFolderId();
                throw new ItemAlreadyExistsException(new StringBuilder(60).append("There are already ").append(foundConfigs.length()).append(" items of type '").append(configGroupType).append("' defined on the folder '").append(folderId).append("'").toString(), new Object[0]);
            }
        }
    }

    @Timed
    public <T extends BaseConfiguration> T read(String configurationId) {
        return (T)((BaseConfiguration)Option$.MODULE$.apply(this.sqlRepositoryAdapter.read(configurationId)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Configuration ").append(configurationId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration) {
        return this.update(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration, Integer folderCiUid) {
        this.validate(configuration);
        this.interceptUpdate((ConfigurationItem)configuration);
        this.configurationPersistence.update(configuration);
        this.afterUpdate((ConfigurationItem)configuration);
        return configuration;
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByType(Type ciType) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypes(this.getAllSubTypesOf(ciType)).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title) {
        return this.findAllByTypeAndTitle(ciType, title, null, false);
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title, String folderId, boolean folderOnly) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypesTitleAndFolder(this.getAllSubTypesOf(ciType), (Option<String>)Option$.MODULE$.apply((Object)title).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3.trim())))), (Option<Either<String, String>>)Option$.MODULE$.apply((Object)folderId).map((Function1)(folderOnly ? (Function1 & Serializable)value -> package$.MODULE$.Right().apply(value) : (Function1 & Serializable)value -> package$.MODULE$.Left().apply(value)))).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    public <T extends BaseConfiguration> String findAllByTypeAndTitle$default$2() {
        return null;
    }

    private <T extends BaseConfiguration> Option<T> readConfiguration(Tuple2<Option<FolderId>, String> row) {
        Tuple2<Option<FolderId>, String> tuple2 = row;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option folderIdOpt = (Option)tuple2._1();
        String rawConfiguration = (String)tuple2._2();
        Option option = this.sqlRepositoryAdapter.deserialize(rawConfiguration).map((Function1 & Serializable)conf -> (BaseConfiguration)folderIdOpt.fold((Function0 & Serializable)() -> conf, (Function1 & Serializable)folderId -> {
            conf.setFolderId(folderId.absolute());
            return conf;
        }));
        return option;
    }

    @Timed
    public <T extends BaseConfiguration> void findById(String configId) {
        this.configurationPersistence.findById(configId);
    }

    @Timed
    public String findConfigurationTitleById(String configId) {
        return this.configurationPersistence.findConfigurationTitleById(configId);
    }

    @Timed
    @IsReadOnly
    public <T extends BaseConfiguration> boolean existsByTypeAndTitle(Type ciType, String title) {
        return this.configurationPersistence.existsByTypeAndTitle(this.getAllSubTypesOf(ciType), title);
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType) {
        return this.findFirstByType(ciType, ResolutionContext$.MODULE$.GLOBAL());
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType, ResolutionContext context) {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.configurationPersistence.findFirstByTypes(this.getAllSubTypesOf(ciType), (Option<String>)context.folderId()).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))));
    }

    @Timed
    @IsReadOnly
    public boolean exists(String configurationId) {
        return this.configurationPersistence.exists(configurationId);
    }

    public <T extends BaseConfiguration> String existsByTypeAndTitle$default$2() {
        return null;
    }

    private scala.collection.immutable.Seq<ConfigurationReferenceRow> getConfigReferencedRows(String configurationId, ConfigurationReferencePersistence configurationReferencePersistence) {
        return configurationReferencePersistence.isReferenced(configurationId) ? configurationReferencePersistence.getReferencingEntities(configurationId) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    @Timed
    public void delete(String configurationId) {
        SeqOps seqOps;
        scala.collection.immutable.Seq configReferencesInTrigger;
        scala.collection.immutable.Seq<ReferencedEntity> configReferencesInRelease = this.getConfigReferencesInRelease(configurationId);
        scala.collection.immutable.Seq allReferences = (scala.collection.immutable.Seq)configReferencesInRelease.$plus$plus((IterableOnce)(configReferencesInTrigger = (scala.collection.immutable.Seq)this.getConfigReferencedRows(configurationId, this.triggerConfigurationReferencePersistence).map((Function1 & Serializable)configRef -> new ReferencedEntity(configRef.id(), configRef.title(), "Trigger"))));
        scala.collection.immutable.Seq seq = allReferences;
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) != 0) {
            this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            String json = this.mapper().writeValueAsString((Object)allReferences);
            throw new ItemInUseException("%s", new Object[]{json});
        }
        this.interceptDelete(configurationId);
        this.configurationPersistence.delete(configurationId);
        this.afterDelete(configurationId);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getConfigReferencesInRelease(String configurationId) {
        scala.collection.immutable.Seq<ConfigurationReferenceRow> configReferences = this.getConfigReferencedRows(configurationId, this.releaseConfigurationReferencePersistence);
        scala.collection.immutable.Seq ids = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> Ids.getFolderlessId((String)ref.id()));
        scala.collection.immutable.Seq statusesWithIds = this.releaseRepository().getStatusesWithIds(ids);
        scala.collection.immutable.Seq configRefsWithFolderlessIds = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> new ConfigurationReferenceRow(ref.title(), ref.id()));
        return (scala.collection.immutable.Seq)configRefsWithFolderlessIds.map((Function1 & Serializable)reference -> {
            String folderlessId = Ids.getFolderlessId((String)reference.id());
            ReleaseStatus status = (ReleaseStatus)((Tuple2)((IterableOps)statusesWithIds.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$getConfigReferencesInRelease$4(folderlessId, t)))).head())._2();
            ReleaseStatus releaseStatus = status;
            String string = ReleaseStatus.TEMPLATE.equals(releaseStatus) ? "Template" : "Release";
            String referencedBy = string;
            return new ReferencedEntity(reference.id(), reference.title(), referencedBy);
        });
    }

    @Timed
    public List<ReleaseBasicData> getReferenceReleases(String configurationId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.releaseConfigurationReferencePersistence.getReferencingEntities(configurationId).map((Function1 & Serializable)x$4 -> ConfigurationReferenceRow$.MODULE$.ConfigurationReferenceDataOps((ConfigurationReferenceRow)x$4).asReleaseData())).asJava();
    }

    private <T extends BaseConfiguration> scala.collection.immutable.Seq<String> getAllSubTypesOf(Type ciType) {
        return (scala.collection.immutable.Seq)TypeHelper$.MODULE$.getAllSubtypesOf(ciType).map((Function1 & Serializable)x$5 -> x$5.toString());
    }

    @Timed
    public scala.collection.immutable.Seq<String> getAllTypes() {
        return this.configurationPersistence.findAllConfigurationTypes();
    }

    @Timed
    public void deleteByTypes(scala.collection.immutable.Seq<String> ciTypes) {
        scala.collection.immutable.Seq<Integer> configurationCiUids = this.configurationPersistence.findUidsByTypes(ciTypes);
        this.releaseConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.triggerConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.configurationPersistence.deleteByTypes(ciTypes);
    }

    private void validate(BaseConfiguration configuration) {
        ListBuffer passVarUsagePoints = ListBuffer$.MODULE$.empty();
        BaseConfiguration baseConfiguration = configuration;
        if (baseConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)baseConfiguration;
            ConfigurationVariableService$.MODULE$.getUsagePointsByVars((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration[]{configuration2}))).values().foreach((Function1 & Serializable)usagePoints -> {
                usagePoints.foreach((Function1 & Serializable)up -> {
                    CiProperty targetProperty = up.getTargetProperty();
                    PropertyDescriptor desc = targetProperty.getDescriptor();
                    PropertyKind propertyKind = desc.getKind();
                    PropertyKind propertyKind2 = PropertyKind.STRING;
                    Checks.checkArgument((!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && desc.isPassword() ? 1 : 0) != 0, (String)"Non-password-type variables in configuration variableMapping are not supported", (Object[])new Object[0]);
                    targetProperty.setValue((Object)"<temporary_value>");
                    return (ListBuffer)passVarUsagePoints$1.$plus$eq(up);
                });
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Descriptor desc = configuration.getType().getDescriptor();
        ExtendedValidationContextImpl extendedValidationContext = new ExtendedValidationContextImpl((ConfigurationItem)configuration);
        desc.validate((ExtendedValidationContext)extendedValidationContext, (ConfigurationItem)configuration);
        List messages = extendedValidationContext.getMessages();
        Object object = !messages.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)configuration.get$validationMessages().addAll(messages)) : BoxedUnit.UNIT;
        if (!configuration.get$validationMessages().isEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)configuration);
        }
        passVarUsagePoints.toList().foreach((Function1 & Serializable)up -> {
            SqlConfigurationRepository.$anonfun$validate$3(up);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCardinality$1(Type configurationType$1, BaseConfiguration configuration$1, Type superType) {
        if (!superType.isSubTypeOf(configurationType$1)) return false;
        if (!SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$TypeOps(superType).hasCardinality()) return false;
        Integer n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)superType.getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()));
        Option<Object> option = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration$1).getCardinality();
        if (n != null) {
            if (!((Object)n).equals(option)) return false;
            return true;
        }
        if (option == null) return true;
        return false;
    }

    private static final Option groupType$1(BaseConfiguration configuration, Type configurationType$1) {
        List superClasses = configuration.getType().getDescriptor().getSuperClasses();
        return CollectionConverters$.MODULE$.ListHasAsScala(superClasses).asScala().find((Function1 & Serializable)superType -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$1(configurationType$1, configuration, superType)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCardinality$3(BaseConfiguration configuration$2, BaseConfiguration x$2) {
        String string = x$2.getFolderId();
        String string2 = configuration$2.getFolderId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConfigReferencesInRelease$4(String folderlessId$1, Tuple2 t) {
        return ((String)t._1()).equals(folderlessId$1);
    }

    public static final /* synthetic */ void $anonfun$validate$3(UsagePoint up) {
        up.getTargetProperty().setValue(null);
    }

    public SqlConfigurationRepository(ConfigurationPersistence configurationPersistence, ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, SqlRepositoryAdapter sqlRepositoryAdapter, FolderPersistence folderPersistence) {
        this.configurationPersistence = configurationPersistence;
        this.releaseConfigurationReferencePersistence = releaseConfigurationReferencePersistence;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.folderPersistence = folderPersistence;
        InterceptedRepository.$init$((InterceptedRepository)this);
        ConfigurationRepository.$init$((ConfigurationRepository)this);
        Logging.$init$((Logging)this);
        this.RELEASE = "Release";
        this.TEMPLATE = "Template";
        this.TRIGGER = "Trigger";
        this.mapper = new ObjectMapper();
    }

    private static class BaseConfigurationOps {
        private final BaseConfiguration ci;
        private final Type ciType;

        private Type ciType() {
            return this.ciType;
        }

        public boolean hasCardinality() {
            return this.ci.hasProperty("cardinality");
        }

        public Option<Object> getCardinality() {
            return this.hasCardinality() ? new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ciType().getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()))) : None$.MODULE$;
        }

        public BaseConfigurationOps(BaseConfiguration ci) {
            this.ci = ci;
            this.ciType = ci.getType();
        }
    }

    private static class TypeOps {
        private final Type xlType;

        public boolean hasCardinality() {
            return this.hasProperty("cardinality");
        }

        public boolean hasProperty(String propertyName) {
            return this.xlType.getDescriptor().getPropertyDescriptor(propertyName) != null;
        }

        public TypeOps(Type xlType) {
            this.xlType = xlType;
        }
    }
}

