package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.security.sql.db.SecuritySchema.{ROLES, ROLE_PERMISSIONS, ROLE_PRINCIPALS, ROLE_ROLES}

trait SecurableSqlBuilder {
  protected def selectCiIdsWithPermission(principalNames: Iterable[String], roleIds: Iterable[String]): String = {
    s"""|SELECT DISTINCT teamPermissions.${ROLE_PERMISSIONS.ciId}
        |FROM
        |  ${ROLES.TABLE} teams
        |  LEFT JOIN ${ROLE_ROLES.TABLE} teamRoles ON teams.${ROLES.id} = teamRoles.${ROLE_ROLES.roleId}
        |  LEFT JOIN ${ROLE_PRINCIPALS.TABLE} teamPrincipals ON teams.${ROLES.id} = teamPrincipals.${ROLE_PRINCIPALS.roleId}
        |  JOIN ${ROLE_PERMISSIONS.TABLE} teamPermissions ON teams.${ROLES.id} = teamPermissions.${ROLE_PERMISSIONS.roleId}
        |WHERE
        |  teamPermissions.${ROLE_PERMISSIONS.permissionName} = ?
        |  AND (
        |    LOWER(teamPrincipals.${ROLE_PRINCIPALS.principalName}) IN (${principalNames.map(_ => "LOWER(?)").mkString(",")})
        |    ${if (roleIds.nonEmpty) s"OR teamRoles.${ROLE_ROLES.memberRoleId} IN (${roleIds.map(_ => "?").mkString(",")})" else ""}
        |  )""".stripMargin
  }

  protected def selectCiIdsWithPermissions(permissionNames: Iterable[String], principalNames: Iterable[String], roleIds: Iterable[String]): String = {
    s"""|SELECT DISTINCT teamPermissions.${ROLE_PERMISSIONS.ciId}
        |FROM
        |  ${ROLES.TABLE} teams
        |  LEFT JOIN ${ROLE_ROLES.TABLE} teamRoles ON teams.${ROLES.id} = teamRoles.${ROLE_ROLES.roleId}
        |  LEFT JOIN ${ROLE_PRINCIPALS.TABLE} teamPrincipals ON teams.${ROLES.id} = teamPrincipals.${ROLE_PRINCIPALS.roleId}
        |  JOIN ${ROLE_PERMISSIONS.TABLE} teamPermissions ON teams.${ROLES.id} = teamPermissions.${ROLE_PERMISSIONS.roleId}
        |WHERE
        |  teamPermissions.${ROLE_PERMISSIONS.permissionName} IN (${permissionNames.map(_ => "?").mkString(",")})
        |  AND (
        |    LOWER(teamPrincipals.${ROLE_PRINCIPALS.principalName}) IN (${principalNames.map(_ => "LOWER(?)").mkString(",")})
        |    ${if (roleIds.nonEmpty) s"OR teamRoles.${ROLE_ROLES.memberRoleId} IN (${roleIds.map(_ => "?").mkString(",")})" else ""}
        |  )""".stripMargin
  }
}
