package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.deployit.security.{PermissionEditor, Role}
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.repository.Ids.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.security.XlrPermissionLabels.PermissionOperations
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import java.util
import scala.collection.mutable
import scala.jdk.CollectionConverters._

@Component
class XLRelease220CreatePermissionUpgrade(folderPersistence: FolderPersistence, permissionEditor: PermissionEditor)
  extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#3")

  override def doUpgrade(): Boolean = {
    logger.info(s"Adding ${CREATE_RELEASE_IN_ANOTHER_FOLDER.label()}")
    updateCreatePermissionInAnotherFolder()
    logger.info(s"Finished adding ${CREATE_RELEASE_IN_ANOTHER_FOLDER.label()}")
    true
  }

  /**
   * Grant CREATE_RELEASE_IN_ANOTHER_FOLDER permission to all roles that previously had VIEW_TEMPLATE permission
   */
  def updateCreatePermissionInAnotherFolder(): Unit = {
    val folderUids = folderPersistence.findDescendantsById(ROOT_FOLDER_ID).map(r => r.uid).distinct
    for (folderUid <- folderUids) {
      val roleToPermissions: mutable.Map[Role, util.Set[Permission]] = permissionEditor.readPermissions(folderUid.toString, false).asScala
      roleToPermissions.collect {
        case (role, permissions) if permissions.contains(VIEW_TEMPLATE) =>
          permissions.add(CREATE_RELEASE_IN_ANOTHER_FOLDER)
          permissionEditor.editPermissions(folderUid.toString(), roleToPermissions.asJava)
          role
      }
    }
  }
}
