package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.xlrelease.repository.sql.persistence.CiId.CiId
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{FOLDERS, FOLDER_VARIABLES}
import com.xebialabs.xlrelease.repository.sql.persistence.{CiUid, CompressionSupport}
import com.xebialabs.xlrelease.utils.FolderId
import resource._

import java.sql.ResultSet

case class FolderVariableRow(ciUid: CiUid, id: CiId, folderId: FolderId, ciType: String, key: String, json: String)

object FolderVariableRow extends CompressionSupport {
  def fromDatabase(rs: ResultSet): FolderVariableRow = {
    val data = managed(rs.getBinaryStream(FOLDER_VARIABLES.CONTENT)).acquireAndGet(decompress)

    FolderVariableRow(
      ciUid = rs.getInt(FOLDER_VARIABLES.CI_UID),
      id = rs.getString(FOLDER_VARIABLES.ID),
      folderId = FolderId(rs.getString(FOLDERS.FOLDER_PATH)) / rs.getString(FOLDERS.FOLDER_ID),
      ciType = rs.getString(FOLDER_VARIABLES.CI_TYPE),
      key = rs.getString(FOLDER_VARIABLES.KEY),
      json = data
    )
  }
}
