/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlConfigurationRepository$;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ReleaseConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.validation.ExtendedValidationContextImpl;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r%e\u0001\u0002\u00192\u0001qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t1\u0002\u0011\t\u0011)A\u00053\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!)\u0007A!A!\u0002\u00131\u0007\"\u00026\u0001\t\u0003Y\u0007\"\u0002:\u0001\t\u0003\u001a\bB\u0002:\u0001\t\u0003\ny\u0002C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0005\b\u0003+\u0003A\u0011IAR\u0011\u001d\t\t\f\u0001C!\u0003gCq!!;\u0001\t\u0003\nY\u000fC\u0004\u0002j\u0002!\t%!@\t\u0013\te\u0001!%A\u0005\u0002\tm\u0001b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u00053\u0002A\u0011\u0001B.\u0011%\u0011Y\bAI\u0001\n\u0003\u0011i\bC\u0004\u0003\u0002\u0002!\tEa!\t\u000f\t\u0005\u0005\u0001\"\u0011\u0003\u0016\"9!q\u0017\u0001\u0005B\te\u0006b\u0002Ba\u0001\u0011%!1\u0019\u0005\b\u0005#\u0004A\u0011\tBj\u0011\u001d\u0011I\u000e\u0001C!\u00057DqAa<\u0001\t\u0013\u0011\t\u0010C\u0004\u0004\u0014\u0001!\te!\u0006\t\u000f\r\u001d\u0002\u0001\"\u0011\u0004*!91\u0011\u0007\u0001\u0005\n\rMraBB c!\u00051\u0011\t\u0004\u0007aEB\taa\u0011\t\r)\u0004C\u0011AB#\r\u0019\u00199\u0005I\u0003\u0004J!Q11\n\u0012\u0003\u0002\u0003\u0006I!a4\t\r)\u0014C\u0011AB'\u0011\u001d\u0019)F\tC\u0001\u0007/Bqa!\u0017#\t\u0003\u0019Y\u0006C\u0005\u0004b\u0001\n\t\u0011b\u0003\u0004d\u001911q\r\u0011\u0006\u0007SB\u0011ba\u001b)\u0005\u0003\u0005\u000b\u0011B?\t\r)DC\u0011AB7\u0011%\ti\r\u000bb\u0001\n\u0013\u0019\u0019\b\u0003\u0005\u0004v!\u0002\u000b\u0011BAh\u0011\u001d\u0019)\u0006\u000bC\u0001\u0007/Bqaa\u001e)\t\u0003\u0019I\bC\u0005\u0004\u0004\u0002\n\t\u0011b\u0003\u0004\u0006\nQ2+\u001d7D_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss*\u0011!gM\u0001\u0004gFd'B\u0001\u001b6\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003m]\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005aJ\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0014aA2p[\u000e\u00011\u0003\u0002\u0001>\u0007\u001e\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#F\u001b\u0005\u0019\u0014B\u0001$4\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)1\u000f\u001c45U*\tA*\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0015JA\u0004M_\u001e<\u0017N\\4\u00021\r|gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002R-6\t!K\u0003\u0002T)\u0006i1m\u001c8gS\u001e,(/\u0019;j_:T!!V\u0019\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003/J\u0013\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003!\u0012X\r\\3bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\t\t&,\u0003\u0002\\%\nA#+\u001a7fCN,7i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006ACO]5hO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dKB\u0011\u0011KX\u0005\u0003?J\u0013\u0001\u0006\u0016:jO\u001e,'oQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\fAc]9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\bC\u00012d\u001b\u0005\t\u0014B\u000132\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\tbm\u001c7eKJ\u0004VM]:jgR,gnY3\u0011\u0005\u001dDW\"\u0001+\n\u0005%$&!\u0005$pY\u0012,'\u000fU3sg&\u001cH/\u001a8dK\u00061A(\u001b8jiz\"b\u0001\\7o_B\f\bC\u00012\u0001\u0011\u0015ye\u00011\u0001Q\u0011\u0015Af\u00011\u0001Z\u0011\u0015af\u00011\u0001^\u0011\u0015\u0001g\u00011\u0001b\u0011\u0015)g\u00011\u0001g\u0003\u0019\u0019'/Z1uKV\u0011Ao\u001e\u000b\u0004k\u0006\u001d\u0001C\u0001<x\u0019\u0001!Q\u0001_\u0004C\u0002e\u0014\u0011\u0001V\t\u0003uv\u0004\"AP>\n\u0005q|$a\u0002(pi\"Lgn\u001a\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q'\u0001\u0004e_6\f\u0017N\\\u0005\u0004\u0003\u000by(!\u0005\"bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")1k\u0002a\u0001k\"\u001aq!a\u0003\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005U\u0011qC\u0001\b[\u0016$(/[2t\u0015\r\tI\"O\u0001\tG>$\u0017\r[1mK&!\u0011QDA\b\u0005\u0015!\u0016.\\3e+\u0011\t\t#!\n\u0015\r\u0005\r\u0012qEA\u0015!\r1\u0018Q\u0005\u0003\u0006q\"\u0011\r!\u001f\u0005\u0007'\"\u0001\r!a\t\t\u000f\u0005-\u0002\u00021\u0001\u0002.\u0005Yam\u001c7eKJ\u001c\u0015.V5e!\u0011\ty#a\u0015\u000f\t\u0005E\u0012q\n\b\u0005\u0003g\tiE\u0004\u0003\u00026\u0005-c\u0002BA\u001c\u0003\u0013rA!!\u000f\u0002H9!\u00111HA#\u001d\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!w\u00051AH]8pizJ\u0011AO\u0005\u0003qeJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\t)\u0016'C\u0002\u0002RQ\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002V\u0005]#!B\"j+&$'bAA))\"\u001a\u0001\"a\u0003\u0002\u001d\u001d,GOR8mI\u0016\u00148)[+jIR!\u0011QFA0\u0011\u001d\t\t'\u0003a\u0001\u0003G\n\u0001BZ8mI\u0016\u0014\u0018\n\u001a\t\u0005\u0003K\niG\u0004\u0003\u0002h\u0005%\u0004cAA\u001f\u007f%\u0019\u00111N \u0002\rA\u0013X\rZ3g\u0013\u0011\ty'!\u001d\u0003\rM#(/\u001b8h\u0015\r\tYgP\u0001\u0011G\",7m[\"be\u0012Lg.\u00197jif,B!a\u001e\u0002\u0004R!\u0011\u0011PA@!\rq\u00141P\u0005\u0004\u0003{z$\u0001B+oSRDaa\u0015\u0006A\u0002\u0005\u0005\u0005c\u0001<\u0002\u0004\u0012)\u0001P\u0003b\u0001s\u0006!!/Z1e+\u0011\tI)!$\u0015\t\u0005-\u0015q\u0012\t\u0004m\u00065E!\u0002=\f\u0005\u0004I\bbBAI\u0017\u0001\u0007\u00111M\u0001\u0010G>tg-[4ve\u0006$\u0018n\u001c8JI\"\u001a1\"a\u0003\u0002\rU\u0004H-\u0019;f+\u0011\tI*!(\u0015\t\u0005m\u0015q\u0014\t\u0004m\u0006uE!\u0002=\r\u0005\u0004I\bBB*\r\u0001\u0004\tY\nK\u0002\r\u0003\u0017)B!!*\u0002*R1\u0011qUAV\u0003[\u00032A^AU\t\u0015AXB1\u0001z\u0011\u0019\u0019V\u00021\u0001\u0002(\"9\u00111F\u0007A\u0002\u00055\u0002fA\u0007\u0002\f\u0005ia-\u001b8e\u00032d')\u001f+za\u0016,B!!.\u0002JR!\u0011qWAf!\u0019\tI,a1\u0002H6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003vi&d'BAAa\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00171\u0018\u0002\u0005\u0019&\u001cH\u000fE\u0002w\u0003\u0013$Q\u0001\u001f\bC\u0002eDq!!4\u000f\u0001\u0004\ty-\u0001\u0004dSRK\b/\u001a\t\u0005\u0003#\f\u0019/\u0004\u0002\u0002T*!\u0011Q[Al\u0003\u001d\u0011XM\u001a7fGRTA!!7\u0002\\\u0006\u0019\u0011\r]5\u000b\t\u0005u\u0017q\\\u0001\u0007a2,x-\u001b8\u000b\u0007\u0005\u0005x'\u0001\u0005eKBdw._5u\u0013\u0011\t)/a5\u0003\tQK\b/\u001a\u0015\u0004\u001d\u0005-\u0011!\u00064j]\u0012\fE\u000e\u001c\"z)f\u0004X-\u00118e)&$H.Z\u000b\u0005\u0003[\f\u0019\u0010\u0006\u0004\u0002p\u0006U\u0018q\u001f\t\u0007\u0003s\u000b\u0019-!=\u0011\u0007Y\f\u0019\u0010B\u0003y\u001f\t\u0007\u0011\u0010C\u0004\u0002N>\u0001\r!a4\t\u000f\u0005ex\u00021\u0001\u0002d\u0005)A/\u001b;mK\"\u001aq\"a\u0003\u0016\t\u0005}(Q\u0001\u000b\u000b\u0005\u0003\u00119A!\u0003\u0003\f\t5\u0001CBA]\u0003\u0007\u0014\u0019\u0001E\u0002w\u0005\u000b!Q\u0001\u001f\tC\u0002eDq!!4\u0011\u0001\u0004\ty\rC\u0005\u0002zB\u0001\n\u00111\u0001\u0002d!9\u0011\u0011\r\tA\u0002\u0005\r\u0004b\u0002B\b!\u0001\u0007!\u0011C\u0001\u000bM>dG-\u001a:P]2L\bc\u0001 \u0003\u0014%\u0019!QC \u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001#a\u0003\u0002?\u0019Lg\u000eZ!mY\nKH+\u001f9f\u0003:$G+\u001b;mK\u0012\"WMZ1vYR$#'\u0006\u0003\u0003\u001e\tERC\u0001B\u0010U\u0011\t\u0019G!\t,\u0005\t\r\u0002\u0003\u0002B\u0013\u0005[i!Aa\n\u000b\t\t%\"1F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0005@\u0013\u0011\u0011yCa\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003y#\t\u0007\u00110A\tsK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:,BAa\u000e\u0003BQ!!\u0011\bB\"!\u0015q$1\bB \u0013\r\u0011id\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007Y\u0014\t\u0005B\u0003y%\t\u0007\u0011\u0010C\u0004\u0003FI\u0001\rAa\u0012\u0002\u0007I|w\u000f\u0005\u0003\u0003J\tMc\u0002\u0002B&\u0005\u001frA!!\r\u0003N%\u00111\u000bV\u0005\u0004\u0005#\u0012\u0016\u0001G\"p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK&!!Q\u000bB,\u0005A\u0019uN\u001c4jOV\u0014\u0018\r^5p]J{wOC\u0002\u0003RI\u000bA#\u001a=jgR\u001c()\u001f+za\u0016\fe\u000e\u001a+ji2,W\u0003\u0002B/\u0005G\"bA!\u0005\u0003`\t\u0005\u0004bBAg'\u0001\u0007\u0011q\u001a\u0005\n\u0003s\u001c\u0002\u0013!a\u0001\u0003G\"Q\u0001_\nC\u0002eD3a\u0005B4!\u0011\u0011IG!\u001e\u000e\u0005\t-$\u0002\u0002B7\u0005_\n1\u0002\u001e:b]N\f7\r^5p]*\u0019!G!\u001d\u000b\u0007\tMT'\u0001\u0002eE&!!q\u000fB6\u0005)I5OU3bI>sG.\u001f\u0015\u0004'\u0005-\u0011AH3ySN$8OQ=UsB,\u0017I\u001c3USRdW\r\n3fM\u0006,H\u000e\u001e\u00133+\u0011\u0011iBa \u0005\u000ba$\"\u0019A=\u0002\u001f\u0019Lg\u000e\u001a$jeN$()\u001f+za\u0016,BA!\"\u0003\u0010R!!q\u0011BI!\u0019\tIL!#\u0003\u000e&!!1RA^\u0005!y\u0005\u000f^5p]\u0006d\u0007c\u0001<\u0003\u0010\u0012)\u00010\u0006b\u0001s\"9\u0011QZ\u000bA\u0002\u0005=\u0007fA\u000b\u0002\fU!!q\u0013BO)\u0019\u0011IJa(\u0003\"B1\u0011\u0011\u0018BE\u00057\u00032A\u001eBO\t\u0015AhC1\u0001z\u0011\u001d\tiM\u0006a\u0001\u0003\u001fDqAa)\u0017\u0001\u0004\u0011)+A\u0004d_:$X\r\u001f;\u0011\t\t\u001d&\u0011W\u0007\u0003\u0005SSAAa+\u0003.\u0006i1/\u001a:jC2L'0\u0019;j_:TAAa,\u0002`\u0006A\u0001\u000f\\;nE&tw-\u0003\u0003\u00034\n%&!\u0005*fg>dW\u000f^5p]\u000e{g\u000e^3yi\"\u001aa#a\u0003\u0002\r\u0015D\u0018n\u001d;t)\u0011\u0011\tBa/\t\u000f\u0005Eu\u00031\u0001\u0002d!\u001aqCa\u001a)\u0007]\tY!A\u0006dQ\u0016\u001c7\u000eR3mKR,GCBA=\u0005\u000b\u00149\rC\u0004\u0002\u0012b\u0001\r!a\u0019\t\u000f\t%\u0007\u00041\u0001\u0003L\u0006\t3m\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dKB\u0019\u0011K!4\n\u0007\t='KA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003s\u0012)\u000eC\u0004\u0002\u0012f\u0001\r!a\u0019)\u0007e\tY!\u0001\u000bhKR\u0014VMZ3sK:\u001cWMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0005;\u0014Y\u000f\u0005\u0004\u0002:\u0006\r'q\u001c\t\u0005\u0005C\u00149/\u0004\u0002\u0003d*\u0019!Q]\u001a\u0002\u000bE,XM]=\n\t\t%(1\u001d\u0002\u0011%\u0016dW-Y:f\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!!%\u001b\u0001\u0004\t\u0019\u0007K\u0002\u001b\u0003\u0017\t\u0001cZ3u\u00032d7+\u001e2UsB,7o\u00144\u0016\t\tM8\u0011\u0003\u000b\u0005\u0005k\u001cy\u0001\u0005\u0004\u0003x\u000e\u00051QA\u0007\u0003\u0005sTAAa?\u0003~\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0005\u007f|\u0014AC2pY2,7\r^5p]&!11\u0001B}\u0005\r\u0019V-\u001d\t\u0005\u0007\u000f\u0019i!\u0004\u0002\u0004\n)!11BA`\u0003\u0011a\u0017M\\4\n\t\u0005=4\u0011\u0002\u0005\b\u0003\u001b\\\u0002\u0019AAh\t\u0015A8D1\u0001z\u0003-9W\r^!mYRK\b/Z:\u0016\u0005\r]\u0001CBB\r\u0007C\t\u0019G\u0004\u0003\u0004\u001c\r}a\u0002BA\u001f\u0007;I\u0011\u0001Q\u0005\u0004\u0003#z\u0014\u0002BB\u0002\u0007GQ1!!\u0015@Q\ra\u00121B\u0001\u000eI\u0016dW\r^3CsRK\b/Z:\u0015\t\u0005e41\u0006\u0005\b\u0007[i\u0002\u0019AB\f\u0003\u001d\u0019\u0017\u000eV=qKND3!HA\u0006\u0003!1\u0018\r\\5eCR,G\u0003BA=\u0007kAQa\u0015\u0010A\u0002uD3\u0001AB\u001d!\u0011\u0011Iga\u000f\n\t\ru\"1\u000e\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006Q2+\u001d7D_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011!\rI\n\u0003Au\"\"a!\u0011\u0003\u000fQK\b/Z(qgN\u0011!%P\u0001\u0007q2$\u0016\u0010]3\u0015\t\r=31\u000b\t\u0004\u0007#\u0012S\"\u0001\u0011\t\u000f\r-C\u00051\u0001\u0002P\u0006q\u0001.Y:DCJ$\u0017N\\1mSRLXC\u0001B\t\u0003-A\u0017m\u001d)s_B,'\u000f^=\u0015\t\tE1Q\f\u0005\b\u0007?2\u0003\u0019AA2\u00031\u0001(o\u001c9feRLh*Y7f\u0003\u001d!\u0016\u0010]3PaN$Baa\u0014\u0004f!911J\u0014A\u0002\u0005='\u0001\u0006\"bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]>\u00038o\u0005\u0002){\u0005\u00111-\u001b\u000b\u0005\u0007_\u001a\t\bE\u0002\u0004R!Baaa\u001b+\u0001\u0004iXCAAh\u0003\u001d\u0019\u0017\u000eV=qK\u0002\nabZ3u\u0007\u0006\u0014H-\u001b8bY&$\u00180\u0006\u0002\u0004|A)aHa\u000f\u0004~A\u0019aha \n\u0007\r\u0005uHA\u0002J]R\fACQ1tK\u000e{gNZ5hkJ\fG/[8o\u001fB\u001cH\u0003BB8\u0007\u000fCaaa\u001b0\u0001\u0004i\b")
public class SqlConfigurationRepository
implements ConfigurationRepository,
Logging {
    private final ConfigurationPersistence configurationPersistence;
    private final ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final FolderPersistence folderPersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ThemeSettings getThemeSettings() {
        return ConfigurationRepository.getThemeSettings$((ConfigurationRepository)this);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<BaseConfiguration> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfigurationRepository sqlConfigurationRepository = this;
        synchronized (sqlConfigurationRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration) {
        return this.create(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration, Integer folderCiUid) {
        this.checkCardinality(configuration);
        this.validate(configuration);
        this.interceptCreate((ConfigurationItem)configuration);
        this.configurationPersistence.insert(configuration, folderCiUid);
        this.afterCreate((ConfigurationItem)configuration);
        return configuration;
    }

    private Integer getFolderCiUid(String folderId) {
        String string = folderId;
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (string != null) break;
                return null;
            }
        }
        return this.folderPersistence.getUid(string);
    }

    private <T extends BaseConfiguration> void checkCardinality(T configuration) {
        Type configurationType = Type.valueOf(BaseConfiguration.class);
        if (SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).hasCardinality()) {
            Type configGroupType = (Type)SqlConfigurationRepository.groupType$1(configuration, configurationType).getOrElse((Function0 & Serializable)() -> configuration.getType());
            Buffer foundConfigs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.findAllByTypeAndTitle(configGroupType, null, configuration.getFolderId(), false)).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$3(configuration, x$1)));
            Option<Object> cardinality = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).getCardinality();
            if (cardinality.isDefined() && foundConfigs.size() >= BoxesRunTime.unboxToInt((Object)cardinality.get())) {
                String folderId = configuration.getFolderId() == null ? Ids.ROOT_FOLDER_ID : configuration.getFolderId();
                throw new ItemAlreadyExistsException(new StringBuilder(60).append("There are already ").append(foundConfigs.length()).append(" items of type '").append(configGroupType).append("' defined on the folder '").append(folderId).append("'").toString(), new Object[0]);
            }
            return;
        }
    }

    @Timed
    public <T extends BaseConfiguration> T read(String configurationId) {
        return (T)((BaseConfiguration)Option$.MODULE$.apply(this.sqlRepositoryAdapter.read(configurationId)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(24).append("Configuration ").append(configurationId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration) {
        return this.update(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration, Integer folderCiUid) {
        this.validate(configuration);
        this.interceptUpdate((ConfigurationItem)configuration);
        this.configurationPersistence.update(configuration);
        this.afterUpdate((ConfigurationItem)configuration);
        return configuration;
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByType(Type ciType) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypes(this.getAllSubTypesOf(ciType)).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByTypeAndTitle(Type ciType, String title) {
        return this.findAllByTypeAndTitle(ciType, title, null, false);
    }

    @Timed
    public <T extends BaseConfiguration> java.util.List<T> findAllByTypeAndTitle(Type ciType, String title, String folderId, boolean folderOnly) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypesTitleAndFolder(this.getAllSubTypesOf(ciType), (Option<String>)Option$.MODULE$.apply((Object)title).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (Option<Either<String, String>>)Option$.MODULE$.apply((Object)folderId).map((Function1)(folderOnly ? (Function1 & Serializable)value -> package$.MODULE$.Right().apply(value) : (Function1 & Serializable)value -> package$.MODULE$.Left().apply(value)))).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    public <T extends BaseConfiguration> String findAllByTypeAndTitle$default$2() {
        return null;
    }

    private <T extends BaseConfiguration> Option<T> readConfiguration(Tuple2<Option<FolderId>, String> row) {
        Tuple2<Option<FolderId>, String> tuple2 = row;
        if (tuple2 != null) {
            Option folderIdOpt = (Option)tuple2._1();
            String rawConfiguration = (String)tuple2._2();
            return this.sqlRepositoryAdapter.deserialize(rawConfiguration).map((Function1 & Serializable)conf -> (BaseConfiguration)folderIdOpt.fold((Function0 & Serializable)() -> conf, (Function1 & Serializable)folderId -> {
                conf.setFolderId(folderId.absolute());
                return conf;
            }));
        }
        throw new MatchError(tuple2);
    }

    @Timed
    @IsReadOnly
    public <T extends BaseConfiguration> boolean existsByTypeAndTitle(Type ciType, String title) {
        return this.configurationPersistence.existsByTypeAndTitle(this.getAllSubTypesOf(ciType), title);
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType) {
        return this.findFirstByType(ciType, ResolutionContext$.MODULE$.GLOBAL());
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType, ResolutionContext context) {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.configurationPersistence.findFirstByTypes(this.getAllSubTypesOf(ciType), (Option<String>)context.folderId()).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))));
    }

    @Timed
    @IsReadOnly
    public boolean exists(String configurationId) {
        return this.configurationPersistence.exists(configurationId);
    }

    public <T extends BaseConfiguration> String existsByTypeAndTitle$default$2() {
        return null;
    }

    private void checkDelete(String configurationId, ConfigurationReferencePersistence configurationReferencePersistence) {
        if (configurationReferencePersistence.isReferenced(configurationId)) {
            scala.collection.immutable.Seq<ConfigurationReferenceRow> referencing = configurationReferencePersistence.getReferencingEntities(configurationId);
            scala.collection.immutable.Seq entities = (scala.collection.immutable.Seq)referencing.map((Function1 & Serializable)data -> new StringBuilder(5).append("[").append(data.title()).append(" (").append(data.id()).append(")]").toString());
            throw new ItemInUseException("%s is still referenced by %s", new Object[]{configurationId, entities.mkString(", ")});
        }
    }

    @Timed
    public void delete(String configurationId) {
        this.checkDelete(configurationId, this.releaseConfigurationReferencePersistence);
        this.checkDelete(configurationId, this.triggerConfigurationReferencePersistence);
        this.interceptDelete(configurationId);
        this.configurationPersistence.delete(configurationId);
        this.afterDelete(configurationId);
    }

    @Timed
    public java.util.List<ReleaseBasicData> getReferenceReleases(String configurationId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.releaseConfigurationReferencePersistence.getReferencingEntities(configurationId).map((Function1 & Serializable)x$3 -> ConfigurationReferenceRow$.MODULE$.ConfigurationReferenceDataOps((ConfigurationReferenceRow)x$3).asReleaseData())).asJava();
    }

    private <T extends BaseConfiguration> scala.collection.immutable.Seq<String> getAllSubTypesOf(Type ciType) {
        return (scala.collection.immutable.Seq)TypeHelper$.MODULE$.getAllSubtypesOf(ciType).map((Function1 & Serializable)x$4 -> x$4.toString());
    }

    @Timed
    public scala.collection.immutable.Seq<String> getAllTypes() {
        return this.configurationPersistence.findAllConfigurationTypes();
    }

    @Timed
    public void deleteByTypes(scala.collection.immutable.Seq<String> ciTypes) {
        scala.collection.immutable.Seq<Integer> configurationCiUids = this.configurationPersistence.findUidsByTypes(ciTypes);
        this.releaseConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.triggerConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.configurationPersistence.deleteByTypes(ciTypes);
    }

    private void validate(BaseConfiguration configuration) {
        ListBuffer passVarUsagePoints = ListBuffer$.MODULE$.empty();
        BaseConfiguration baseConfiguration = configuration;
        if (baseConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)baseConfiguration;
            ConfigurationVariableService$.MODULE$.getUsagePointsByVars((Iterable)new .colon.colon((Object)configuration2, (List)Nil$.MODULE$)).values().foreach((Function1 & Serializable)usagePoints -> {
                usagePoints.foreach((Function1 & Serializable)up -> {
                    CiProperty targetProperty = up.getTargetProperty();
                    PropertyDescriptor desc = targetProperty.getDescriptor();
                    PropertyKind propertyKind = desc.getKind();
                    PropertyKind propertyKind2 = PropertyKind.STRING;
                    Checks.checkArgument((!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && desc.isPassword() ? 1 : 0) != 0, (String)"Non-password-type variables in configuration variableMapping are not supported", (Object[])new Object[0]);
                    targetProperty.setValue((Object)"<temporary_value>");
                    return (ListBuffer)passVarUsagePoints$1.$plus$eq(up);
                });
                return BoxedUnit.UNIT;
            });
        }
        Descriptor desc = configuration.getType().getDescriptor();
        ExtendedValidationContextImpl extendedValidationContext = new ExtendedValidationContextImpl((ConfigurationItem)configuration);
        desc.validate((ExtendedValidationContext)extendedValidationContext, (ConfigurationItem)configuration);
        java.util.List messages = extendedValidationContext.getMessages();
        Object object = !messages.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)configuration.get$validationMessages().addAll(messages)) : BoxedUnit.UNIT;
        if (!configuration.get$validationMessages().isEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)configuration);
        }
        passVarUsagePoints.toList().foreach((Function1 & Serializable)up -> {
            SqlConfigurationRepository.$anonfun$validate$3(up);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCardinality$1(Type configurationType$1, BaseConfiguration configuration$1, Type superType) {
        if (!superType.isSubTypeOf(configurationType$1)) return false;
        if (!SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$TypeOps(superType).hasCardinality()) return false;
        Integer n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)superType.getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()));
        Option<Object> option = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration$1).getCardinality();
        if (n != null) {
            if (!((Object)n).equals(option)) return false;
            return true;
        }
        if (option == null) return true;
        return false;
    }

    private static final Option groupType$1(BaseConfiguration configuration, Type configurationType$1) {
        java.util.List superClasses = configuration.getType().getDescriptor().getSuperClasses();
        return CollectionConverters$.MODULE$.ListHasAsScala(superClasses).asScala().find((Function1 & Serializable)superType -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$1(configurationType$1, configuration, superType)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCardinality$3(BaseConfiguration configuration$2, BaseConfiguration x$1) {
        String string = x$1.getFolderId();
        String string2 = configuration$2.getFolderId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validate$3(UsagePoint up) {
        up.getTargetProperty().setValue(null);
    }

    public SqlConfigurationRepository(ConfigurationPersistence configurationPersistence, ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, SqlRepositoryAdapter sqlRepositoryAdapter, FolderPersistence folderPersistence) {
        this.configurationPersistence = configurationPersistence;
        this.releaseConfigurationReferencePersistence = releaseConfigurationReferencePersistence;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.folderPersistence = folderPersistence;
        InterceptedRepository.$init$((InterceptedRepository)this);
        ConfigurationRepository.$init$((ConfigurationRepository)this);
        Logging.$init$((Logging)this);
    }

    private static class BaseConfigurationOps {
        private final BaseConfiguration ci;
        private final Type ciType;

        private Type ciType() {
            return this.ciType;
        }

        public boolean hasCardinality() {
            return this.ci.hasProperty("cardinality");
        }

        public Option<Object> getCardinality() {
            if (this.hasCardinality()) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ciType().getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue())));
            }
            return None$.MODULE$;
        }

        public BaseConfigurationOps(BaseConfiguration ci) {
            this.ci = ci;
            this.ciType = ci.getType();
        }
    }

    private static class TypeOps {
        private final Type xlType;

        public boolean hasCardinality() {
            return this.hasProperty("cardinality");
        }

        public boolean hasProperty(String propertyName) {
            return this.xlType.getDescriptor().getPropertyDescriptor(propertyName) != null;
        }

        public TypeOps(Type xlType) {
            this.xlType = xlType;
        }
    }
}

