/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.ChangeJob;
import com.xebialabs.xlrelease.scheduler.repository.ChangeJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.ChangeNode;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.sql.JobRowMapper;
import com.xebialabs.xlrelease.scheduler.sql.SqlJobFiltersQueryBuilder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t]c\u0001B\u0014)\u0001MB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\tK\u0002\u0011\t\u0011)A\u00053\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003i\u0011)\t\t\u0001\u0001BC\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\tY\u0003\u0001C!\u0003[A\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0007Bq!!\u0016\u0001\t\u0013\t9\u0006C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002^!A\u0011Q\u000e\u0001!\u0002\u0013\ty\u0006C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002B!A\u0011\u0011\u000f\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0002t\u0001!\t%!\u001e\t\u0013\u0005\u0005\u0005A1A\u0005\n\u0005\u0005\u0003\u0002CAB\u0001\u0001\u0006I!a\u0011\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"I\u0011Q\u0012\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002D!9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005\"CA]\u0001\t\u0007I\u0011BA!\u0011!\tY\f\u0001Q\u0001\n\u0005\r\u0003bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u0017\u0004A\u0011IAg\u0011%\tY\u0010\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BA\"\u0011\u001d\ty\u0010\u0001C!\u0005\u0003A\u0011B!\u0003\u0001\u0005\u0004%I!!\u0011\t\u0011\t-\u0001\u0001)A\u0005\u0003\u0007BqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0005\u0003\u0018\u0001\u0011\r\u0011\"\u0003\u0002B!A!\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0005C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*!9!\u0011\b\u0001\u0005\n\tm\"\u0001E*rY*{'MU3q_NLGo\u001c:z\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0017/\u0003%AHN]3mK\u0006\u001cXM\u0003\u00020a\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002c\u0005\u00191m\\7\u0004\u0001M9\u0001\u0001\u000e\u001eA\u00112{\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<}5\tAH\u0003\u0002>U\u0005Q!/\u001a9pg&$xN]=\n\u0005}b$!\u0004&pEJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006Y\u0001/\u001a:tSN$XM\\2f\u0015\tISI\u0003\u0002>Y%\u0011qI\u0011\u0002\u0013!\u0016\u00148/[:uK:\u001cWmU;qa>\u0014H\u000f\u0005\u0002J\u00156\t\u0001&\u0003\u0002LQ\ta!j\u001c2S_^l\u0015\r\u001d9feB\u0011\u0011)T\u0005\u0003\u001d\n\u0013Q!\u0016;jYN\u0004\"\u0001U+\u000e\u0003ES!AU*\u0002\u000bMdg\r\u000e6\u000b\u0003Q\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003-F\u0013q\u0001T8hO&tw-\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001Z!\tQ6-D\u0001\\\u0015\taV,\u0001\u0003d_J,'B\u00010`\u0003\u0011QGMY2\u000b\u0005\u0001\f\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\t\f1a\u001c:h\u0013\t!7L\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005A\u0007CA5}\u001d\tQ\u0017P\u0004\u0002lo:\u0011A.\u001e\b\u0003[Rt!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005E\u0014\u0014A\u0002\u001fs_>$h(C\u00012\u0013\ty\u0003'\u0003\u0002.]%\u0011a\u000fL\u0001\u0003I\nL!!\u000b=\u000b\u0005Yd\u0013B\u0001>|\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003SaL!! @\u0003\u000f\u0011K\u0017\r\\3di*\u0011!p_\u0001\tI&\fG.Z2uA\u0005qA/Y:l%\u0016\u0004xn]5u_JLXCAA\u0003!\u0011\t9!!\u0003\u000e\u0003\u0015K1!a\u0003F\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005M\u0011QCA\f\u00033\u0001\"!\u0013\u0001\t\u000b];\u0001\u0019A-\t\u000b\u0019<\u0001\u0019\u00015\t\u000f\u0005\u0005q\u00011\u0001\u0002\u0006\u000511M]3bi\u0016$B!a\b\u0002(A!\u0011\u0011EA\u0012\u001b\u0005Q\u0013bAA\u0013U\t1!j\u001c2S_^Dq!!\u000b\t\u0001\u0004\ty\"A\u0002k_\n\fqA]3qY\u0006\u001cW\r\u0006\u0003\u0002 \u0005=\u0002bBA\u0015\u0013\u0001\u0007\u0011q\u0004\u0015\u0004\u0013\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005e20A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA\u001f\u0003o\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0010'RkEkX%O'\u0016\u0013Fk\u0018&P\u0005V\u0011\u00111\t\t\u0005\u0003\u000b\niE\u0004\u0003\u0002H\u0005%\u0003CA87\u0013\r\tYEN\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-c'\u0001\tT)6#v,\u0013(T\u000bJ#vLS(CA\u0005i1M]3bi\u0016$\u0016m]6K_\n$B!a\b\u0002Z!9\u0011\u0011\u0006\u0007A\u0002\u0005}\u0011a\b)S\u000bZKu*V*`-\u0016\u00136+S(O?B\u000b%+Q'F)\u0016\u0013vLT!N\u000bV\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0014\u0001\u00026bm\u0006LA!a\u0014\u0002d\u0005\u0001\u0003KU#W\u0013>+6k\u0018,F%NKuJT0Q\u0003J\u000bU*\u0012+F%~s\u0015)T#!\u00035\u0019F+\u0014+`\u0019>\u001b5j\u0018&P\u0005\u0006q1\u000bV'U?2{5iS0K\u001f\n\u0003\u0013AF;qI\u0006$XmV5uQZ+'o]5p]\u000eCWmY6\u0015\t\u0005]\u0014Q\u0010\t\u0004k\u0005e\u0014bAA>m\t!QK\\5u\u0011\u001d\tI#\u0005a\u0001\u0003?A3!EA\u001a\u0003=\u0019F+\u0014+`\t\u0016cU\tV#`\u0015>\u0013\u0015\u0001E*U\u001bR{F)\u0012'F)\u0016{&j\u0014\"!\u0003\u0019!W\r\\3uKR!\u0011qOAE\u0011\u001d\tI\u0003\u0006a\u0001\u0003?A3\u0001FA\u001a\u0003\u0005\u001aF+\u0014+`\r&sEi\u0018+B'.{\u0016\nR*`\u0005f{&+\u0012'F\u0003N+u,V%E\u0003\t\u001aF+\u0014+`\r&sEi\u0018+B'.{\u0016\nR*`\u0005f{&+\u0012'F\u0003N+u,V%EA\u0005ib-\u001b8e#V,W/\u001a3UCN\\\u0017\nZ:CsJ+G.Z1tKVKG\r\u0006\u0003\u0002\u0016\u0006\u001d\u0006CBAL\u0003C\u000b\u0019E\u0004\u0003\u0002\u001a\u0006uebA8\u0002\u001c&\tq'C\u0002\u0002 Z\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006\u0015&aA*fc*\u0019\u0011q\u0014\u001c\t\u000f\u0005%v\u00031\u0001\u0002,\u0006Q!/\u001a7fCN,W+\u001b3\u0011\t\u0005\u0005\u0014QV\u0005\u0005\u0003_\u000b\u0019GA\u0004J]R,w-\u001a:)\u0007]\t\u0019\f\u0005\u0003\u00026\u0005U\u0016\u0002BA\\\u0003o\u0011!\"S:SK\u0006$wJ\u001c7z\u0003]\u0019F+\u0014+`\r&sEi\u0018,F%NKuJT0C3~KE)\u0001\rT)6#vLR%O\t~3VIU*J\u001f:{&)W0J\t\u0002\nqBZ5oIZ+'o]5p]\nK\u0018\n\u001a\u000b\u0005\u0003\u0003\f9\rE\u00036\u0003\u0007\fY+C\u0002\u0002FZ\u0012aa\u00149uS>t\u0007bBAe5\u0001\u0007\u00111V\u0001\u0003S\u0012\fqAZ5oI\u0006cG\u000e\u0006\u0004\u0002P\u0006}\u0017q\u001e\t\u0007\u0003#\fY.a\b\u000e\u0005\u0005M'\u0002BAk\u0003/\fa\u0001Z8nC&t'bAAm?\u0006!A-\u0019;b\u0013\u0011\ti.a5\u0003\tA\u000bw-\u001a\u0005\b\u0003C\\\u0002\u0019AAr\u0003)QwN\u0019$jYR,'o\u001d\t\u0005\u0003K\fY/\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e\u0016\u0002\u000f\u0019LG\u000e^3sg&!\u0011Q^At\u0005)QuN\u0019$jYR,'o\u001d\u0005\b\u0003c\\\u0002\u0019AAz\u0003!\u0001\u0018mZ3bE2,\u0007\u0003BAi\u0003kLA!a>\u0002T\nA\u0001+Y4fC\ndW\rK\u0002\u001c\u0003g\u000b1d\u0015+N)~3\u0015J\u0014#`\t&\u001bF+\u0013(D)~su\nR#`\u0013\u0012\u001b\u0016\u0001H*U\u001bR{f)\u0013(E?\u0012K5\u000bV%O\u0007R{fj\u0014#F?&#5\u000bI\u0001\u0014M&tG\rR5ti&t7\r\u001e(pI\u0016LEm\u001d\u000b\u0003\u0005\u0007\u0001b!!\u0012\u0003\u0006\u0005\r\u0013\u0002\u0002B\u0004\u0003#\u00121aU3u\u0003m\u0019F+\u0014+`\t\u0016cU\tV#`\u0005f{F+Q*L?&#u\fS!T\u0011\u0006a2\u000bV'U?\u0012+E*\u0012+F?\nKv\fV!T\u0017~KEi\u0018%B'\"\u0003\u0013A\u00043fY\u0016$XMQ=UCN\\\u0017\n\u001a\u000b\u0005\u0003o\u0012\t\u0002C\u0004\u0003\u0014\u0005\u0002\r!a\u0011\u0002\rQ\f7o[%eQ\r\t\u00131G\u0001-'RkEk\u0018#F\u0019\u0016#Vi\u0018\"Z?R\u000b5kS0J\t~C\u0015i\u0015%`\u0003:#u,\u0012-F\u0007V#\u0016j\u0014(`\u0013\u0012\u000bQf\u0015+N)~#U\tT#U\u000b~\u0013\u0015l\u0018+B'.{\u0016\nR0I\u0003NCu,\u0011(E?\u0016CViQ+U\u0013>su,\u0013#!\u0003q!W\r\\3uK\nKH+Y:l\u0013\u0012\fe\u000eZ#yK\u000e,H/[8o\u0013\u0012$b!a\u001e\u0003 \t\u0005\u0002b\u0002B\nI\u0001\u0007\u00111\t\u0005\b\u0005G!\u0003\u0019AA\"\u0003-)\u00070Z2vi&|g.\u00133)\u0007\u0011\n\u0019$\u0001\u0004dQ\u0006tw-\u001a\u000b\u0005\u0005W\u0011i\u0003E\u00036\u0003\u0007\fy\u0002C\u0004\u00030\u0015\u0002\rA!\r\u0002\u0013\rD\u0017M\\4f\u0015>\u0014\u0007cA\u001e\u00034%\u0019!Q\u0007\u001f\u0003\u0013\rC\u0017M\\4f\u0015>\u0014\u0007fA\u0013\u00024\u00051\u0002.\u00198eY\u0016|\u0005\u000f^5nSN$\u0018nY+qI\u0006$X\r\u0006\u0004\u0003>\t%#1\n\t\bk\t}\"1IA<\u0013\r\u0011\tE\u000e\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019QG!\u0012\n\u0007\t\u001dcGA\u0002J]RDq!!\u000b'\u0001\u0004\ty\u0002C\u0004\u0003N\u0019\u0002\rAa\u0014\u0002\u001b1|wMU3d_Z,'/\u001f$o!\u0015)\u00141\u0019B)!\u0015)$1KA\"\u0013\r\u0011)F\u000e\u0002\n\rVt7\r^5p]B\u0002")
public class SqlJobRepository
implements JobRepository,
PersistenceSupport,
JobRowMapper,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final TaskRepository taskRepository;
    private final String STMT_INSERT_JOB;
    private final String PREVIOUS_VERSION_PARAMETER_NAME;
    private final String STMT_LOCK_JOB;
    private final String STMT_DELETE_JOB;
    private final String STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    private final String STMT_FIND_VERSION_BY_ID;
    private final String STMT_FIND_DISTINCT_NODE_IDS;
    private final String STMT_DELETE_BY_TASK_ID_HASH;
    private final String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public RowMapper<JobRow> jobMapper() {
        return JobRowMapper.jobMapper$(this);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        return !this.bitmap$0 ? this.namedTemplate$lzycompute() : this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public JobRow create(JobRow job) {
        JobRow jobRow;
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(13).append("creating job ").append(job).toString());
        try {
            jobRow = this.createTaskJob(job);
        }
        catch (Exception exception) {
            jobRow = this.replace(job);
        }
        return jobRow;
    }

    @IsTransactional
    public JobRow replace(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(14).append("replacing job ").append(job).toString());
        this.deleteByTaskId(job.taskId());
        return this.createTaskJob(job);
    }

    private String STMT_INSERT_JOB() {
        return this.STMT_INSERT_JOB;
    }

    private JobRow createTaskJob(JobRow job) {
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID()), (Object)job.taskId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(job.taskId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)job.releaseUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.JOB_TYPE()), (Object)job.jobType().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()), (Object)Timestamp.from(job.submitTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()), (Object)Timestamp.from(job.scheduledStartTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)job.executionId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node())}));
        return (JobRow)this.sqlInsert(this.pkName(Schema.TASK_JOBS$.MODULE$.ID()), this.STMT_INSERT_JOB(), (Map<String, Object>)params, (Function1 & Serializable)id -> job.copy(id, job.copy$default$2(), job.copy$default$3(), job.copy$default$4(), job.copy$default$5(), job.copy$default$6(), job.copy$default$7(), job.copy$default$8(), job.copy$default$9(), job.copy$default$10(), job.copy$default$11()));
    }

    private String PREVIOUS_VERSION_PARAMETER_NAME() {
        return this.PREVIOUS_VERSION_PARAMETER_NAME;
    }

    private String STMT_LOCK_JOB() {
        return this.STMT_LOCK_JOB;
    }

    @IsTransactional
    public void updateWithVersionCheck(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(38).append("going to update with version check to ").append(job).toString());
        long previousVersion = job.version() - 1L;
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.START_TIME()), Option$.MODULE$.apply((Object)job.startTime()).map((Function1 & Serializable)x$1 -> Timestamp.from(x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)job.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PREVIOUS_VERSION_PARAMETER_NAME()), (Object)BoxesRunTime.boxToLong((long)previousVersion))}));
        this.sqlUpdate(this.STMT_LOCK_JOB(), this.paramMap2MapSqlParameterSource((Map<String, Object>)params), (Function1)this.handleOptimisticUpdate(job, (Option<Function0<String>>)new Some((Function0 & Serializable)() -> (String)this.findVersionById(job.id()).map((Function1 & Serializable)version -> new StringBuilder(19).append("current version is ").append(version).toString()).getOrElse((Function0 & Serializable)() -> "record not found"))));
    }

    private String STMT_DELETE_JOB() {
        return this.STMT_DELETE_JOB;
    }

    @IsTransactional
    public void delete(JobRow job) {
        block0: {
            int deletedRows = BoxesRunTime.unboxToInt(this.sqlUpdate(this.STMT_DELETE_JOB(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)job.id())}))), (Function1)(JFunction1.mcII.sp & Serializable)rows -> rows));
            if (deletedRows == 1) break block0;
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(50).append(deletedRows).append(" rows deleted when trying to delete scheduled job ").append(job).toString());
        }
    }

    private String STMT_FIND_TASK_IDS_BY_RELEASE_UID() {
        return this.STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    }

    @IsReadOnly
    public Seq<String> findQueuedTaskIdsByReleaseUid(Integer releaseUid) {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_TASK_IDS_BY_RELEASE_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)releaseUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)JobStatus.QUEUED.name())})), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.TASK_ID())));
    }

    private String STMT_FIND_VERSION_BY_ID() {
        return this.STMT_FIND_VERSION_BY_ID;
    }

    private Option<Integer> findVersionById(Integer id) {
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_VERSION_BY_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)id)})), (Function1 & Serializable)rs -> BoxesRunTime.boxToInteger((int)rs.getInt(Schema.TASK_JOBS$.MODULE$.VERSION()))));
    }

    @IsReadOnly
    public Page<JobRow> findAll(JobFilters jobFilters, Pageable pageable) {
        return SqlJobFiltersQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.taskRepository()).from(jobFilters).withPageable(pageable).build().execute();
    }

    private String STMT_FIND_DISTINCT_NODE_IDS() {
        return this.STMT_FIND_DISTINCT_NODE_IDS;
    }

    public Set<String> findDistinctNodeIds() {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_DISTINCT_NODE_IDS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Nil$.MODULE$), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.NODE()))).toSet();
    }

    private String STMT_DELETE_BY_TASK_ID_HASH() {
        return this.STMT_DELETE_BY_TASK_ID_HASH;
    }

    @IsTransactional
    public void deleteByTaskId(String taskId) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(19).append("deleting by taskId ").append(taskId).toString());
        this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId))})), x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute()));
    }

    private String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID() {
        return this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    }

    @IsTransactional
    public void deleteByTaskIdAndExecutionId(String taskId, String executionId) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(40).append("deleting job by taskId ").append(taskId).append(" and executionId ").append(executionId).toString());
        this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)executionId)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
    }

    @IsTransactional
    public Option<JobRow> change(ChangeJob changeJob) {
        JobRow jobRow;
        ChangeJob changeJob2 = changeJob;
        if (changeJob2 instanceof ChangeNode) {
            ChangeNode changeNode = (ChangeNode)changeJob2;
            JobRow job = changeNode.job();
            String nodeId = changeNode.nodeId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(25).append("changing node of job ").append(job).append(" to ").append(nodeId).toString());
            long x$1 = job.version() + 1L;
            String x$2 = nodeId;
            Integer x$32 = job.copy$default$1();
            JobType x$4 = job.copy$default$3();
            JobStatus x$5 = job.copy$default$4();
            Instant x$6 = job.copy$default$6();
            Instant x$7 = job.copy$default$7();
            Instant x$8 = job.copy$default$8();
            String x$9 = job.copy$default$9();
            Integer x$10 = job.copy$default$10();
            String x$11 = job.copy$default$11();
            jobRow = job.copy(x$32, x$2, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11);
        } else if (changeJob2 instanceof ChangeJobStatus) {
            ChangeJobStatus changeJobStatus = (ChangeJobStatus)changeJob2;
            JobRow job = changeJobStatus.job();
            JobStatus jobStatus = changeJobStatus.status();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(27).append("changing status of job ").append(job).append(" to ").append(jobStatus).toString());
            long x$12 = job.version() + 1L;
            JobStatus x$13 = jobStatus;
            Integer x$14 = job.copy$default$1();
            String x$15 = job.copy$default$2();
            JobType x$16 = job.copy$default$3();
            Instant x$17 = job.copy$default$6();
            Instant x$18 = job.copy$default$7();
            Instant x$19 = job.copy$default$8();
            String x$20 = job.copy$default$9();
            Integer x$21 = job.copy$default$10();
            String x$22 = job.copy$default$11();
            jobRow = job.copy(x$14, x$15, x$16, x$13, x$12, x$17, x$18, x$19, x$20, x$21, x$22);
        } else {
            throw new MatchError((Object)changeJob2);
        }
        JobRow newJobRow = jobRow;
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.updateWithVersionCheck(newJobRow)).map((Function1 & Serializable)x$3 -> newJobRow).toOption();
    }

    private PartialFunction<Object, BoxedUnit> handleOptimisticUpdate(JobRow job, Option<Function0<String>> logRecoveryFn) {
        return new Serializable(this, job, logRecoveryFn){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlJobRepository $outer;
            private final JobRow job$8;
            private final Option logRecoveryFn$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                switch (A1) {
                    case 0: {
                        String msg = new StringBuilder(38).append("Unable to update Job row ").append(this.job$8).append(" of version ").append(this.job$8.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                        this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                        throw new OptimisticLockingFailureException(msg);
                    }
                    case 1: {
                        this.$outer.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Successfully updated job to ").append($this.job$8).toString());
                        break;
                    }
                    default: {
                        String msg = new StringBuilder(47).append("More than one row updated for job ").append(this.job$8.id()).append(" of version ").append(this.job$8.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                        this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                        throw new IllegalStateException(msg);
                    }
                }
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(int x1) {
                boolean bl;
                int n = x1;
                switch (n) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.job$8 = job$8;
                this.logRecoveryFn$1 = logRecoveryFn$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Function0 ), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(java.lang.String ), $anonfun$applyOrElse$4(com.xebialabs.xlrelease.scheduler.sql.SqlJobRepository$$anonfun$handleOptimisticUpdate$1 ), $anonfun$applyOrElse$5(scala.Function0 ), $anonfun$applyOrElse$6(), $anonfun$applyOrElse$7(java.lang.String )}, serializedLambda);
            }
        };
    }

    public SqlJobRepository(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect, TaskRepository taskRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.taskRepository = taskRepository;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        JobRowMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(302).append("INSERT INTO ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append(" (\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | ) VALUES (\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | )\n       |").toString()));
        this.PREVIOUS_VERSION_PARAMETER_NAME = "PREVIOUS_VERSION";
        this.STMT_LOCK_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(125).append("UPDATE ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | SET\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" AND ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(this.PREVIOUS_VERSION_PARAMETER_NAME()).append("\n       |").toString()));
        this.STMT_DELETE_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_FIND_TASK_IDS_BY_RELEASE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" AND\n       | ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append("\n       |").toString()));
        this.STMT_FIND_VERSION_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(76).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_FIND_DISTINCT_NODE_IDS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n       |SELECT DISTINCT\n       | ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       | AND ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append("\n       |").toString()));
    }
}

