/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001\u0002\u001c8\u0001\tC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t_\u0002\u0011)\u0019!C\ta\"AA\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0005w\u0011!Q\bA!A!\u0002\u00139\b\u0002C>\u0001\u0005\u000b\u0007I\u0011\u0003?\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013i\bBCA\u0002\u0001\t\u0015\r\u0011\"\u0005\u0002\u0006!Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u0005=\u0001A!b\u0001\n#\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003'A!\"a\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000f\u0011)\tY\u0003\u0001B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003[\u0001!Q1A\u0005\u0002\u0005=\u0002BCA\u001c\u0001\t\u0005\t\u0015!\u0003\u00022!Q\u0011\u0011\b\u0001\u0003\u0002\u0003\u0006I!a\u000f\t\u0015\u0005\u0005\u0003A!b\u0001\n\u0007\t\u0019\u0005\u0003\u0006\u0002t\u0001\u0011\t\u0011)A\u0005\u0003\u000bBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011Q\u001e\u0001\u0005B\u0005=\bbBAw\u0001\u0011\u0005\u0013Q\u001f\u0005\b\u0005#\u0001A\u0011\tB\n\u0011\u001d\u0011i\u0005\u0001C!\u0005\u001fBqAa\u0016\u0001\t\u0003\u0011I\u0006C\u0004\u0003~\u0001!\tEa \t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!\u0011\u0015\u0001\u0005B\t\r\u0006b\u0002B\\\u0001\u0011\u0005#\u0011\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011y\r\u0001C!\u0005#DqA!7\u0001\t\u0003\u0012Y\u000eC\u0004\u0003h\u0002!\tE!;\t\u000f\t=\b\u0001\"\u0011\u0003r\"9!1 \u0001\u0005B\tu\bbBB\u0004\u0001\u0011\u00053\u0011\u0002\u0005\b\u0007/\u0001A\u0011IB\r\u0011\u001d\u0019\t\u0003\u0001C!\u0007GAqaa\u000b\u0001\t\u0003\u001ai\u0003C\u0004\u0004,\u0001!\tea\r\t\u000f\r}\u0002\u0001\"\u0011\u0004B!91\u0011\n\u0001\u0005B\r-\u0003bBB.\u0001\u0011%1Q\f\u0005\b\u0007{\u0002A\u0011BB@\u0011\u001d\u0019)\t\u0001C!\u0007\u000fCqa!)\u0001\t\u0003\u001a\u0019\u000bC\u0004\u0004*\u0002!\tea+\t\u0013\rM\u0006\u00011A\u0005\u0002\rU\u0006\"CB`\u0001\u0001\u0007I\u0011ABa\u0011!\u00199\r\u0001Q!\n\r]\u0006bBBe\u0001\u0011\u000511\u001a\u0005\b\u0007#\u0004A\u0011BBj\u0005Q\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss*\u0011\u0001(O\u0001\u0004gFd'B\u0001\u001e<\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003yu\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005yz\u0014!\u0003=fE&\fG.\u00192t\u0015\u0005\u0001\u0015aA2p[\u000e\u00011\u0003\u0003\u0001D\u00136;vLY3\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\tQ5*D\u0001:\u0013\ta\u0015HA\tSK2,\u0017m]3SKB|7/\u001b;pef\u00042AT(R\u001b\u00059\u0014B\u0001)8\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"AU+\u000e\u0003MS!\u0001V\u001e\u0002\r\u0011|W.Y5o\u0013\t16KA\u0004SK2,\u0017m]3\u0011\u0005akV\"A-\u000b\u0005i[\u0016!B:mMRR'\"\u0001/\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AX-\u0003\u000f1{wmZ5oOB\u0011a\nY\u0005\u0003C^\u0012a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003\u001d\u000eL!\u0001Z\u001c\u0003=\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u001c8+\u001e9q_J$\bC\u0001(g\u0013\t9wG\u0001\u000eTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f%fYB,'/\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u00016n\u001b\u0005Y'B\u000178\u0003-\u0001XM]:jgR,gnY3\n\u00059\\'A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fq\u0002^1tWB+'o]5ti\u0016t7-Z\u000b\u0002cB\u0011!N]\u0005\u0003g.\u0014q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\u0011i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001x!\tQ\u00070\u0003\u0002zW\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002%\r|W.\\3oiB+'o]5ti\u0016t7-Z\u000b\u0002{B\u0011!N`\u0005\u0003\u007f.\u0014!cQ8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0006\u00192m\\7nK:$\b+\u001a:tSN$XM\\2fA\u0005qA/Z1n%\u0016\u0004xn]5u_JLXCAA\u0004!\rQ\u0015\u0011B\u0005\u0004\u0003\u0017I$A\u0004+fC6\u0014V\r]8tSR|'/_\u0001\u0010i\u0016\fWNU3q_NLGo\u001c:zA\u0005Y\"/\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef,\"!a\u0005\u0011\u0007)\u000b)\"C\u0002\u0002\u0018e\u00121DU3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\u0018\u0001\b:fY\u0016\f7/Z#yi\u0016t7/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013W\u0006i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u000b\u0002$\t\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0003\u0003c\u00012ATA\u001a\u0013\r\t)d\u000e\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u001aM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fE\u0002K\u0003{I1!a\u0010:\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/\u0006\u0002\u0002FA!\u0011qIA7\u001d\u0011\tI%a\u001a\u000f\t\u0005-\u00131\r\b\u0005\u0003\u001b\nyF\u0004\u0003\u0002P\u0005uc\u0002BA)\u00037rA!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/\n\u0015A\u0002\u001fs_>$h(C\u0001A\u0013\tqt(\u0003\u0002={%\u0019\u0011\u0011M\u001e\u0002\u0005\u0011\u0014\u0017b\u0001\u001d\u0002f)\u0019\u0011\u0011M\u001e\n\t\u0005%\u00141N\u0001\u000b'Fd')^5mI\u0016\u0014(b\u0001\u001d\u0002f%!\u0011qNA9\u0005\u001d!\u0015.\u00197fGRTA!!\u001b\u0002l\u0005Y1/\u001d7ES\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q!\u0012\u0011PA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f#B!a\u001f\u0002~A\u0011a\n\u0001\u0005\b\u0003\u0003\u001a\u00029AA#\u0011\u0015A7\u00031\u0001j\u0011\u0015y7\u00031\u0001r\u0011\u0015)8\u00031\u0001x\u0011\u0015Y8\u00031\u0001~\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000fAq!a\u0004\u0014\u0001\u0004\t\u0019\u0002C\u0004\u0002\u001cM\u0001\r!a\b\t\u000f\u000552\u00031\u0001\u00022!9\u0011\u0011H\nA\u0002\u0005m\u0012AB3ySN$8\u000f\u0006\u0003\u0002\u0016\u0006m\u0005c\u0001#\u0002\u0018&\u0019\u0011\u0011T#\u0003\u000f\t{w\u000e\\3b]\"9\u0011Q\u0014\u000bA\u0002\u0005}\u0015AA5e!\u0011\t\t+!+\u000f\t\u0005\r\u0016Q\u0015\t\u0004\u0003'*\u0015bAAT\u000b\u00061\u0001K]3eK\u001aLA!a+\u0002.\n11\u000b\u001e:j]\u001eT1!a*FQ\r!\u0012\u0011\u0017\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*!\u0011qWA6\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005m\u0016Q\u0017\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u000b\u0002@B!\u0011\u0011YAh\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017AC1o]>$\u0018\r^5p]*!\u0011\u0011ZAf\u0003\u001diW\r\u001e:jGNT1!!4@\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAi\u0003\u0007\u0014Q\u0001V5nK\u0012\faa\u0019:fCR,G#B)\u0002X\u0006m\u0007BBAm+\u0001\u0007\u0011+A\u0004sK2,\u0017m]3\t\u000f\u0005uW\u00031\u0001\u0002`\u0006)\"/\u001a7fCN,7I]3bi&|gnU8ve\u000e,\u0007\u0003BAq\u0003Ol!!a9\u000b\u0007\u0005\u00158+\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003S\f\u0019OA\u000bSK2,\u0017m]3De\u0016\fG/[8o'>,(oY3)\u0007U\ty,\u0001\u0005gS:$')_%e)\r\t\u0016\u0011\u001f\u0005\b\u0003;3\u0002\u0019AAPQ\r1\u0012q\u0018\u000b\u0006#\u0006]\u0018\u0011 \u0005\b\u0003;;\u0002\u0019AAP\u0011\u001d\tYp\u0006a\u0001\u0003{\faB]3t_24Xm\u00149uS>t7\u000f\u0005\u0003\u0002\u0000\n-QB\u0001B\u0001\u0015\rQ$1\u0001\u0006\u0005\u0005\u000b\u00119!\u0001\u0003kg>t'b\u0001B\u0005w\u0005i1/\u001a:jC2L'0\u0019;j_:LAA!\u0004\u0003\u0002\tq!+Z:pYZ,w\n\u001d;j_:\u001c\bfA\f\u0002@\u0006ya-\u001b8e\u0013\u0012\u001c()_*uCR,8\u000f\u0006\u0003\u0003\u0016\t\u001d\u0002C\u0002B\f\u0005C\tyJ\u0004\u0003\u0003\u001a\tua\u0002BA*\u00057I\u0011AR\u0005\u0004\u0005?)\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0011)CA\u0002TKFT1Aa\bF\u0011\u001d\u0011I\u0003\u0007a\u0001\u0005W\t\u0001b\u001d;biV\u001cXm\u001d\t\u0006\t\n5\"\u0011G\u0005\u0004\u0005_)%A\u0003\u001fsKB,\u0017\r^3e}A!!1\u0007B\u001d\u001b\t\u0011)DC\u0002\u00038M\u000baa\u001d;biV\u001c\u0018\u0002\u0002B\u001e\u0005k\u0011QBU3mK\u0006\u001cXm\u0015;biV\u001c\bf\u0001\r\u00022\"\u001a\u0001$a0)\u0007a\u0011\u0019\u0005\u0005\u0003\u0003F\t%SB\u0001B$\u0015\r\t)-R\u0005\u0005\u0005\u0017\u00129EA\u0004wCJ\f'oZ:\u0002'\u0019Lg\u000e\u001a\"z\u0007\u0006dWM\u001c3beR{7.\u001a8\u0015\u0007E\u0013\t\u0006C\u0004\u0003Te\u0001\r!a(\u0002\u001b\r\fG.\u001a8eCJ$vn[3oQ\rI\u0012qX\u0001\u0019M&tG-\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:f\u0013\u0012\u001cHC\u0002B\u000b\u00057\u0012y\u0007C\u0004\u0003^i\u0001\rAa\u0018\u0002\t\u0011\fG/\u001a\t\u0005\u0005C\u0012Y'\u0004\u0002\u0003d)!!Q\rB4\u0003\u0011)H/\u001b7\u000b\u0005\t%\u0014\u0001\u00026bm\u0006LAA!\u001c\u0003d\t!A)\u0019;f\u0011\u001d\u0011\tH\u0007a\u0001\u0005g\n\u0001\u0002]1hKNK'0\u001a\t\u0004\t\nU\u0014b\u0001B<\u000b\n\u0019\u0011J\u001c;)\u0007i\t\t\fK\u0002\u001b\u0003\u007f\u000bab]3u!J,\u0017I]2iSZ,G\r\u0006\u0004\u0003\u0002\n\u001d%1\u0012\t\u0004\t\n\r\u0015b\u0001BC\u000b\n!QK\\5u\u0011\u001d\u0011Ii\u0007a\u0001\u0003?\u000b\u0011B]3mK\u0006\u001cX-\u00133\t\u000f\t55\u00041\u0001\u0002\u0016\u0006Y\u0001O]3Be\u000eD\u0017N^3eQ\rY\u0012qX\u0001\u001aM&tG\r\u0015:f\u0003J\u001c\u0007.\u001b<bE2,'+\u001a7fCN,7\u000f\u0006\u0004\u0003\u0016\n]%1\u0014\t\u0006\u0005/\u0011\t#\u0015\u0005\b\u00053c\u0002\u0019\u0001B:\u0003\u0011\u0001\u0018mZ3\t\u000f\tED\u00041\u0001\u0003t!\u001aA$!-)\u0007q\ty,\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0005\u0005K\u0013Y\u000bE\u0003\u0003b\t\u001d\u0016+\u0003\u0003\u0003*\n\r$\u0001\u0002'jgRDqA!,\u001e\u0001\u0004\u0011y+\u0001\u0007tK\u0006\u00148\r\u001b)be\u0006l7\u000fE\u0002K\u0005cK1Aa-:\u0005U\u0011V\r\\3bg\u0016\u001cV-\u0019:dQ\nK\b+\u0019:b[ND3!HA`\u0003\u0019!W\r\\3uKR1!\u0011\u0011B^\u0005{Cq!!(\u001f\u0001\u0004\ty\nC\u0005\u0003@z\u0001\n\u00111\u0001\u0002\u0016\u0006\u00012\r\\3b]\u0006\u001bG/\u001b<jifdun\u001a\u0015\u0004=\u0005}\u0016a\u00063fY\u0016$XMU3mK\u0006\u001cXMU3gKJ,gnY3t)!\u0011\tIa2\u0003J\n5\u0007bBAO?\u0001\u0007\u0011q\u0014\u0005\b\u0005\u0017|\u0002\u0019\u0001B:\u0003)\u0011X\r\\3bg\u0016,\u0016\u000e\u001a\u0005\b\u0005\u007f{\u0002\u0019AAK\u00035!W\r\\3uK^KG\u000f[+jIR1!\u0011\u0011Bj\u0005+Dq!!(!\u0001\u0004\ty\nC\u0004\u0003L\u0002\u0002\rAa\u001d)\u0007\u0001\ny,\u0001\u0003n_Z,GC\u0002BA\u0005;\u0014\t\u000fC\u0004\u0003`\u0006\u0002\r!a(\u0002\u0015=\u0014\u0018nZ5oC2LE\rC\u0004\u0003d\u0006\u0002\r!a(\u0002\u000b9,w/\u00133)\u0007\u0005\ny,A\u0005hKR\u001cF/\u0019;vgR!!\u0011\u0007Bv\u0011\u001d\tiJ\ta\u0001\u0003?C3AIA`\u0003-9W\r^*uCR,8/Z:\u0015\t\tM(Q\u001f\t\u0007\u0005/\u0011\tC!\r\t\u000f\t]8\u00051\u0001\u0003\u0016\u0005\u0019\u0011\u000eZ:)\u0007\r\ny,A\u0007hKR\u0014\u0016n]6TG>\u0014Xm\u001d\u000b\u0005\u0005\u007f\u001c\t\u0001\u0005\u0004\u0003\u0018\t\u0005\"1\u000f\u0005\b\u0005o$\u0003\u0019\u0001B\u000bQ\r!\u0013\u0011\u0017\u0015\u0004I\u0005}\u0016!D:fiJK7o[*d_J,7\u000f\u0006\u0005\u0003\u0002\u000e-1QBB\t\u0011\u001d\u0011I)\na\u0001\u0003?Cqaa\u0004&\u0001\u0004\u0011\u0019(A\u0003tG>\u0014X\rC\u0004\u0004\u0014\u0015\u0002\rAa\u001d\u0002\u0015Q|G/\u00197TG>\u0014X\rK\u0002&\u0003\u007f\u000b!\"[:UK6\u0004H.\u0019;f)\u0011\t)ja\u0007\t\u000f\t%e\u00051\u0001\u0002 \"\u001aa%!-)\u0007\u0019\ny,\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\tyj!\n\t\u000f\u0005uu\u00051\u0001\u0002 \"\u001aq%!-)\u0007\u001d\ny,\u0001\u0004va\u0012\fG/\u001a\u000b\u0004#\u000e=\u0002BBAmQ\u0001\u0007\u0011\u000bK\u0002)\u0003\u007f#R!UB\u001b\u0007sAaaa\u000e*\u0001\u0004\t\u0016\u0001C8sS\u001eLg.\u00197\t\r\rm\u0012\u00061\u0001R\u0003\u001d)\b\u000fZ1uK\u0012D3!KA`\u0003\u001d\u0011X\r\u001d7bG\u0016$R!UB\"\u0007\u000bBaaa\u000e+\u0001\u0004\t\u0006BBB\u001eU\u0001\u0007\u0011\u000bK\u0002+\u0003\u007f\u000b!bZ3u\u00032dG+Y4t)\u0011\u0019iea\u0015\u0011\r\t\u00054qJAP\u0013\u0011\u0019\tFa\u0019\u0003\u0007M+G\u000fC\u0004\u0004V-\u0002\rAa\u001d\u0002\u00171LW.\u001b;Ok6\u0014WM\u001d\u0015\u0004W\u0005E\u0006fA\u0016\u0002@\u0006Qq-\u001a;SK2,\u0017m]3\u0015\u000bE\u001byfa\u001f\t\u000f\t%E\u00061\u0001\u0004bA!11MB;\u001d\u0011\u0019)g!\u001d\u000f\t\r\u001d4q\u000e\b\u0005\u0007S\u001aiG\u0004\u0003\u0002N\r-\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u0002mo%\u001911O6\u0002\t\rK\u0017\nZ\u0005\u0005\u0007o\u001aIH\u0001\u0003DS&#'bAB:W\"9\u00111 \u0017A\u0002\u0005u\u0018AI2iK\u000e\\\u0017j\u001d(piJ+g-\u001a:f]\u000e,GMQ=EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0003\u0002\u000e\u0005\u0005bBBB[\u0001\u00071\u0011M\u0001\u0018a2\fg.\u0013;f[&#wJ]%ug\u000eC\u0017\u000e\u001c3sK:\fqBZ5oIN\u001bU\nR1uC\nK\u0018\n\u001a\u000b\u0005\u0007\u0013\u001bY\nE\u0003E\u0007\u0017\u001by)C\u0002\u0004\u000e\u0016\u0013aa\u00149uS>t\u0007\u0003BBI\u0007/k!aa%\u000b\t\rU%qM\u0001\u0005Y\u0006tw-\u0003\u0003\u0004\u001a\u000eM%aB%oi\u0016<WM\u001d\u0005\b\u0003;s\u0003\u0019AAPQ\rq\u0013\u0011\u0017\u0015\u0004]\u0005}\u0016!\u00064j]\u0012|e/\u001a:ek\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0003\u0005+A3aLAYQ\ry\u0013qX\u0001\u000fO\u0016$(+\u001a7fCN,'j]8o)\u0011\tyj!,\t\u000f\t%\u0005\u00071\u0001\u0002 \"\u001a\u0001'!-)\u0007A\ny,A\nbGRLg/\u001b;z\u0019><7\t\\3b]\u0016\u00148/\u0006\u0002\u00048B1!q\u0003B\u0011\u0007s\u0003BASB^#&\u00191QX\u001d\u0003-A+'o]5ti\u0016t7-Z%oi\u0016\u00148-\u001a9u_J\fq#Y2uSZLG/\u001f'pO\u000ecW-\u00198feN|F%Z9\u0015\t\t\u000551\u0019\u0005\n\u0007\u000b\u0014\u0014\u0011!a\u0001\u0007o\u000b1\u0001\u001f\u00132\u0003Q\t7\r^5wSRLHj\\4DY\u0016\fg.\u001a:tA\u0005Q\"/Z4jgR,'/Q2uSZLG/\u001f'pO\u000ecW-\u00198feR!!\u0011QBg\u0011\u001d\u0019y\r\u000ea\u0001\u0007s\u000bqa\u00197fC:,'/A\tdY\u0016\fg.Q2uSZLG/\u001f'pON$BA!!\u0004V\"91q[\u001bA\u0002\u0005}\u0015\u0001B2j\u0013\u0012D3\u0001ABn!\u0011\t\u0019l!8\n\t\r}\u0017Q\u0017\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> activityLogCleaners;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public boolean delete$default$2() {
        return ReleaseRepository.delete$default$2$((ReleaseRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id, boolean cleanActivityLog) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid, cleanActivityLog);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid, boolean cleanActivityLog) {
        block0: {
            this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
            this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
            this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
            this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
            this.releaseExtensionsRepository().deleteAll(id);
            this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
            this.interceptDelete(id);
            if (!cleanActivityLog) break block0;
            this.cleanActivityLogs(id);
        }
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid, true);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> activityLogCleaners() {
        return this.activityLogCleaners;
    }

    public void activityLogCleaners_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.activityLogCleaners = x$1;
    }

    public void registerActivityLogCleaner(PersistenceInterceptor<Release> cleaner) {
        PersistenceInterceptor<Release> persistenceInterceptor = cleaner;
        this.activityLogCleaners_$eq((scala.collection.immutable.Seq<PersistenceInterceptor<Release>>)((scala.collection.immutable.Seq)this.activityLogCleaners().$plus$colon(persistenceInterceptor)));
    }

    private void cleanActivityLogs(String ciId) {
        this.activityLogCleaners().foreach((Function1 & Serializable)x$9 -> {
            x$9.onDelete(ciId);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
        this.activityLogCleaners = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }
}

