/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0007\u000f\u0001eA\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tq\u0001\u0011\t\u0011)A\u0005e!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b-\u0003A\u0011\t'\t\u000bu\u0004A\u0011\t@\t\ru\u0004A\u0011IA\u0013\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!!\u0019\u0001\t\u0013\t\u0019GA\u000bTc2\u0004F.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u000be\u0016\u0004xn]5u_JL(BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0007\u0011%QA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0012\u000e\u0003AI!a\t\t\u0003%Ac\u0017M\\%uK6\u0014V\r]8tSR|'/\u001f\t\u0003K\u0019j\u0011AD\u0005\u0003O9\u0011a\u0003R3tKJL\u0017\r\\5{CRLwN\\*vaB|'\u000f\u001e\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nQa\u001d7gi)T\u0011!L\u0001\tOJL'P\u001f7fI&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\b\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003oQ\u0012!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006\u0019\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2fA\u0005yA/Y:l!\u0016\u00148/[:uK:\u001cW-F\u0001<!\t\u0019D(\u0003\u0002>i\tyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\tuCN\\\u0007+\u001a:tSN$XM\\2fA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\u0005\u0003\"!\n\"\n\u0005\rs!\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003H\u0011&S\u0005CA\u0013\u0001\u0011\u0015\u0001t\u00011\u00013\u0011\u0015It\u00011\u0001<\u0011\u0015yt\u00011\u0001B\u0003\u0019)\u00070[:ugR\u0011Q\n\u0015\t\u000379K!a\u0014\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u000b\u0003a\u0001%\u0006!1-[%e!\t\u0019VM\u0004\u0002UG:\u0011QK\u0019\b\u0003-\u0006t!a\u00161\u000f\u0005a{fBA-_\u001d\tQV,D\u0001\\\u0015\ta\u0006$\u0001\u0004=e>|GOP\u0005\u0002/%\u0011QCF\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA\u001b\u000f\u0013\t!G'\u0001\u0003DS&#\u0017B\u00014h\u0005\u0011\u0019\u0015.\u00133\u000b\u0005\u0011$\u0004F\u0001\u0005j!\tQ\u0007/D\u0001l\u0015\taW.A\u0006ue\u0006t7/Y2uS>t'BA\bo\u0015\ty'#\u0001\u0002eE&\u0011\u0011o\u001b\u0002\u000b\u0013N\u0014V-\u00193P]2L\bF\u0001\u0005t!\t!80D\u0001v\u0015\t1x/\u0001\u0006b]:|G/\u0019;j_:T!\u0001_=\u0002\u000f5,GO]5dg*\u0011!PF\u0001\tG>$\u0017\r[1mK&\u0011A0\u001e\u0002\u0006)&lW\rZ\u0001\tM&tGMQ=JIV\u0019q0!\u0002\u0015\t\u0005\u0005\u0011Q\u0004\t\u0005\u0003\u0007\t)\u0001\u0004\u0001\u0005\u000f\u0005\u001d\u0011B1\u0001\u0002\n\t\tA+\u0005\u0003\u0002\f\u0005E\u0001cA\u000e\u0002\u000e%\u0019\u0011q\u0002\u000f\u0003\u000f9{G\u000f[5oOB!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018I\ta\u0001Z8nC&t\u0017\u0002BA\u000e\u0003+\u0011\u0001\u0002\u00157b]&#X-\u001c\u0005\u0007\u0003?I\u0001\u0019\u0001*\u0002\u0005%$\u0007FA\u0005jQ\tI1/\u0006\u0003\u0002(\u0005-BCBA\u0015\u0003[\ty\u0004\u0005\u0003\u0002\u0004\u0005-BaBA\u0004\u0015\t\u0007\u0011\u0011\u0002\u0005\b\u0003?Q\u0001\u0019AA\u0018!\u0011\t\t$!\u000f\u000f\t\u0005M\u0012Q\u0007\t\u00035rI1!a\u000e\u001d\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0007\u000f\t\u000f\u0005\u0005#\u00021\u0001\u0002D\u0005q!/Z:pYZ,w\n\u001d;j_:\u001c\b\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%\u0003#A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002N\u0005\u001d#A\u0004*fg>dg/Z(qi&|gn\u001d\u0015\u0003\u0015%D#AC:\u0002\u0019\u0019Lg\u000e\u001a)mC:LE/Z7\u0016\t\u0005]\u00131\f\u000b\u0007\u00033\ni&a\u0018\u0011\t\u0005\r\u00111\f\u0003\b\u0003\u000fY!\u0019AA\u0005\u0011\u0015\t6\u00021\u0001S\u0011\u001d\t\te\u0003a\u0001\u0003\u0007\n1BZ5oIJ+G.Z1tKV!\u0011QMA9)\u0019\t9'!\u001c\u0002pA!\u00111CA5\u0013\u0011\tY'!\u0006\u0003\u000fI+G.Z1tK\"1\u0011q\u0004\u0007A\u0002ICq!!\u0011\r\u0001\u0004\t\u0019\u0005B\u0004\u0002l1\u0011\r!a\u001d\u0012\t\u0005-\u0011Q\u000f\t\u00047\u0005]\u0014bAA=9\t\u0019\u0011I\\=)\u0007\u0001\ti\bE\u0002k\u0003\u007fJ1!!!l\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlPlanItemRepository
implements PlanItemRepository,
DeserializationSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPlanItemRepository sqlPlanItemRepository = this;
        synchronized (sqlPlanItemRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String ciId) {
        boolean bl;
        String string = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(ciId));
        Option option = IdMatchers.ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String id = (String)option.get();
            bl = this.releasePersistence().existsRelease(Ids.releaseIdFrom((String)id));
        } else {
            Option option2 = IdMatchers.PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                bl = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.findPlanItem(ciId, ResolveOptions$.MODULE$.MINIMAL()) != null).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            } else {
                Option option3 = IdMatchers.TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    bl = this.taskPersistence().exists(ciId);
                } else {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Item [").append(string).append("] not found").toString());
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Timed
    @IsReadOnly
    public <T extends PlanItem> T findById(String id) {
        return this.findById(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    @IsReadOnly
    public <T extends PlanItem> T findById(String id, ResolveOptions resolveOptions) {
        return this.findPlanItem(id, resolveOptions);
    }

    private <T extends PlanItem> T findPlanItem(String ciId, ResolveOptions resolveOptions) {
        Release release;
        String string = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(ciId));
        Option option = IdMatchers.ReleaseId$.MODULE$.unapply(string);
        if (!option.isEmpty()) {
            String id = (String)option.get();
            release = this.findRelease(id, resolveOptions);
        } else {
            Option option2 = IdMatchers.PhaseId$.MODULE$.unapply(string);
            if (!option2.isEmpty()) {
                String id = (String)option2.get();
                release = this.findRelease(Ids.releaseIdFrom((String)id), resolveOptions).getPhase(id);
            } else {
                Option option3 = IdMatchers.TaskId$.MODULE$.unapply(string);
                if (!option3.isEmpty()) {
                    String id = (String)option3.get();
                    release = this.findRelease(Ids.releaseIdFrom((String)id), resolveOptions).getTask(id);
                } else {
                    throw new NotFoundException(new StringBuilder(17).append("Item [").append(string).append("] not found").toString(), new Object[0]);
                }
            }
        }
        return (T)release;
    }

    private <Release> Release findRelease(String id, ResolveOptions resolveOptions) {
        String releaseId = Ids.releaseIdFrom((String)CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
        return (Release)this.releasePersistence().findByReleaseId(releaseId).map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, resolveOptions)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(20).append("Release [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    public SqlPlanItemRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        DeserializationSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

