/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.QueryTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.internal.ReleaseGlobalVariablesDecorator;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.query.JcrPredicate;
import com.xebialabs.xlrelease.repository.query.JcrQueryBuilder;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.SearchServiceWithPermissions;
import com.xebialabs.xlrelease.views.ReleaseOrderMode;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TemplateFilters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class JcrReleaseSearchService
extends SearchServiceWithPermissions
implements ReleaseSearchService {
    private ArchivingService archivingService;
    private Teams teams;
    private InternalMetadataDecoratorService decoratorService;

    public JcrReleaseSearchService(RepositoryService repositoryService, ArchivingService archivingService, PermissionEnforcer permissionEnforcer, Teams teams, InternalMetadataDecoratorService decoratorService) {
        super(permissionEnforcer, repositoryService);
        this.archivingService = archivingService;
        this.teams = teams;
        this.decoratorService = decoratorService;
    }

    public ReleaseSearchResult search(ReleasesFilters releasesFilters, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        releasesFilters.checkConsistency();
        if (!releasesFilters.hasASelectedFilter()) {
            return new ReleaseSearchResult();
        }
        List<Release> nextReleases = this.findNextReleases(releasesFilters, page, numberByPage, depth, filterOnPermissions);
        return this.toSearchResult(page, nextReleases);
    }

    public ReleaseSearchResult searchTemplates(TemplateFilters templateFilters, long page, long numberByPage, int depth) {
        List<Release> nextTemplates = this.findNextTemplates(templateFilters, page, numberByPage, depth);
        return this.toSearchResult(page, nextTemplates);
    }

    public List<String> findAllTemplateIds() {
        SearchParameters params = new SearchParameters().setType(Type.valueOf(Release.class)).setDepth(1).addProperty("status", ReleaseStatus.TEMPLATE.name());
        return this.repositoryService.list(params).stream().map(ConfigurationItemData::getId).collect(Collectors.toList());
    }

    public List<String> findAllActiveReleaseIds() {
        SearchParameters params = new SearchParameters().setType(Type.valueOf(Release.class)).setDepth(1).addOrPropertiesExpression("status", Arrays.stream(ReleaseStatus.ACTIVE_STATUSES).map(Enum::name).collect(Collectors.toSet()));
        return this.repositoryService.list(params).stream().map(ConfigurationItemData::getId).collect(Collectors.toList());
    }

    public List<String> findAllPendingReleaseIds() {
        SearchParameters params = new SearchParameters().setType(Type.valueOf(Release.class)).setDepth(1).addProperty("status", ReleaseStatus.PLANNED.name()).addProperty("autoStart", "true");
        return this.repositoryService.list(params).stream().map(ConfigurationItemData::getId).collect(Collectors.toList());
    }

    public boolean existsByName(String candidateName) {
        QueryTemplate queryTemplate = JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.hasName("ci", candidateName)).build();
        return !this.repositoryService.list(queryTemplate).isEmpty();
    }

    private QueryTemplate queryReleasesOrderByStartDate(ReleasesFilters releasesFilters) {
        return JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.and(this.commonJcrPredicates(releasesFilters))).orderBy("queryableStartDate DESC, title ASC").build();
    }

    private QueryTemplate queryReleasesOrderByEndDate(ReleasesFilters releasesFilters) {
        return JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.and(this.commonJcrPredicates(releasesFilters))).orderBy("queryableEndDate DESC, title ASC").build();
    }

    private QueryTemplate queryReleasesOrderByRiskScore(ReleasesFilters releasesFilters) {
        return JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.and(this.commonJcrPredicates(releasesFilters))).orderBy("riskScore DESC, totalRiskScore DESC, title ASC").build();
    }

    private List<JcrPredicate> commonJcrPredicates(ReleasesFilters releasesFilters) {
        ArrayList filters = Lists.newArrayList((Object[])new JcrPredicate[]{JcrPredicate.as("ci", Release.class)});
        this.filterOnOwner(filters, releasesFilters);
        this.filterOnFlagStatus(filters, releasesFilters);
        this.filterOnTitle(filters, releasesFilters.getTitle());
        this.filterOnDates(filters, releasesFilters);
        this.filterOnStatuses(filters, releasesFilters);
        this.filterOnParentId(filters, releasesFilters.getParentId());
        this.filterOnTags(filters, releasesFilters.getTags());
        return filters;
    }

    private List<Release> findNextTemplates(TemplateFilters templateFilters, long page, long numberByPage, int depth) {
        ArrayList filters = Lists.newArrayList((Object[])new JcrPredicate[]{JcrPredicate.as("ci", Release.class)});
        this.filterOnTitle(filters, templateFilters.getTitle());
        this.filterOnTags(filters, templateFilters.getTags());
        this.filterOnParentId(filters, templateFilters.getParentId());
        this.restrictToTemplates(filters);
        QueryTemplate queryTemplate = JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.and(filters)).orderBy("title ASC").build();
        return this.queryEntitiesWithPagination(page, numberByPage, queryTemplate, depth, Collections.singletonList(XLReleasePermissions.VIEW_TEMPLATE));
    }

    public List<Release> searchReleasesByTitle(String releaseName, long page, long numberByPage, int depth) {
        ArrayList filters = Lists.newArrayList((Object[])new JcrPredicate[]{JcrPredicate.as("ci", Release.class)});
        this.filterOnReleaseName(filters, releaseName);
        QueryTemplate queryTemplate = JcrQueryBuilder.select("*").from("ci").where(JcrPredicate.and(filters)).orderBy("queryableStartDate DESC, title ASC").build();
        return this.queryEntitiesAndFilterByPermissions(page, numberByPage, queryTemplate, depth, Collections.singletonList(XLReleasePermissions.VIEW_RELEASE));
    }

    private void filterOnFlagStatus(List<JcrPredicate> filters, ReleasesFilters releasesFilters) {
        if (releasesFilters.withOnlyFlagged()) {
            filters.add(JcrPredicate.or(JcrPredicate.equal("realFlagStatus", FlagStatus.AT_RISK.toString()), JcrPredicate.equal("realFlagStatus", FlagStatus.ATTENTION_NEEDED.toString())));
        }
    }

    private void filterOnOwner(List<JcrPredicate> filters, ReleasesFilters releasesFilters) {
        if (releasesFilters.withOnlyMine()) {
            filters.add(JcrPredicate.equal("owner", Permissions.getAuthenticatedUserName()));
        }
    }

    private void filterOnTitle(List<JcrPredicate> filters, String filter) {
        if (!Strings.isNullOrEmpty((String)filter)) {
            filters.add(JcrPredicate.and(JcrPredicate.likeIgnoringCase("title", filter)));
        }
    }

    private void filterOnTags(List<JcrPredicate> filters, List<String> tags) {
        if (tags != null) {
            filters.add(JcrPredicate.containsAll("tags", tags));
        }
    }

    private void filterOnDates(List<JcrPredicate> filters, ReleasesFilters releasesFilters) {
        Date from = releasesFilters.getQueryStartDate();
        Date to = releasesFilters.getQueryEndDate();
        if (from != null) {
            filters.add(JcrPredicate.greaterThan("queryableEndDate", from.getTime()));
        }
        if (to != null) {
            filters.add(JcrPredicate.lowerThan("queryableStartDate", to.getTime()));
        }
    }

    private void filterOnStatuses(List<JcrPredicate> filters, ReleasesFilters releasesFilters) {
        List statuses = releasesFilters.getStatuses();
        if (!statuses.isEmpty()) {
            filters.add(JcrPredicate.or(statuses.stream().map(status -> JcrPredicate.equal("status", status.name())).collect(Collectors.toList())));
        }
    }

    private void restrictToTemplates(List<JcrPredicate> filters) {
        filters.add(JcrPredicate.equal("status", ReleaseStatus.TEMPLATE.name()));
    }

    private void filterOnReleaseName(List<JcrPredicate> filters, String releaseName) {
        filters.add(JcrPredicate.equal("title", releaseName));
    }

    private void filterOnParentId(List<JcrPredicate> filters, String parentId) {
        if (!Strings.isNullOrEmpty((String)parentId)) {
            filters.add(JcrPredicate.isChildNode("ci", JcrPathHelper.getAbsolutePathFromId((String)parentId)));
        }
    }

    private List<Release> findNextReleases(ReleasesFilters releasesFilters, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        releasesFilters.checkConsistency();
        if (releasesFilters.withInactive() || releasesFilters.withAborted() || releasesFilters.withCompleted()) {
            QueryTemplate queryTemplate = this.queryReleasesOrderByEndDate(releasesFilters);
            return this.findNextCompletedReleases(releasesFilters, queryTemplate, page, numberByPage, depth, filterOnPermissions);
        }
        if (releasesFilters.withOnlyArchived()) {
            return this.searchInArchive(releasesFilters, numberByPage, numberByPage * page);
        }
        QueryTemplate queryTemplate = ReleaseOrderMode.start_date == releasesFilters.getOrderBy() ? this.queryReleasesOrderByStartDate(releasesFilters) : (ReleaseOrderMode.end_date == releasesFilters.getOrderBy() ? this.queryReleasesOrderByEndDate(releasesFilters) : this.queryReleasesOrderByRiskScore(releasesFilters));
        return this.findNextRunningReleases(queryTemplate, page, numberByPage, depth, filterOnPermissions);
    }

    private List<Release> findNextRunningReleases(QueryTemplate queryTemplate, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        List<Permission> permissions = filterOnPermissions ? Collections.singletonList(XLReleasePermissions.VIEW_RELEASE) : Collections.emptyList();
        return this.queryEntitiesWithPagination(page, numberByPage, queryTemplate, depth, permissions);
    }

    private List<Release> findNextCompletedReleases(ReleasesFilters releasesFilters, QueryTemplate queryTemplate, long page, long numberByPage, int depth, boolean filterOnPermissions) {
        List<Object> permissions = filterOnPermissions ? Collections.singletonList(XLReleasePermissions.VIEW_RELEASE) : Collections.emptyList();
        List<Release> jcrReleases = this.queryEntitiesWithPagination(page, numberByPage, queryTemplate, depth, permissions);
        if ((long)jcrReleases.size() >= numberByPage) {
            return jcrReleases;
        }
        if (jcrReleases.size() > 0) {
            List<Release> dbReleases = this.searchInArchive(releasesFilters, numberByPage - (long)jcrReleases.size(), 0L);
            jcrReleases.addAll(dbReleases);
            return jcrReleases;
        }
        int numberOfJcrReleases = this.queryEntitiesWithPagination(0L, Integer.MAX_VALUE, queryTemplate, 0, permissions).size();
        long offset = numberByPage * page - (long)numberOfJcrReleases;
        return this.searchInArchive(releasesFilters, numberByPage, offset);
    }

    private List<Release> searchInArchive(ReleasesFilters releasesFilters, long numberByPage, long offset) {
        List releases = this.archivingService.searchReleases(releasesFilters, numberByPage, offset);
        this.decoratorService.decorate((Collection)releases, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return releases;
    }

    private List<Release> queryEntitiesWithPagination(long page, long numberByPage, QueryTemplate queryTemplate, int depth, List<Permission> viewPermissions) {
        List<Object> releases = viewPermissions.isEmpty() ? this.queryEntities(page, numberByPage, queryTemplate, depth) : this.queryEntitiesAndFilterByPermissions(page, numberByPage, queryTemplate, depth, viewPermissions);
        this.teams.decorateWithEffectiveTeams(releases);
        this.decoratorService.decorate(releases, Arrays.asList(ReleaseGlobalVariablesDecorator.GLOBAL_VARIABLES(), EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        return releases;
    }

    private <T extends ConfigurationItem> List<T> queryEntities(long page, long numberByPage, QueryTemplate queryTemplate, int depth) {
        queryTemplate.setPage(page);
        queryTemplate.setResultsPerPage(numberByPage);
        queryTemplate.setDepth(depth);
        return this.repositoryService.listEntities(queryTemplate);
    }

    private ReleaseSearchResult toSearchResult(long page, List<Release> nextTemplates) {
        ReleaseSearchResult result = new ReleaseSearchResult();
        result.addReleases(nextTemplates);
        result.setPage(++page);
        return result;
    }
}

