/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.jcr;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseRestart;
import com.xebialabs.xlrelease.repository.PhaseRestart$;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskBackup;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Profile(value={"!sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u00015\u0011qBS2s!\"\f7/\u001a*fgR\f'\u000f\u001e\u0006\u0003\u0007\u0011\t1A[2s\u0015\t)a!\u0001\u0006sKB|7/\u001b;pefT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0003\n\u0005]!!\u0001\u0004)iCN,'+Z:uCJ$\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0011I,G.Z1tKN\u0004\"!F\u000e\n\u0005q!!\u0001\u0003*fY\u0016\f7/Z:\t\u0011y\u0001!\u0011!Q\u0001\n}\ta\u0001\u001d5bg\u0016\u001c\bCA\u000b!\u0013\t\tCA\u0001\u0004QQ\u0006\u001cXm\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005I1o\u00195fIVdWM\u001d\t\u0003K-j\u0011A\n\u0006\u0003G\u001dR!\u0001K\u0015\u0002\u0011AdW/\u001c2j]\u001eT!A\u000b\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001\f\u0014\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002\u0015Q\f7o\u001b\"bG.,\b\u000f\u0005\u0002\u0016a%\u0011\u0011\u0007\u0002\u0002\u000b)\u0006\u001c8NQ1dWV\u0004\b\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u0017A,'/\\5tg&|gn\u001d\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\t\u0001b]3dkJLG/_\u0005\u0003sY\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0011!Y\u0004A!A!\u0002\u0013a\u0014!\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dKB\u0011QhP\u0007\u0002})\u0011Q!K\u0005\u0003\u0001z\u0012\u0011CU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0015aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\u000fM,'O^5dK&\u0011\u0001*\u0012\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0003E!W\r]3oI\u0016t7-_*feZL7-\u001a\t\u0003\t2K!!T#\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU3sm&\u001cW\r\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\t\tF+D\u0001S\u0015\t\u0019f!\u0001\u0004bGR|'o]\u0005\u0003+J\u00131CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016D\u0001b\u0016\u0001\u0003\u0002\u0003\u0006Y\u0001W\u0001\tKZ,g\u000e\u001e\"vgB\u0011\u0011\fX\u0007\u00025*\u00111LB\u0001\u0007KZ,g\u000e^:\n\u0005uS&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\")q\f\u0001C\u0001A\u00061A(\u001b8jiz\"\"\"Y3gO\"L'n\u001b7n)\t\u0011G\r\u0005\u0002d\u00015\t!\u0001C\u0003X=\u0002\u000f\u0001\fC\u0003\u001a=\u0002\u0007!\u0004C\u0003\u001f=\u0002\u0007q\u0004C\u0003$=\u0002\u0007A\u0005C\u0003/=\u0002\u0007q\u0006C\u00034=\u0002\u0007A\u0007C\u0003<=\u0002\u0007A\bC\u0003C=\u0002\u00071\tC\u0003K=\u0002\u00071\nC\u0003P=\u0002\u0007\u0001\u000b\u000b\u0002__B\u0011\u0001o_\u0007\u0002c*\u0011!o]\u0001\u000bC:tw\u000e^1uS>t'B\u0001;v\u0003\u001d1\u0017m\u0019;pefT!A^<\u0002\u000b\t,\u0017M\\:\u000b\u0005aL\u0018aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003i\f1a\u001c:h\u0013\ta\u0018OA\u0005BkR|w/\u001b:fI\")a\u0010\u0001C!\u007f\u0006i!/Z:uCJ$\b\u000b[1tKN$\"\"!\u0001\u0002\u000e\u0005\u001d\u00121FA\u0018!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\r\u00051Am\\7bS:LA!a\u0003\u0002\u0006\t9!+\u001a7fCN,\u0007bBA\b{\u0002\u0007\u0011\u0011C\u0001\ne\u0016dW-Y:f\u0013\u0012\u0004B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9\u0002E\u0007\u0003\u00033Q1!a\u0007\r\u0003\u0019a$o\\8u}%\u0019\u0011q\u0004\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\ty\u0002\u0005\u0005\b\u0003Si\b\u0019AA\t\u0003\u001d\u0001\b.Y:f\u0013\u0012Dq!!\f~\u0001\u0004\t\t\"\u0001\u0004uCN\\\u0017\n\u001a\u0005\n\u0003ci\b\u0013!a\u0001\u0003g\tA\u0002\u001d5bg\u00164VM]:j_:\u00042!FA\u001b\u0013\r\t9\u0004\u0002\u0002\r!\"\f7/\u001a,feNLwN\u001c\u0005\b\u0003w\u0001A\u0011IA\u001f\u00035\u0011Xm\u001d;pe\u0016\u0004\u0006.Y:fgR!\u0011qHA+!\u0019\t\t%a\u0013\u0002P5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003vi&d'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0004\u0005E\u0013\u0002BA*\u0003\u000b\u0011Q\u0001\u00155bg\u0016D\u0001\"a\u0016\u0002:\u0001\u0007\u0011qH\u0001\u0010a\"\f7/Z:U_J+7\u000f^8sK\"\"\u0011\u0011HA.!\u0011\ti&a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\n1\"\u00198o_R\fG/[8og*!\u0011QMA4\u0003\u0019\u0019w.\\7p]*\u0019\u0011\u0011\u000e\u0006\u0002\r\u001d|wn\u001a7f\u0013\u0011\ti'a\u0018\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\rC\u0004\u0002r\u0001!I!a\u001d\u0002'\r|\u0007/_!oIJ+7\u000f^8sKBC\u0017m]3\u0015\t\u0005=\u0013Q\u000f\u0005\t\u0003o\ny\u00071\u0001\u0002P\u0005)\u0001\u000f[1tK\"9\u00111\u0010\u0001\u0005\n\u0005u\u0014\u0001\u0004:fgR|'/\u001a+bg.\u001cHCBA@\u0003\u000b\u000b\t\u000bE\u0002\u0010\u0003\u0003K1!a!\u0011\u0005\u0011)f.\u001b;\t\u0011\u0005\u001d\u0015\u0011\u0010a\u0001\u0003\u0013\u000bQb\u001c:jO&t\u0017\r\u001c+bg.\u001c\bCBAF\u0003+\u000bYJ\u0004\u0003\u0002\u000e\u0006Ee\u0002BA\f\u0003\u001fK\u0011!E\u0005\u0004\u0003'\u0003\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003/\u000bIJA\u0002TKFT1!a%\u0011!\u0011\t\u0019!!(\n\t\u0005}\u0015Q\u0001\u0002\u0005)\u0006\u001c8\u000e\u0003\u0005\u0002$\u0006e\u0004\u0019AAE\u0003!qWm\u001e+bg.\u001c\bbBAT\u0001\u0011%\u0011\u0011V\u0001\fe\u0016\u0004H.Y2f)\u0006\u001c8\u000e\u0006\u0005\u0002\u001c\u0006-\u0016qVA]\u0011!\ti+!*A\u0002\u0005%\u0015aC2pa&,G\rV1tWND\u0001\"!-\u0002&\u0002\u0007\u00111W\u0001\u0006S:$W\r\u001f\t\u0004\u001f\u0005U\u0016bAA\\!\t\u0019\u0011J\u001c;\t\u0011\u0005m\u0016Q\u0015a\u0001\u00037\u000bAB]3ti>\u0014X\r\u001a+bg.Dq!a0\u0001\t\u0013\t\t-A\u0003sKN,G\u000f\u0006\u0004\u0002\u0000\u0005\r\u0017Q\u0019\u0005\t\u0003w\u000bi\f1\u0001\u0002\u001c\"A\u0011qYA_\u0001\u0004\tY*\u0001\u0006d_BLW\r\u001a+bg.D\u0001\"a3\u0001\t\u0003!\u0011QZ\u0001\u001dkB$\u0017\r^3HCR,7OU3gKJ,gnY5oOBC\u0017m]3t)\u0019\ty(a4\u0002R\"A\u0011qKAe\u0001\u0004\ty\u0004\u0003\u0005\u0002T\u0006%\u0007\u0019AA \u00039\u0011Xm\u001d;pe\u0016$\u0007\u000b[1tKNDC!!3\u0002\\!A\u0011\u0011\u001c\u0001\u0005\u0002\u0011\tY.A\u0007va\u0012\fG/\u001a*fY\u0016\f7/\u001a\u000b\u0007\u0003\u007f\ni.!9\t\u0011\u0005}\u0017q\u001ba\u0001\u0003\u0003\tqA]3mK\u0006\u001cX\r\u0003\u0005\u0002T\u0006]\u0007\u0019AA Q\u0011\t9.a\u0017\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\u0006)1\r\\8tKR!\u0011qPAv\u0011!\ti/!:A\u0002\u0005=\u0013\u0001D2veJ,g\u000e\u001e)iCN,\u0007bBAy\u0001\u0011%\u00111_\u0001\u0010g.L\u0007\u000fV1tWN\u0014UMZ8sKRA\u0011qPA{\u0003o\fY\u0010\u0003\u0005\u0002.\u0005=\b\u0019AA\t\u0011!\tI0a<A\u0002\u0005=\u0013!D8sS\u001eLg.\u00197QQ\u0006\u001cX\r\u0003\u0005\u0002~\u0006=\b\u0019AA(\u00035\u0011Xm\u001d;pe\u0016$\u0007\u000b[1tK\"I!\u0011\u0001\u0001\u0012\u0002\u0013\u0005!1A\u0001\u0018e\u0016\u001cH/\u0019:u!\"\f7/Z:%I\u00164\u0017-\u001e7uIQ*\"A!\u0002+\t\u0005M\"qA\u0016\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00145\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0005v]\u000eDWmY6fI*\u0011!\u000fE\u0005\u0005\u0005+\u0011iAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D3\u0001\u0001B\r!\u0011\u0011YB!\t\u000e\u0005\tu!b\u0001B\u0010o\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t\r\"Q\u0004\u0002\n\u0007>l\u0007o\u001c8f]RDs\u0001\u0001B\u0014\u0005k\u00119\u0004\u0005\u0003\u0003*\tERB\u0001B\u0016\u0015\r\u0011(Q\u0006\u0006\u0004\u0005_9\u0018aB2p]R,\u0007\u0010^\u0005\u0005\u0005g\u0011YCA\u0004Qe>4\u0017\u000e\\3\u0002\u000bY\fG.^3-\u0005\te\u0012E\u0001B\u001e\u0003\u0011\t3/\u001d7")
public class JcrPhaseRestart
implements PhaseRestart {
    private final Releases releases;
    private final Phases phases;
    private final Scheduler scheduler;
    private final TaskBackup taskBackup;
    private final PermissionChecker permissions;
    private final RepositoryService repositoryService;
    private final CiIdService ciIdService;
    private final DependencyService dependencyService;
    private final ReleaseActorService releaseActorService;
    private final XLReleaseEventBus eventBus;

    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion) {
        Release release = this.releases.findById(releaseId);
        if (!release.hasNoAutomatedTaskRunning()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, "You attempted to restart phases on a release with running automated tasks");
        }
        List phasesToRestore = PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId);
        PhaseVersion phaseVersion2 = phaseVersion;
        if (PhaseVersion.LATEST.equals(phaseVersion2)) {
            phasesToRestore = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JcrPhaseRestart.$anonfun$restartPhases$1(p)))).asJava();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PhaseVersion.ORIGINAL.equals(phaseVersion2)) {
            phasesToRestore = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isOriginal()))).asJava();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PhaseVersion.ALL.equals(phaseVersion2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (phasesToRestore.isEmpty()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, "There are no " + phaseVersion + " phases to restart from " + phaseId);
        }
        PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.get(0), this.permissions);
        List<Phase> restoredPhases = this.restorePhases(phasesToRestore);
        this.updateGatesReferencingPhases(phasesToRestore, restoredPhases);
        this.updateRelease(release, restoredPhases);
        this.close(release.getCurrentPhase());
        this.skipTasksBefore(taskId, (Phase)phasesToRestore.get(0), restoredPhases.get(0));
        return this.releases.findById(release.getId());
    }

    public PhaseVersion restartPhases$default$4() {
        return PhaseVersion.ALL;
    }

    @VisibleForTesting
    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).map((Function1 & Serializable & scala.Serializable)originalPhase -> {
            void var2_2;
            Phase copiedAndRestoredPhase = this.copyAndRestorePhase((Phase)originalPhase);
            this.restoreTasks((Seq<Task>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(originalPhase.getTasks()).asScala()), (Seq<Task>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(copiedAndRestoredPhase.getTasks()).asScala()));
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Phase copyAndRestorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.phases.getUniqueId(Ids.releaseIdFrom((String)phase.getId()));
        this.repositoryService.copy(phase.getId(), restoredPhaseId);
        Phase copiedPhase = (Phase)this.repositoryService.read(restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        copiedPhase.setOriginId(phase.getId());
        this.repositoryService.update((ConfigurationItem[])new Phase[]{copiedPhase});
        return var3_3;
    }

    private void restoreTasks(Seq<Task> originalTasks, Seq<Task> newTasks) {
        originalTasks.indices().foreach((Function1 & Serializable & scala.Serializable)i -> JcrPhaseRestart.$anonfun$restoreTasks$1(this, newTasks, BoxesRunTime.unboxToInt((Object)i)));
    }

    private Task replaceTask(Seq<Task> copiedTasks, int index, Task restoredTask) {
        Task copiedTask = (Task)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(copiedTasks).asJava()).get(index);
        this.reset(restoredTask, copiedTask);
        CiHelper.eraseTokens((ConfigurationItem)restoredTask);
        this.repositoryService.update((ConfigurationItem[])new Task[]{restoredTask});
        return ((List)JavaConverters$.MODULE$.seqAsJavaListConverter(copiedTasks).asJava()).set(index, restoredTask);
    }

    private void reset(Task restoredTask, Task copiedTask) {
        restoredTask.setStatus(TaskStatus.PLANNED);
        Buffer commentIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(copiedTask.getComments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)CiHelper.TO_ID.apply(x$1), Buffer$.MODULE$.canBuildFrom());
        this.repositoryService.delete((String[])commentIds.toArray(ClassTag$.MODULE$.apply(String.class)));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            gateTask.getConditions().forEach(condition -> {
                condition.setChecked(false);
                $this.repositoryService.update((ConfigurationItem[])new GateCondition[]{condition});
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @VisibleForTesting
    public void updateGatesReferencingPhases(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala());
        this.scheduler.execute(() -> ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).flatMap((Function1 & Serializable & scala.Serializable)phase -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.dependencyService.findActiveIncomingGateIds(phase.getId())).asScala(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.releaseActorService.updateGateReferencingPhases(x$2, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)originToRestored).asJava());
            return BoxedUnit.UNIT;
        }));
    }

    @VisibleForTesting
    public void updateRelease(Release release, List<Phase> restoredPhases) {
        Changes changes = release.restorePhases(restoredPhases);
        VariablePersistenceHelper$.MODULE$.scanAndCreateNewVariables(release, this.repositoryService, this.ciIdService);
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    private void close(Phase currentPhase) {
        Changes changes = currentPhase.close();
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        this.repositoryService.update(changes.toUpdatedItemsArray());
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    private void skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        block0: {
            int taskIndexToRestartFrom = ((GenSeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalPhase.getTasks()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom())).indexOf((Object)taskId);
            if (taskIndexToRestartFrom <= 0) break block0;
            Changes changes = new Changes();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Task task = (Task)restoredPhase.getTasks().get(i);
                changes.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
            });
            XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
            this.repositoryService.update(changes.toUpdatedItemsArray());
            XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
        }
    }

    public static final /* synthetic */ boolean $anonfun$restartPhases$1(Phase p) {
        return !p.isPhaseCopied() && p.isLatestCopy();
    }

    public static final /* synthetic */ Task $anonfun$restoreTasks$1(JcrPhaseRestart $this, Seq newTasks$1, int i) {
        Task restoredTask = $this.taskBackup.restoreTask((Task)((List)JavaConverters$.MODULE$.seqAsJavaListConverter(newTasks$1).asJava()).get(i), $this.taskBackup.restoreTask$default$2(), $this.taskBackup.restoreTask$default$3());
        return $this.replaceTask((Seq<Task>)newTasks$1, i, restoredTask);
    }

    @Autowired
    public JcrPhaseRestart(Releases releases, Phases phases, Scheduler scheduler, TaskBackup taskBackup, PermissionChecker permissions, RepositoryService repositoryService, CiIdService ciIdService, DependencyService dependencyService, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.releases = releases;
        this.phases = phases;
        this.scheduler = scheduler;
        this.taskBackup = taskBackup;
        this.permissions = permissions;
        this.repositoryService = repositoryService;
        this.ciIdService = ciIdService;
        this.dependencyService = dependencyService;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }
}

