package com.xebialabs.xlrelease.security.sql

import com.xebialabs.deployit.security.Role
import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlrelease.config.CacheManagementConstants._
import com.xebialabs.xlrelease.domain.distributed.events.EvictPermissionsEvent
import com.xebialabs.xlrelease.events.Subscribe
import com.xebialabs.xlrelease.security.sql.SecurityCacheConfigurationConstants._
import com.xebialabs.xlrelease.security.sql.db.Ids.{GLOBAL_SECURITY_ALIAS, isGlobalId}
import com.xebialabs.xlrelease.service.BroadcastService
import org.springframework.cache.annotation.{CacheConfig, CacheEvict, Cacheable, Caching}

import java.{lang, util}

@CacheConfig(cacheManager = SECURITY_CACHE_MANAGER)
class CachingPermissionEditor(securityDatabase: Database, broadcastService: BroadcastService)
  extends SqlPermissionEditor(securityDatabase) {

  @Subscribe
  @Caching(evict = Array(
    new CacheEvict(cacheNames = Array(SECURITY_PERMISSIONS), key = ON_CI_OR_GLOBAL),
    new CacheEvict(cacheNames = Array(SECURITY_USER_PERMISSIONS, SECURITY_PERMISSION_ROLES), key = "'regex:' + (#onConfigurationItem?:'global') + '-.*'")
  ))
  override def editPermissions(onConfigurationItem: String, permissions: util.Map[Role, util.Set[Permission]]): Unit = {
    super.editPermissions(onConfigurationItem, permissions)
    expireCache(onConfigurationItem)
  }

  @Caching(evict = Array(
    new CacheEvict(cacheNames = Array(SECURITY_PERMISSIONS), key = ON_CI_OR_GLOBAL),
    new CacheEvict(cacheNames = Array(SECURITY_USER_PERMISSIONS, SECURITY_PERMISSION_ROLES), key = "'regex:' + (#onConfigurationItem?:'global') + '-.*'")
  ))
  override def updatePermissions(onConfigurationItem: String,
                                 addedPermissions: util.Map[Role, util.List[Permission]],
                                 removedPermissions: util.Map[Role, util.List[Permission]]): Unit = {
    super.updatePermissions(onConfigurationItem, addedPermissions, removedPermissions)
    expireCache(onConfigurationItem)
  }

  @Cacheable(cacheNames = Array(SECURITY_PERMISSIONS), key = ON_CI_OR_GLOBAL)
  override def readPermissions(onConfigurationItem: String, includeInherited: lang.Boolean): util.Map[Role, util.Set[Permission]] = {
    super.readPermissions(onConfigurationItem, includeInherited)
  }

  @Cacheable(cacheNames = Array(SECURITY_PERMISSIONS), key = ON_CI_OR_GLOBAL)
  override def readPermissions(onConfigurationItem: String): util.Map[Role, util.Set[Permission]] = {
    super.readPermissions(onConfigurationItem)
  }

  private def expireCache(onConfigurationItem: String): Unit = {
    val target = if (isGlobalId(Option(onConfigurationItem))) GLOBAL_SECURITY_ALIAS else onConfigurationItem
    broadcastService.broadcast(EvictPermissionsEvent(target), false)
  }
}
