/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.sql;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.xlplatform.repository.sql.Database;
import com.xebialabs.xlrelease.security.sql.db.Tables;
import com.xebialabs.xlrelease.security.sql.db.Tables$;
import com.xebialabs.xlrelease.security.sql.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import slick.ast.BaseTypedType;
import slick.ast.TypedCollectionTypeConstructor$;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.LiteralColumn;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.StringColumnExtensionMethods$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\f\u0018\u0001\tB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\u0019\u0006\u0001)A\u0005\u0017\"9A\u000b\u0001b\u0001\n\u0013)\u0006BB-\u0001A\u0003%a\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r}\u0003\u0001\u0015!\u0003]\u000b\u0011\u0001\u0007\u0001A1\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\tI\b\u0001C!\u0003wBq!a!\u0001\t\u0003\n)\tC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005=\u0005\u0001\"\u0011\u0002B\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAb\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\ti\u000e\u0001C!\u0003?\u0014abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005qi\u0012!\u0003=me\u0016dW-Y:f\u0015\tqr$A\u0005yK\nL\u0017\r\\1cg*\t\u0001%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001G-\u0012\u0004C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011a\u0017M\\4\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u00051\u0002T\"A\u0017\u000b\u0005iq#BA\u0018\u001e\u0003!!W\r\u001d7ps&$\u0018BA\u0019.\u0005-)6/\u001a:TKJ4\u0018nY3\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014!B:mMRR'\"A\u001c\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u000f\u001b\u0003\u000f1{wmZ5oO\u0006\u00012/Z2ve&$\u0018\u0010R1uC\n\f7/\u001a\t\u0003y\tk\u0011!\u0010\u0006\u00031yR!a\u0010!\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002B;\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u0005\rk$\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\rqJg.\u001b;?)\t1\u0005\n\u0005\u0002H\u00015\tq\u0003C\u0003;\u0005\u0001\u00071(A\u0004qe>4\u0017\u000e\\3\u0016\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\t)$'m\u0019\u0006\u0002!\u0006)1\u000f\\5dW&\u0011!+\u0014\u0002\f\u0015\u0012\u00147\r\u0015:pM&dW-\u0001\u0005qe>4\u0017\u000e\\3!\u0003=\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014X#\u0001,\u0011\u00051:\u0016B\u0001-.\u0005U\u0019\u0006*\u0011\u001a6mA\u000b7o]<pe\u0012,enY8eKJ\f\u0001\u0003]1tg^|'\u000fZ#oG>$WM\u001d\u0011\u0002\u001d)\u001b%kX!E\u001b&su,V*F%V\tA\f\u0005\u0002%;&\u0011a,\n\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f)\u001b%kX!E\u001b&su,V*F%\u0002\u0012\u0011!\u0015\t\u0007E\u001elw/a\u0004\u000f\u0005\r,gB\u00013\u0004\u001b\u0005\u0001\u0011B\u00014R\u0003\r\t\u0007/[\u0005\u0003Q&\u0014Q!U;fefL!A[6\u0003\u000f\u0005c\u0017.Y:fg*\u0011AnT\u0001\u0007Y&4G/\u001a3\u0011\u00059$hBA8s\u001b\u0005\u0001(BA9\u0018\u0003\t!'-\u0003\u0002ta\u00061A+\u00192mKNL!!\u001e<\u0003\u000bU\u001bXM]:\u000b\u0005M\u0004\b\u0003\u0002=|{vl\u0011!\u001f\u0006\u0002u\u0006)1oY1mC&\u0011A0\u001f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001z\u001b\t\t\u0019AC\u0002\u0002\u0006\u0005\na\u0001\u0010:p_Rt\u0014bAA\u0005s\u00061\u0001K]3eK\u001aL1AXA\u0007\u0015\r\tI!\u001f\t\u0005\u0003#\tYB\u0004\u0003\u0002\u0014\u0005]a\u0002BA\u0001\u0003+I\u0011A_\u0005\u0004\u00033I\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyBA\u0002TKFT1!!\u0007z\u0003I\u0019\u0007.Z2l-\u0006d\u0017\u000eZ+tKJt\u0017-\\3\u0015\t\u0005\u0015\u00121\u0006\t\u0004q\u0006\u001d\u0012bAA\u0015s\n!QK\\5u\u0011\u0019\tiC\u0003a\u0001{\u0006AQo]3s]\u0006lW-A\u0006gS2$XM]+tKJ\u001cHCBA\u001a\u0003s\ty\u0004\u0005\u0005\u00026\u0005]Rn^A\b\u001b\u0005Y\u0017B\u00015l\u0011\u001d\tYd\u0003a\u0001\u0003{\tQ!];fef\u0004\"\u0001Z\u0005\t\r\u000552\u00021\u0001~\u0003!\u0011X-\u00193Vg\u0016\u0014H\u0003BA#\u0003W\u0002R\u0001_A$\u0003\u0017J1!!\u0013z\u0005\u0019y\u0005\u000f^5p]B!\u0011QJA4\u001d\r\tyE\u001d\b\u0005\u0003#\n)G\u0004\u0003\u0002T\u0005\rd\u0002BA+\u0003CrA!a\u0016\u0002`9!\u0011\u0011LA/\u001d\u0011\t\t!a\u0017\n\u0003\u0001J!AH\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002r/%\u0019\u0011\u0011\u000e<\u0003\tU\u001bXM\u001d\u0005\u0007\u0003[a\u0001\u0019A?\u0002\u0015\r|WO\u001c;Vg\u0016\u00148\u000f\u0006\u0003\u0002r\u0005]\u0004c\u0001=\u0002t%\u0019\u0011QO=\u0003\t1{gn\u001a\u0005\u0007\u0003[i\u0001\u0019A?\u0002\r\r\u0014X-\u0019;f)\u0019\t)#! \u0002\u0000!1\u0011Q\u0006\bA\u0002uDa!!!\u000f\u0001\u0004i\u0018\u0001\u00039bgN<xN\u001d3\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003\u000f\u000bi\tE\u0002-\u0003\u0013K1!a#.\u0005!\u0011V\r]8Vg\u0016\u0014\bBBA\u0017\u001f\u0001\u0007Q0A\u0007mSN$Xk]3s]\u0006lWm\u001d\u000b\t\u0003'\u000by*!)\u00028B)\u0011QSAN{6\u0011\u0011q\u0013\u0006\u0004\u00033;\u0013\u0001B;uS2LA!!(\u0002\u0018\n!A*[:u\u0011\u0019\ti\u0003\u0005a\u0001{\"9\u00111\u0015\tA\u0002\u0005\u0015\u0016A\u00029bO&tw\r\u0005\u0003\u0002(\u0006MVBAAU\u0015\u0011\tY+!,\u0002\u0007\u0011$xNC\u0002g\u0003_S1!!-/\u0003\u0019)gnZ5oK&!\u0011QWAU\u0005\u0019\u0001\u0016mZ5oO\"9\u0011\u0011\u0018\tA\u0002\u0005m\u0016!B8sI\u0016\u0014\b\u0003BAT\u0003{KA!a0\u0002*\nAqJ\u001d3fe&tw\r\u0006\u0002\u0002\u0014\u0006qQn\u001c3jMf\u0004\u0016m]:x_J$GCBA\u0013\u0003\u000f\fI\r\u0003\u0004\u0002.I\u0001\r! \u0005\u0007\u0003\u0017\u0014\u0002\u0019A?\u0002\u00179,w\u000fU1tg^|'\u000f\u001a\u000b\t\u0003K\ty-!5\u0002T\"1\u0011QF\nA\u0002uDa!a3\u0014\u0001\u0004i\bBBAk'\u0001\u0007Q0A\u0006pY\u0012\u0004\u0016m]:x_J$\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002&\u0005m\u0007BBA\u0017)\u0001\u0007Q0\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0004\u0002&\u0005\u0005\u00181\u001d\u0005\u0007\u0003[)\u0002\u0019A?\t\r\u0005\u0005U\u00031\u0001~\u0001")
public class SqlUserService
implements UserService,
Logging {
    private final Database securityDatabase;
    private final JdbcProfile profile;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String JCR_ADMIN_USER;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserService sqlUserService = this;
        synchronized (sqlUserService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcProfile profile() {
        return this.profile;
    }

    private SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private String JCR_ADMIN_USER() {
        return this.JCR_ADMIN_USER;
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        Option<Tuple2<String, String>> option = this.readUser(username);
        if (option instanceof Some) {
            throw new UserAlreadyExistsException(username);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Query<Tables.Users, Tuple2<String, String>, Seq> filterUsers(Query<Tables.Users, Tuple2<String, String>, Seq> query, String username2) {
        return (Query)Option$.MODULE$.apply((Object)username2).map((Function1 & Serializable)username -> query.filter((Function1 & Serializable)x$1 -> {
            Rep qual$1 = this.profile().api().stringColumnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$1.username())));
            LiteralColumn x$12 = this.profile().api().valueToConstColumn((Object)("%" + username.toLowerCase() + "%"), (TypedType)this.profile().api().stringColumnType());
            char x$2 = StringColumnExtensionMethods$.MODULE$.like$default$2$extension(qual$1);
            return StringColumnExtensionMethods$.MODULE$.like$extension(qual$1, (Rep)x$12, x$2, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType()));
        }, CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).getOrElse((Function0 & Serializable)() -> query);
    }

    private Option<Tuple2<String, String>> readUser(String username) {
        return ((IterableOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$2 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$2.username())), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username.toLowerCase(), (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)user -> new Tuple2(user.username(), user.password()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))))).result())).headOption();
    }

    public long countUsers(String username) {
        return BoxesRunTime.unboxToInt((Object)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)this.profile().api().recordQueryActionExtensionMethods((Object)this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)Tables$.MODULE$.users(), username).length(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().intColumnType()))).result()));
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        String pwd = this.passwordEncoder().encode((CharSequence)password);
        this.securityDatabase.runAwait(DBIOAction$.MODULE$.seq((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(Tables$.MODULE$.users())).$plus$eq((Object)new Tuple2((Object)username, (Object)pwd))})));
    }

    public RepoUser read(String username) {
        return (RepoUser)this.readUser(username).map((Function1 & Serializable)user -> new RepoUser((String)user._1(), this.JCR_ADMIN_USER().equals(user._1()))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No such user: " + username, new Object[0]);
        });
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        List filters = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)query -> this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)query, username), (Function1 & Serializable)query -> order == null || order.isAscending() ? query.sortBy((Function1 & Serializable)x$3 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$3.username())), (TypedType)this.profile().api().stringColumnType()).asc(), Predef$.MODULE$.$conforms()) : query.sortBy((Function1 & Serializable)x$4 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$4.username())), (TypedType)this.profile().api().stringColumnType()).desc(), Predef$.MODULE$.$conforms()), (Function1 & Serializable)query -> paging == null ? query : query.drop((paging.page() - 1) * paging.resultsPerPage()).take(paging.resultsPerPage())}));
        return package$.MODULE$.ListExtensions(((IterableOnceOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(((Query)filters.foldLeft((Object)Tables$.MODULE$.users().to(TypedCollectionTypeConstructor$.MODULE$.forColl(Seq$.MODULE$.iterableFactory(), ClassTag$.MODULE$.apply(Seq.class))), (Function2 & Serializable)(acc, filter) -> (Query)filter.apply(acc))).map((Function1 & Serializable)x$5 -> x$5.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public java.util.List<String> listUsernames() {
        return package$.MODULE$.ListExtensions(((IterableOnceOps)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().map((Function1 & Serializable)x$6 -> x$6.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public void modifyPassword(String username, String newPassword) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryUpdateActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$7 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$7.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable)x$8 -> x$8.password(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)this.passwordEncoder().encode((CharSequence)newPassword)));
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$3(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryDeleteActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable)x$9 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$9.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete());
    }

    public void authenticate(String username, String password) {
        String errorMessage = "Cannot authenticate " + username + ". Wrong username or password supplied.";
        Tuple2 user = (Tuple2)this.readUser(username).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException(errorMessage);
        });
        if (!this.passwordEncoder().matches((CharSequence)password, (String)user._2())) {
            throw new AuthenticationFailureException(errorMessage);
        }
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$3(SqlUserService $this, String oldPassword$1, String username$6, String newPassword$1, Tuple2 user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, (String)user._2())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$6, newPassword$1);
    }

    public SqlUserService(Database securityDatabase) {
        this.securityDatabase = securityDatabase;
        Logging.$init$((Logging)this);
        this.profile = securityDatabase.config().databaseType().profile();
        this.passwordEncoder = new SHA256PasswordEncoder();
        this.JCR_ADMIN_USER = "admin";
    }
}

