package com.xebialabs.xlrelease.script;

import java.net.URISyntaxException;
import java.net.URL;
import java.security.*;
import java.security.cert.Certificate;

public class ScriptPermissionsProvider {
    public static final String SCRIPT_POLICY_FILE = "script.policy";

    private boolean autoRefresh;
    private final PermissionCollection permissionCollection;

    public ScriptPermissionsProvider() {
        this(true);
    }

    public ScriptPermissionsProvider(boolean autoRefresh) {
        permissionCollection = loadPermissionCollection();
        this.autoRefresh = autoRefresh;
    }

    public PermissionCollection getScriptPermissions() {
        if (autoRefresh) {
            return loadPermissionCollection();
        } else {
            return permissionCollection;
        }
    }

    private PermissionCollection loadPermissionCollection() {
        try {
            URL policyFileUrl = ClassLoader.getSystemClassLoader().getResource(SCRIPT_POLICY_FILE);
            Policy.Parameters params = policyFileUrl == null ? null : new URIParameter(policyFileUrl.toURI());
            Policy scriptPolicy = Policy.getInstance("JavaPolicy", params);
            return scriptPolicy.getPermissions(new ProtectionDomain(new CodeSource(null, (Certificate[]) null), null));
        } catch (NoSuchAlgorithmException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}
