package com.xebialabs.xlrelease.script.security

import com.xebialabs.xlrelease.script.security.RuntimePermission.ALL_ACTION

import java.security.{BasicPermission, Permission}

object RuntimePermission {
  val ALL_ACTION: String = "all"
  val NONE_ACTION: String = "none"
}

class RuntimePermission(val name: String, val actions: String) extends BasicPermission(name, actions) {
  val ALL: Int = 0x1
  val NONE: Int = 0x0

  private val mask: Int = if (actions != null && RuntimePermission.NONE_ACTION == actions.trim.toLowerCase) {
    NONE
  } else {
    ALL
  }

  def this(name: String) = {
    this(name, ALL_ACTION)
  }

  override def implies(p: Permission): Boolean = {
    super.implies(p) && this.mask == p.asInstanceOf[RuntimePermission].mask
  }

  override def getActions: String = this.actions

  def canEqual(other: Any): Boolean = other.isInstanceOf[RuntimePermission]

  override def equals(other: Any): Boolean = other match {
    case that: RuntimePermission =>
      super.equals(that) &&
        (that canEqual this) &&
        mask == that.mask
    case _ => false
  }

  override def hashCode(): Int = {
    val state = Seq(super.hashCode(), mask, name)
    state.map(_.hashCode()).foldLeft(0)((a, b) => 31 * a + b)
  }
}

