package com.xebialabs.xlrelease.script.jython

import com.xebialabs.platform.script.jython.{ScriptSource, Syntactic}

object JythonScriptHelper {
  def wrapBindings(contextBindingNames: Iterable[String]): ScriptSource = Syntactic.wrapperCode(contextBindingNames)

  def unwrapBindings(contextBindingNames: Iterable[String]): ScriptSource = {
    val crlf = System.lineSeparator()
    val content = contextBindingNames.map { key =>
      s"""
         |if '$key' in globals():
         |  $key = _unwrapper.unwrap($key)""".stripMargin}.mkString(crlf)
    ScriptSource.byContent(content)
  }

}
