package com.xebialabs.xlrelease.runner

package object domain {
  type RunnerId = String

  type JobId = Long

  private val SEPARATOR = "/"

  implicit class RunnerIdOps(private val runnerId: RunnerId) extends AnyVal {
    def shortId(): RunnerId = getName(runnerId)

    def shardId(): String = {
      val numberOfShards = 3 // we don't expect many runners
      (math.abs(shortId().hashCode) % numberOfShards).toString
    }

  }

  private def getName(id: String): String = {
    if (id == null || !id.contains(SEPARATOR)) return id
    id.substring(id.lastIndexOf(SEPARATOR) + 1)
  }
}
