package com.xebialabs.xlrelease.runner.api.v1


import com.xebialabs.xlrelease.runner.api.v1.RunnerRegistrationResource.{RegisterRequest, RegisterResponse}
import com.xebialabs.xlrelease.runner.domain.ContextData
import jakarta.ws.rs.core.MediaType
import jakarta.ws.rs.{Consumes, POST, Path, Produces}

import java.util.Date

/**
 * This is internal API for runners and should not be documented.
 */
@Path("/api/v1/runners-registration")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait RunnerRegistrationResource {
  @POST
  @Path("/register")
  def register(req: RegisterRequest): RegisterResponse
}

object RunnerRegistrationResource {
  case class RegisterRequest(uuid: String, name: String, version: String, capabilities: Set[String], publicKey: String, tokenExpiryDate: Date)

  case class RegisterResponse(runnerId: String, isEnabled: Boolean, capacity: Int, evictionTime: Int, encryptJobData: Boolean, runnerToken: ContextData)
}
