/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.crypto.encrypt;

import com.xebialabs.xlrelease.runner.crypto.encrypt.JobDataEncryptor;
import com.xebialabs.xlrelease.runner.crypto.encrypt.JobDataEncryptor$;
import com.xebialabs.xlrelease.runner.crypto.encrypt.RSACoder$;
import com.xebialabs.xlrelease.runner.domain.EncryptedContextData;
import com.xebialabs.xlrelease.runner.domain.PlainContextData;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import scala.MatchError;
import scala.Tuple2;

public final class JobRSAUtils$ {
    public static final JobRSAUtils$ MODULE$ = new JobRSAUtils$();
    private static final String ALGORITHM = "RSA";
    private static final String DEFAULT_KEY_VERSION = "v0";

    private final String ALGORITHM() {
        return ALGORITHM;
    }

    public final String DEFAULT_KEY_VERSION() {
        return DEFAULT_KEY_VERSION;
    }

    public EncryptedContextData encryptContextData(String content, String publicKey, String keyVersion) {
        return this.encryptContextData(content, this.decodePublicKey(publicKey), keyVersion);
    }

    public PlainContextData decryptContextData(EncryptedContextData content, String publicKey) {
        return this.decryptContextData(content, this.decodePublicKey(publicKey));
    }

    public EncryptedContextData encryptContextData(String content, Key key, String keyVersion) {
        JobDataEncryptor jobDataEncryptor = JobDataEncryptor$.MODULE$.apply(true);
        String encryptedContent = jobDataEncryptor.encrypt(content);
        byte[] sessionKeyBytes = jobDataEncryptor.getEncodedSecretKey();
        String encryptedSessionKey = this.encryptSessionKey(sessionKeyBytes, key, keyVersion);
        return new EncryptedContextData(encryptedContent, encryptedSessionKey);
    }

    public PlainContextData decryptContextData(EncryptedContextData encryptedContent, Key key) {
        byte[] sessionKeyBytes = this.decryptSessionKey(encryptedContent.sessionKey(), key);
        JobDataEncryptor jobDataEncryptor = JobDataEncryptor$.MODULE$.apply(true);
        jobDataEncryptor.setSecretKey(sessionKeyBytes);
        String decryptedContent = jobDataEncryptor.decrypt(encryptedContent.data());
        return new PlainContextData(decryptedContent);
    }

    private PublicKey decodePublicKey(String b64PublicKey) {
        byte[] encodedPublicKey = Base64.getDecoder().decode(b64PublicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(this.ALGORITHM());
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }

    private String encryptSessionKey(byte[] sessionKeyBytes, Key key, String keyVersion) {
        Cipher encryptCipher = Cipher.getInstance(this.ALGORITHM());
        encryptCipher.init(1, key);
        byte[] encryptedSessionKeyBytes = encryptCipher.doFinal(sessionKeyBytes);
        return RSACoder$.MODULE$.encode(encryptedSessionKeyBytes, keyVersion);
    }

    private byte[] decryptSessionKey(String sessionKey, Key key) {
        byte[] encryptedSessionKeyBytes;
        Tuple2<byte[], String> tuple2 = RSACoder$.MODULE$.decode(sessionKey);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] byArray = encryptedSessionKeyBytes = (byte[])tuple2._1();
        byte[] encryptedSessionKeyBytes2 = byArray;
        Cipher decryptCipher = Cipher.getInstance(this.ALGORITHM());
        decryptCipher.init(2, key);
        return decryptCipher.doFinal(encryptedSessionKeyBytes2);
    }

    private JobRSAUtils$() {
    }
}

