package com.xebialabs.xlrelease.serialization.json.jackson;

import org.springframework.util.StringUtils;

import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

public interface DomainIdSerialization {
    private static boolean hasVariableSyntax(String rawValue) {
        var hasText = StringUtils.hasText(rawValue);
        if (hasText) {
            var trimmedValue = rawValue.trim();
            return trimmedValue.startsWith("${") && trimmedValue.endsWith("}");
        }
        return false;
    }

    default String toViewId(String value) {
        if (StringUtils.hasText(value)) {
            if (hasVariableSyntax(value)) {
                return value;
            } else {
                return DOMAIN.convertToViewId(value);
            }
        } else {
            return value;
        }
    }

    default String toInternalId(String value) {
        if (StringUtils.hasText(value)) {
            if (hasVariableSyntax(value)) {
                return value;
            } else {
                return DOMAIN.convertToInternalId(value);
            }
        } else {
            return value;
        }
    }
}
