/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization.json.xltype;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;
import com.xebialabs.deployit.plugin.api.udm.lookup.LookupValueKey;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.serialization.json.utils.JsonWithCachedProvider;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.util.DateUtil;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiJson2Writer
implements CiWriter,
AutoCloseable {
    protected final Writer writer;
    protected final JsonGenerator json;

    public CiJson2Writer() {
        this(new StringWriter());
    }

    public CiJson2Writer(Writer writer) {
        this.writer = writer;
        this.json = JsonWithCachedProvider.createGenerator(writer);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.writer.toString();
    }

    public void startList() {
        this.json.writeStartArray();
    }

    public void endList() {
        this.json.writeEnd();
        this.json.flush();
    }

    public void startCi(String type, String id) {
        this.json.writeStartObject();
        if (null == id) {
            this.json.writeNull("id");
        } else {
            this.json.write("id", id);
        }
        this.json.write("type", type);
    }

    public void endCi() {
        this.json.writeEnd();
        this.json.flush();
    }

    public void token(String token) {
        this.json.write("$token", token != null ? token : "");
    }

    public void ciAttributes(CiAttributes ciAttributes) {
        this.addStringAttribute("$createdBy", ciAttributes.getCreatedBy());
        this.addDateAttribute("$createdAt", ciAttributes.getCreatedAt());
        this.addStringAttribute("$lastModifiedBy", ciAttributes.getLastModifiedBy());
        this.addDateAttribute("$lastModifiedAt", ciAttributes.getLastModifiedAt());
        String scmTraceabilityDataInt = ciAttributes.getScmTraceabilityDataId();
        String scmTraceabilityData = null;
        if (scmTraceabilityDataInt != null) {
            scmTraceabilityData = scmTraceabilityDataInt;
        }
        this.addStringAttribute("$scmTraceabilityDataId", scmTraceabilityData);
    }

    public void ciFileAttribute(String file) {
        this.addStringAttribute("file", file);
    }

    private void addStringAttribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.json.write(attrName, attrValue);
        }
    }

    private void addDateAttribute(String attrName, DateTime attrValue) {
        if (attrValue != null) {
            this.json.write(attrName, DateUtil.toString((DateTime)attrValue));
        }
    }

    public void startProperty(String name) {
        this.json.writeKey(name);
    }

    public void endProperty() {
        this.json.flush();
    }

    public void valueAsString(Object value) {
        if (null == value) {
            this.json.writeNull();
        } else if (value instanceof Integer) {
            this.json.write(((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.json.write(((Long)value).longValue());
        } else if (value instanceof Byte) {
            this.json.write((int)((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.json.write((int)((Short)value).shortValue());
        } else if (value instanceof Double) {
            this.json.write(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.json.write((double)((Float)value).floatValue());
        } else if (value instanceof Boolean) {
            this.json.write(((Boolean)value).booleanValue());
        } else if (value instanceof BigDecimal) {
            this.json.write((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.json.write((BigInteger)value);
        } else if (value instanceof String) {
            this.json.write((String)value);
        } else {
            this.json.write(value.toString());
        }
    }

    public void valuesAsStrings(Collection<?> values) {
        this.json.writeStartArray();
        for (Object item : values) {
            this.valueAsString(item);
        }
        this.json.writeEnd();
    }

    public void mapAsStrings(Map<?, ?> map) {
        this.json.writeStartObject();
        for (Object key : map.keySet()) {
            this.json.writeKey(String.valueOf(key));
            this.valueAsString(map.get(key));
        }
        this.json.writeEnd();
    }

    public void ciReference(String reference) {
        this.valueAsString(reference);
    }

    public void ciReferences(Collection<String> references) {
        this.valuesAsStrings(references);
    }

    public void typedCiReference(ConfigurationItemId ci) {
        this.json.writeStartObject();
        this.json.write("ci", ci.getId());
        if (ci.getType() != null) {
            this.json.write("type", ci.getType().toString());
        }
        this.json.writeEnd();
    }

    public void typedCiReferences(Collection<? extends ConfigurationItemId> references) {
        this.json.writeStartArray();
        for (ConfigurationItemId configurationItemId : references) {
            this.typedCiReference(configurationItemId);
        }
        this.json.writeEnd();
    }

    public void validationMessages(List<ValidationMessage> validations) {
        this.json.writeKey("validation-messages");
        this.json.writeStartArray();
        for (ValidationMessage validation : validations) {
            this.json.writeStartObject();
            this.json.write("level", validation.getLevel().name());
            this.json.write("ci", validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.json.write("property", validation.getPropertyName());
            }
            this.json.write("message", validation.getMessage());
            this.json.writeEnd();
        }
        this.json.writeEnd();
    }

    @Override
    public void close() throws IOException {
        this.json.close();
    }

    public void externalProperties(Map<String, ExternalProperty> externalProperties) {
        this.json.writeKey("external-properties");
        this.json.writeStartObject();
        for (Map.Entry<String, ExternalProperty> entry : externalProperties.entrySet()) {
            this.json.writeKey(entry.getKey());
            this.json.writeStartObject();
            ExternalProperty externalProperty = entry.getValue();
            if (externalProperty instanceof LookupValueKey) {
                LookupValueKey lookupValueKey = (LookupValueKey)externalProperty;
                this.json.write("kind", "lookup");
                this.json.write("key", lookupValueKey.getKey());
                this.json.write("provider", lookupValueKey.getProviderId());
            }
            this.json.writeEnd();
        }
        this.json.writeEnd();
    }
}

