/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization.json.xltype;

import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;
import com.xebialabs.deployit.plugin.api.udm.lookup.LookupValueKey;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.serialization.json.utils.JsonWithCachedProvider;
import com.xebialabs.xlrelease.serialization.json.xltype.CiListJson2Reader;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.SerializationException;
import com.xebialabs.xltype.serialization.util.DateUtil;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiJson2Reader
implements CiReader {
    private final JsonObject json;
    private final Iterator<String> propertyIterator;
    private String currentPropertyName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CiJson2Reader(JsonObject json) {
        this.json = json;
        this.propertyIterator = CiJson2Reader.properties(json).iterator();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static CiJson2Reader create(String jsonObject) {
        try (StringReader reader = new StringReader(jsonObject);){
            CiJson2Reader ciJson2Reader;
            block13: {
                JsonReader jsonReader = JsonWithCachedProvider.createReader(reader);
                try {
                    ciJson2Reader = new CiJson2Reader(jsonReader.readObject());
                    if (jsonReader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return ciJson2Reader;
        }
        catch (JsonException | IOException e) {
            throw new IllegalArgumentException("Can't parse the following as a JSON object:\n" + jsonObject, e);
        }
    }

    public String getType() {
        try {
            return this.json.getString("type");
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public String getId() {
        try {
            if (this.json.isNull("id")) {
                return null;
            }
            return this.json.getString("id");
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public String getToken() {
        return this.getStringOrNull("$token");
    }

    public CiAttributes getCiAttributes() {
        String createdBy = this.getStringOrNull("$createdBy");
        DateTime createdAt = this.getDateTimeOrNull("$createdAt");
        String lastModifiedBy = this.getStringOrNull("$lastModifiedBy");
        DateTime lastModifiedAt = this.getDateTimeOrNull("$lastModifiedAt");
        String unparsedSCMData = this.getStringOrNull("$scmTraceabilityDataId");
        String scmData = null;
        if (unparsedSCMData != null) {
            scmData = unparsedSCMData;
        }
        return new CiAttributes(createdBy, createdAt, lastModifiedBy, lastModifiedAt, scmData);
    }

    public boolean hasMoreProperties() {
        return this.propertyIterator.hasNext();
    }

    public void moveIntoProperty() {
        this.currentPropertyName = this.propertyIterator.next();
    }

    public CiReader moveIntoNestedProperty() {
        try {
            return new CiJson2Reader(this.json.getJsonObject(this.currentPropertyName));
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void moveOutOfProperty() {
    }

    public String getCurrentPropertyName() {
        return this.currentPropertyName;
    }

    public String getStringValue() {
        try {
            JsonValue jsonValue = (JsonValue)this.json.get((Object)this.currentPropertyName);
            switch (jsonValue.getValueType()) {
                case NULL: {
                    return null;
                }
                case TRUE: {
                    return "true";
                }
                case FALSE: {
                    return "false";
                }
                case NUMBER: {
                    return this.json.getJsonNumber(this.currentPropertyName).toString();
                }
            }
            return this.json.getString(this.currentPropertyName);
        }
        catch (Exception e) {
            this.logger.error(String.format("Incorrect property value type or value for property '%s'", this.currentPropertyName));
            throw new SerializationException((Throwable)e);
        }
    }

    public List<String> getStringValues() {
        try {
            JsonArray strings = this.json.getJsonArray(this.currentPropertyName);
            return CiJson2Reader.toList(strings);
        }
        catch (Exception e) {
            this.logger.error(String.format("[Property '%s'] Incorrect property value type Array or value", this.currentPropertyName));
            throw new SerializationException((Throwable)e);
        }
    }

    public Map<String, String> getStringMap() {
        try {
            JsonObject map = this.json.getJsonObject(this.currentPropertyName);
            return CiJson2Reader.toMap(map);
        }
        catch (Exception e) {
            this.logger.error(String.format("[Property '%s'] Incorrect value type Object or value", this.currentPropertyName));
            throw new SerializationException((Throwable)e);
        }
    }

    public boolean isCiReference() {
        JsonValue propertyValue = (JsonValue)this.json.get((Object)this.currentPropertyName);
        return this.currentPropertyName != null && (propertyValue == null || propertyValue.getValueType() != JsonValue.ValueType.OBJECT);
    }

    public String getCiReference() {
        return this.getStringValue();
    }

    public List<String> getCiReferences() {
        return this.getStringValues();
    }

    public CiListReader getCurrentCiListReader() {
        try {
            return new CiListJson2Reader(this.json.getJsonArray(this.currentPropertyName));
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public List<ValidationMessage> getValidationMessages() {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        try {
            JsonArray array = this.json.getJsonArray("validation-messages");
            for (int i = 0; i < array.size(); ++i) {
                messages.add(CiJson2Reader.toMessage(array.getJsonObject(i)));
            }
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
        return messages;
    }

    public Map<String, ExternalProperty> getExternalProperties() {
        try {
            HashMap<String, ExternalProperty> result = new HashMap<String, ExternalProperty>();
            JsonObject object = this.json.getJsonObject("external-properties");
            for (String key : object.keySet()) {
                JsonObject jsonObject = object.getJsonObject(key);
                String kind = jsonObject.getString("kind");
                if (kind.equals("lookup")) {
                    LookupValueKey lookupValueKey = new LookupValueKey();
                    lookupValueKey.setKey(jsonObject.getString("key"));
                    lookupValueKey.setProviderId(jsonObject.getString("provider"));
                    result.put(key, (ExternalProperty)lookupValueKey);
                    continue;
                }
                throw new IllegalArgumentException("Unknown external property kind: '" + kind + "'.");
            }
            return result;
        }
        catch (JsonException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static Collection<String> properties(JsonObject object) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String key : object.keySet()) {
            if (CiJson2Reader.isSpecialKey(key)) continue;
            properties.add(key);
        }
        return properties;
    }

    private static boolean isSpecialKey(String key) {
        return "id".equals(key) || "type".equals(key) || key != null && key.startsWith("$");
    }

    private static List<String> toList(JsonArray array) {
        ArrayList<String> strings = new ArrayList<String>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            if (array.isNull(i)) continue;
            strings.add(array.getString(i));
        }
        return strings;
    }

    private static Map<String, String> toMap(JsonObject object) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : object.keySet()) {
            map.put(key, String.valueOf(CiJson2Reader.getStringOrNull(object, key)));
        }
        return map;
    }

    private static ValidationMessage toMessage(JsonObject jsonObject) {
        return new ValidationMessage(jsonObject.getString("ci"), CiJson2Reader.getStringOrNull(jsonObject, "property"), jsonObject.getString("message"), CiJson2Reader.getStringOrNull(jsonObject, "level"));
    }

    private String getStringOrNull(String key) {
        return CiJson2Reader.getStringOrNull(this.json, key);
    }

    private static String getStringOrNull(JsonObject json, String key) {
        try {
            if (json.containsKey((Object)key)) {
                if (json.isNull(key)) {
                    return null;
                }
                return json.getString(key);
            }
        }
        catch (JsonException e) {
            throw new SerializationException((Throwable)e);
        }
        return null;
    }

    private DateTime getDateTimeOrNull(String key) {
        String stringOrNull = this.getStringOrNull(key);
        if (stringOrNull == null) {
            return null;
        }
        return DateUtil.fromString((String)stringOrNull);
    }
}

