/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization.json.xltype;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrPasswordEncryptingCiConverter
extends PasswordEncryptingCiConverter {
    private static final Logger logger = LoggerFactory.getLogger(XlrPasswordEncryptingCiConverter.class);
    private final PasswordEncrypter passwordEncrypter;
    private Map<String, ConfigurationItem> folderLessIdToItem = new HashMap<String, ConfigurationItem>();
    private ResolveOptions resolveOptions = ResolveOptions.WITH_DECORATORS();

    public XlrPasswordEncryptingCiConverter(PasswordEncrypter passwordEncrypter) {
        this.passwordEncrypter = passwordEncrypter;
    }

    public XlrPasswordEncryptingCiConverter(PasswordEncrypter passwordEncrypter, List<ConfigurationItem> targetConfigurationItems, ResolveOptions resolveOptions) {
        this.passwordEncrypter = passwordEncrypter;
        this.folderLessIdToItem = (Map)targetConfigurationItems.stream().filter(i -> i.getId() != null).collect(Collectors.toMap(i -> Ids.getFolderlessId((String)i.getId()), Function.identity()));
        this.resolveOptions = resolveOptions;
    }

    protected ConfigurationItem createConfigurationItem(CiReader reader) {
        String folderlessId;
        String id = reader.getId();
        if (id != null && this.folderLessIdToItem.containsKey(folderlessId = Ids.getFolderlessId((String)id))) {
            return this.folderLessIdToItem.get(folderlessId);
        }
        return super.createConfigurationItem(reader);
    }

    protected void readProperty(CiReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        try {
            super.readProperty(reader, descriptor, configurationItem);
        }
        catch (Exception ex) {
            logger.warn("Unable to read property [{}] of type [{}]: {}.", new Object[]{reader.getCurrentPropertyName(), descriptor.getType(), ex.getMessage()});
        }
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.passwordEncrypter.ensureDecrypted(reader.getStringValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    public void resolveReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList<ConfigurationItem> resolvedCIs = new ArrayList<ConfigurationItem>();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead == null && Ids.isInRelease((String)id)) {
                    String folderLessId = Ids.getFolderlessId((String)id);
                    alsoRead = (ConfigurationItem)this.getReadCIs().get(folderLessId);
                }
                if (alsoRead != null) {
                    logger.trace("Resolved reference [{}] for [{}] with an already provided reference", (Object)id, (Object)reference.getCi().getId());
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                if (!this.resolveOptions.shouldResolveReferences()) continue;
                this.resolveFromRepository(repository, reference, resolvedCIs, id);
            }
            reference.set(resolvedCIs);
        }
    }

    private void resolveFromRepository(Repository repository, CiReference reference, List<ConfigurationItem> resolvedCIs, String id) {
        if (repository instanceof ResolverRepository) {
            ConfigurationItem cachedItem = this.folderLessIdToItem.get(id);
            if (null == cachedItem) {
                ResolverRepository resolver = (ResolverRepository)repository;
                ConfigurationItem resolvedItem = resolver.resolve(id, reference);
                if (resolvedItem == null) {
                    logger.warn("Unable to resolve reference [{}] to [{}]", (Object)reference, (Object)id);
                } else {
                    logger.trace("Resolved reference [{}] for [{}]", (Object)id, (Object)reference.getCi().getId());
                    resolvedCIs.add(resolvedItem);
                    this.addFolderLessItem(resolvedItem);
                }
            } else {
                resolvedCIs.add(cachedItem);
            }
        } else {
            throw new IllegalStateException("Unable to resolve reference because repository is not ResolverRepository");
        }
    }

    private void addFolderLessItem(ConfigurationItem resolvedItem) {
        String folderLessId = Ids.getFolderlessId((String)resolvedItem.getId());
        this.folderLessIdToItem.put(folderLessId, resolvedItem);
    }
}

