package com.xebialabs.xlrelease.serialization.json.utils

import java.io.{Reader, Writer}
import jakarta.json.spi.JsonProvider
import jakarta.json.stream.JsonGenerator
import jakarta.json.{JsonObjectBuilder, JsonReader}

/**
 * Factory class with lazily initialized JsonProvider
 * See [[jakarta.json.Json]]
 */
object JsonWithCachedProvider {
  private lazy val provider = JsonProvider.provider()

  def createReader(reader: Reader): JsonReader = provider.createReader(reader)

  def createGenerator(writer: Writer): JsonGenerator = provider.createGenerator(writer)

  def createObjectBuilder(): JsonObjectBuilder = provider.createObjectBuilder()
}
