package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

public class DomainIdDeserializer extends JsonDeserializer<String> implements DomainIdSerialization {
    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        return toInternalId(jsonParser.readValueAs(String.class));
    }
}
