package com.xebialabs.xlrelease.serialization.json.xltype

import com.google.common.base.Strings.isNullOrEmpty
import com.xebialabs.deployit.core.xml.PasswordMaskingCiConverter
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xltype.serialization.CiReader

class XlrPasswordMaskingCiConverter extends PasswordMaskingCiConverter {
  private val passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance

  override protected def readStringProperty(configurationItem: ConfigurationItem, propertyDescriptor: PropertyDescriptor, reader: CiReader): Unit = {
    if (propertyDescriptor.isPassword && isValueEncrypted(reader.getStringValue)) {
      throw new IllegalArgumentException("Could not accept encrypted password")
    } else {
      super.readStringProperty(configurationItem, propertyDescriptor, reader)
    }
  }

  private def isValueEncrypted(value: String): Boolean = !isNullOrEmpty(value) && passwordEncrypter.isEncodedAndDecryptable(value)
}
