package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import static com.xebialabs.xlrelease.repository.IdType.CONFIGURATION;

public class ConfigurationIdSerializer extends JsonSerializer<String> {
    @Override
    public void serialize(String internalId, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeString(CONFIGURATION.convertToViewId(internalId));
    }
}
