package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import java.util.List;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

public class DomainIdsDeserializer extends JsonDeserializer<List<String>> {
    @Override
    public List<String> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        List viewIds = jsonParser.readValueAs(List.class);
        List<String> internalIds = newArrayList();
        for (Object viewId : viewIds) {
            internalIds.add(DOMAIN.convertToInternalId((String) viewId));
        }
        return internalIds;
    }
}
