package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.util.NullPasswordEncrypter;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper;
import com.xebialabs.xlrelease.serialization.json.xltype.XlrPasswordEncryptingCiConverter;

@Component
public class CiDeserializer extends JsonDeserializer<ConfigurationItem> {

    private final RepositoryAdapter repository;

    public CiDeserializer() {
        this.repository = null;
    }

    @Autowired
    public CiDeserializer(final RepositoryAdapter repository) {
        this.repository = repository;
    }

    @Override
    public ConfigurationItem deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        final JsonNode jsonNode = jsonParser.readValueAsTree();
        return jsonNode.isNull() ? null : CiSerializerHelper.deserialize(jsonNode, repository, new XlrPasswordEncryptingCiConverter(NullPasswordEncrypter.getInstance()));
    }
}
