package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import java.util.List;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

public class DomainIdsSerializer extends JsonSerializer<List<String>> {
    @Override
    public void serialize(List<String> internalIds, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeStartArray();
        for (String internalId : internalIds) {
            jsonGenerator.writeString(DOMAIN.convertToViewId(internalId));
        }
        jsonGenerator.writeEndArray();
    }
}
