package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper;

public class CiSerializer extends JsonSerializer<ConfigurationItem> {

    @Override
    public void serialize(ConfigurationItem ci, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        if (ci == null) {
            jsonGenerator.writeNull();
        } else {
            jsonGenerator.writeRawValue(CiSerializerHelper.serialize(ci));
        }
    }
}
