package com.xebialabs.xlrelease.serialization.json.jackson;

import java.io.IOException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import static com.xebialabs.xlrelease.repository.IdType.DOMAIN;

public class DomainIdSerializer extends JsonSerializer<String> {
    @Override
    public void serialize(String internalId, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        jsonGenerator.writeString(DOMAIN.convertToViewId(internalId));
    }
}
