package com.xebialabs.xlrelease.serialization.json.repository

class ResolveOptions private[repository](val dependencies: Boolean, val references: Boolean, val decorators: Boolean) {
  def hasDependencies: Boolean = dependencies
  def hasReferences: Boolean = references
  def hasDecorators: Boolean = decorators
}

object ResolveOptions {
  lazy val MINIMAL: ResolveOptions = new ResolveOptionsBuilder().build
  lazy val EVERYTHING: ResolveOptions = new ResolveOptionsBuilder().withEverything.build
  lazy val DEPENDENCIES: ResolveOptions = new ResolveOptionsBuilder().withDependencies.build
  lazy val REFERENCES: ResolveOptions = new ResolveOptionsBuilder().withReferences.build
  lazy val WITHOUT_DECORATORS: ResolveOptions = new ResolveOptionsBuilder().withoutDecorators.build
}

class ResolveOptionsBuilder {

  private var dependencies = false
  private var references = false
  private var decorators = true

  def withReferences: ResolveOptionsBuilder = {
    references = true
    this
  }

  def withDependencies: ResolveOptionsBuilder = {
    dependencies = true
    this
  }

  def withoutDecorators: ResolveOptionsBuilder = {
    decorators = false
    this
  }

  def withEverything: ResolveOptionsBuilder = {
    this.withReferences.withDependencies
  }

  def build: ResolveOptions = {
    new ResolveOptions(dependencies, references, decorators)
  }
}
