/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.serialization;

import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.ResolvingRepository;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlrPasswordEncryptingCiConverter
extends PasswordEncryptingCiConverter {
    private static final Logger logger = LoggerFactory.getLogger(XlrPasswordEncryptingCiConverter.class);
    private final PasswordEncrypter passwordEncrypter;

    public XlrPasswordEncryptingCiConverter(PasswordEncrypter passwordEncrypter) {
        this.passwordEncrypter = passwordEncrypter;
    }

    protected void readProperty(CiReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        try {
            super.readProperty(reader, descriptor, configurationItem);
        }
        catch (Exception ex) {
            logger.warn("Unable to read property [{}] of type [{}]: {}.", new Object[]{reader.getCurrentPropertyName(), descriptor.getType().toString(), ex.getMessage()});
        }
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
        if (propertyDescriptor.isPassword()) {
            propertyDescriptor.set(configurationItem, (Object)this.passwordEncrypter.ensureDecrypted(reader.getStringValue()));
        } else {
            super.readStringProperty(configurationItem, propertyDescriptor, reader);
        }
    }

    public void resolveReferences(Repository repository) {
        for (CiReference reference : this.getReferences()) {
            ArrayList<Object> resolvedCIs = new ArrayList<Object>();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = (ConfigurationItem)this.getReadCIs().get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                if (reference.getCi() instanceof Dependency && reference.getProperty().getName().equalsIgnoreCase("target") && repository instanceof ResolvingRepository) {
                    ResolvingRepository resolvingRepository = (ResolvingRepository)repository;
                    resolvedCIs.add(resolvingRepository.read(id, new ResolveOptionsBuilder().build()));
                    continue;
                }
                ConfigurationItem resolvedValue = repository.read(id);
                if (resolvedValue == null) continue;
                resolvedCIs.add(resolvedValue);
            }
            reference.set(resolvedCIs);
        }
    }
}

