/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environment.impl.serialization;

import com.xebialabs.xlrelease.environment.impl.serialization.CiJson2Reader;
import com.xebialabs.xlrelease.environment.impl.serialization.JsonWithCachedProvider;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.SerializationException;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CiListJson2Reader
implements CiListReader {
    private final Iterator<JsonObject> iterator;
    private JsonObject currentObject;

    public CiListJson2Reader(JsonArray json) {
        try {
            this.iterator = CiListJson2Reader.toObjectList(json).iterator();
        }
        catch (JsonException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static CiListReader create(String jsonArray) {
        try (StringReader reader = new StringReader(jsonArray);){
            CiListJson2Reader ciListJson2Reader;
            block13: {
                JsonReader jsonReader = JsonWithCachedProvider.createReader(reader);
                try {
                    ciListJson2Reader = new CiListJson2Reader(jsonReader.readArray());
                    if (jsonReader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonReader.close();
            }
            return ciListJson2Reader;
        }
        catch (JsonException | IOException e) {
            throw new IllegalArgumentException("Can't parse the following as a JSON array:\n" + jsonArray, e);
        }
    }

    public boolean hasMoreChildren() {
        return this.iterator.hasNext();
    }

    public void moveIntoChild() {
        this.currentObject = this.iterator.next();
    }

    public void moveOutOfChild() {
    }

    public CiReader getCurrentCiReader() {
        CiJson2Reader currentReader = new CiJson2Reader(this.currentObject);
        if (this.currentObject.containsKey((Object)"ci-ref")) {
            currentReader.moveIntoProperty();
        }
        return currentReader;
    }

    private static List<JsonObject> toObjectList(JsonArray array) {
        ArrayList<JsonObject> objects = new ArrayList<JsonObject>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JsonValue jsonValue = (JsonValue)array.get(i);
            JsonObject jsonObject = null;
            if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
                jsonObject = array.getJsonObject(i);
            }
            if (jsonObject == null) {
                jsonObject = JsonWithCachedProvider.createObjectBuilder().add("ci-ref", (JsonValue)array.getJsonString(i)).build();
            }
            objects.add(jsonObject);
        }
        return objects;
    }
}

