/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.service.CommentServiceHelper;
import java.util.Date;

public class CommentBuilder {
    private String id;
    private String text;
    private String author;
    private Date date;
    private Date creationDate;
    private int maxCommentSize = -1;

    private CommentBuilder() {
    }

    public static CommentBuilder newComment() {
        return new CommentBuilder();
    }

    public CommentBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public CommentBuilder withText(String text) {
        this.text = text;
        return this;
    }

    public CommentBuilder withAuthor(String author) {
        this.author = author;
        return this;
    }

    public CommentBuilder withDate(Date date) {
        this.date = date;
        return this;
    }

    public CommentBuilder withCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public CommentBuilder withLimit(int maxCommentSize) {
        this.maxCommentSize = maxCommentSize;
        return this;
    }

    public Comment build() {
        Comment comment = (Comment)new Comment().getType().getDescriptor().newInstance(this.id);
        if (null != this.text) {
            if (this.maxCommentSize >= 0) {
                CommentServiceHelper.appendCommentText(comment, this.text, this.maxCommentSize, "", "");
            }
            comment.setText(this.text);
        }
        comment.setAuthor(this.author);
        comment.setDate(this.date);
        comment.setCreationDate(this.creationDate);
        return comment;
    }
}

