/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables.reference;

import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class VariableReference
implements Comparable<VariableReference> {
    private String key;
    private VariableUsageType type;
    private Set<UsagePoint> usagePoints = new HashSet<UsagePoint>();

    public VariableReference(String key, VariableUsageType variableType) {
        this.key = key;
        this.type = variableType;
    }

    public String getKey() {
        return this.key;
    }

    public VariableUsageType getType() {
        return this.type;
    }

    public void setType(VariableUsageType type) {
        this.type = type;
    }

    public Set<UsagePoint> getUsagePoints() {
        return this.usagePoints;
    }

    public void addUsagePoint(UsagePoint usagePoint, VariableUsageType usagePointType) {
        if (usagePointType.hasHigherPriorityThan(this.getType())) {
            this.setType(usagePointType);
        }
        this.usagePoints.add(usagePoint);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VariableReference)) {
            return false;
        }
        VariableReference that = (VariableReference)other;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(VariableReference that) {
        if (null == that) {
            return 1;
        }
        return this.key.compareTo(that.key);
    }

    public static enum VariableUsageType {
        DEFAULT(0),
        CI_PROPERTY(-1),
        GLOBAL(-1),
        FOLDER(-1),
        SCRIPT_RESULT(2),
        PASSWORD(3);

        private int priority;

        private VariableUsageType(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean hasHigherPriorityThan(VariableUsageType variableType) {
            return this.getPriority() > variableType.getPriority();
        }
    }
}

