/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Lockable;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.PhaseRecoverOp;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UserInputTaskUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.VariableCollectingVisitor;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.events.TaskAbortOperation;
import com.xebialabs.xlrelease.events.TaskCompleteOperation;
import com.xebialabs.xlrelease.events.TaskDelayOperation;
import com.xebialabs.xlrelease.events.TaskEndRecoveryOperation;
import com.xebialabs.xlrelease.events.TaskFailOperation;
import com.xebialabs.xlrelease.events.TaskReopenOperation;
import com.xebialabs.xlrelease.events.TaskRetryOperation;
import com.xebialabs.xlrelease.events.TaskSkipOperation;
import com.xebialabs.xlrelease.events.TaskStartOperation;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.events.TaskStartRecoveryOperation;
import com.xebialabs.xlrelease.events.TaskWaitingForInputOperation;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.service.ExecuteFailureHandlerAction;
import com.xebialabs.xlrelease.service.ExecutePreconditionAction;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Metadata(label="Manual", versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class Task
extends PlanItem
implements Lockable {
    public static final String CATEGORY_INPUT = "input";
    public static final String CATEGORY_OUTPUT = "output";
    public static final double DUE_SOON_THRESHOLD = 0.75;
    @Property(asContainment=true, required=false, description="The comments on the task.")
    private List<Comment> comments = new ArrayList<Comment>();
    @Property(asContainment=true, description="The phase or task this task is contained in.")
    private TaskContainer container;
    @Property(asContainment=true, required=false, description="Facets applied to the task.")
    private List<Facet> facets = new ArrayList<Facet>();
    @Property(required=false, description="List of file attachments on this task.")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    @Property(description="The state the task is in.")
    protected TaskStatus status;
    @Property(required=false, description="The name of the team this task is assigned to.")
    protected String team;
    @Property(required=false, defaultValue="true", description="The task is not started until the scheduledStartDate is reached if set to true.")
    protected boolean waitForScheduledStartDate;
    @Property(required=false, defaultValue="false", description="The task is to be delayed when a blackout period is active.")
    protected boolean delayDuringBlackout;
    @Property(required=false, category="internal", defaultValue="false", description="The task is postponed by a blackout period")
    protected boolean postponedDueToBlackout;
    @Property(required=false, category="internal", description="The original scheduled start date.")
    protected Date originalScheduledStartDate;
    @Property(required=false, category="internal")
    protected boolean hasBeenFlagged = false;
    @Property(required=false, category="internal")
    protected boolean hasBeenDelayed = false;
    @Property(required=false, description="A snippet of code that is evaluated when the task is started.")
    protected String precondition;
    @Property(required=false, description="A snippet of code that is evaluated when the task is failed.")
    protected String failureHandler;
    @Property(required=false, defaultValue="false", description="The failed script will be executed.")
    protected boolean taskFailureHandlerEnabled = false;
    @Property(required=false, description="Task recovery operation performed after task failure.")
    protected TaskRecoverOp taskRecoverOp;
    @Property(required=false, description="Phase recovery operation performed after task recovery.")
    protected PhaseRecoverOp phaseRecoverOp;
    @Property(description="The number of times this task has failed.")
    protected int failuresCount = 0;
    @Property(required=false, category="internal")
    protected String executionId;
    @Property(asContainment=true, required=false, description="Map from property name to a variable name that replaces that property")
    protected Map<String, String> variableMapping = new HashMap<String, String>();
    @Property(hidden=true, category="internal", description="Maximum size of a comment on a task. Default value is 32768.", defaultValue="32768")
    protected int maxCommentSize;
    @Property(required=false, description="The tags of the task. Tags can be used for grouping and querying.")
    protected List<String> tags;
    @Property(required=false, hidden=true, description="URI of the HTML file to render the task")
    private String configurationUri;
    @Property(required=false, category="internal")
    private boolean dueSoonNotified;
    @Property(required=false, defaultValue="false", description="The task is locked")
    private boolean locked = false;
    private static final Logger logger = LoggerFactory.getLogger(Task.class);
    public static final Predicate<Task> IS_AUTOMATED_AND_IN_PROGRESS = task -> task.isAutomated() && task.isInProgress();

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    @PublicApiMember
    public List<Comment> getComments() {
        return this.comments;
    }

    @PublicApiMember
    public TaskContainer getContainer() {
        return this.container;
    }

    public void setContainer(TaskContainer container) {
        this.container = container;
    }

    @PublicApiMember
    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public String getTeam() {
        return this.team;
    }

    public boolean hasTeam() {
        return this.team != null;
    }

    @PublicApiMember
    public void setTeam(String team) {
        this.team = team;
    }

    @PublicApiMember
    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    @PublicApiMember
    public String getPrecondition() {
        return this.precondition;
    }

    @PublicApiMember
    public String getFailureHandler() {
        return this.failureHandler;
    }

    @PublicApiMember
    public void setFailureHandler(String failureHandler) {
        this.failureHandler = failureHandler;
    }

    @PublicApiMember
    public boolean isTaskFailureHandlerEnabled() {
        return this.taskFailureHandlerEnabled;
    }

    @PublicApiMember
    public void setTaskFailureHandlerEnabled(boolean taskFailureHandlerEnabled) {
        this.taskFailureHandlerEnabled = taskFailureHandlerEnabled;
    }

    @PublicApiMember
    public TaskRecoverOp getTaskRecoverOp() {
        return this.taskRecoverOp;
    }

    @PublicApiMember
    public void setTaskRecoverOp(TaskRecoverOp taskRecoverOp) {
        this.taskRecoverOp = taskRecoverOp;
    }

    @PublicApiMember
    public PhaseRecoverOp getPhaseRecoverOp() {
        return this.phaseRecoverOp;
    }

    @PublicApiMember
    public void setPhaseRecoverOp(PhaseRecoverOp phaseRecoverOp) {
        if (this.taskRecoverOp != null && phaseRecoverOp != null && (this.taskRecoverOp == TaskRecoverOp.SKIP_TASK && phaseRecoverOp != PhaseRecoverOp.RESTART_ORIGINAL && phaseRecoverOp != PhaseRecoverOp.RESTART_LATEST || this.taskRecoverOp != TaskRecoverOp.SKIP_TASK)) {
            this.phaseRecoverOp = phaseRecoverOp;
        }
    }

    @PublicApiMember
    public List<String> getTags() {
        return this.tags;
    }

    @PublicApiMember
    public void setTags(List<String> tags) {
        this.tags = tags != null ? tags.stream().distinct().collect(Collectors.toList()) : Collections.emptyList();
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = new HashMap<String, String>(variableMapping);
    }

    public Map<String, String> getVariableMapping() {
        return this.variableMapping;
    }

    public boolean hasVariableMapping() {
        return this.variableMapping != null && !this.variableMapping.isEmpty();
    }

    public void setMaxCommentSize(int maxCommentSize) {
        this.maxCommentSize = maxCommentSize;
    }

    public int getMaxCommentSize() {
        return this.maxCommentSize;
    }

    public static boolean isDefaultTaskType(Type type) {
        return "xlrelease".equals(type.getPrefix());
    }

    public static <T extends Task> T fromType(String taskType) {
        return Task.fromType(Type.valueOf((String)taskType));
    }

    public static <T extends Task> T fromType(Type taskType) {
        Task task;
        if (Task.isDefaultTaskType(taskType)) {
            task = (Task)taskType.getDescriptor().newInstance(null);
        } else if (PythonScriptDefinition.isScriptDefinition(taskType)) {
            PythonScript pythonScript = (PythonScript)taskType.getDescriptor().newInstance(null);
            CustomScriptTask scriptTask = (CustomScriptTask)Type.valueOf(CustomScriptTask.class).getDescriptor().newInstance(null);
            scriptTask.setPythonScript(pythonScript);
            pythonScript.setCustomScriptTask(scriptTask);
            task = scriptTask;
        } else {
            throw new IllegalArgumentException(String.format("Can only create tasks from default task types or subtypes of %s", Type.valueOf(PythonScript.class)));
        }
        task.applyDefaults();
        return (T)task;
    }

    protected void applyDefaults() {
    }

    public Phase getPhase() {
        if (this.container instanceof Task) {
            return ((Task)((Object)this.container)).getPhase();
        }
        if (this.container instanceof Phase) {
            return (Phase)this.container;
        }
        if (this.container == null) {
            return null;
        }
        throw new IllegalStateException("Unexpected type for container: " + this.container.getClass().getName());
    }

    public Changes start() {
        if (this.isCompletedInAdvance()) {
            return this.markAsDone(this.getId(), TaskStatus.COMPLETED);
        }
        if (this.isSkippedInAdvance()) {
            return this.markAsDone(this.getId(), TaskStatus.SKIPPED);
        }
        if (this.canStartNow()) {
            return this.startNow(this.getId(), false);
        }
        return this.delayStartup();
    }

    public boolean canStartNow() {
        return this.getScheduledStartDate() == null || !this.isWaitForScheduledStartDate() && !this.isDelayDuringBlackout() || new Date().after(this.getScheduledStartDate());
    }

    public Changes startPending(String targetId) {
        return this.startNow(targetId, true);
    }

    public Changes startWithInput() {
        Preconditions.checkState((boolean)this.isWaitingForInput(), (String)"Task '%s' can only be started manually when it is waiting for input. It is now %s.", (Object[])new Object[]{this.getTitle(), this.getStatus()});
        return this.execute(this.getId(), new TaskStartOperation(this));
    }

    public Changes retry(String targetId) {
        Preconditions.checkState((!this.getId().equals(targetId) || this.isFailed() || this.isFailureHandlerInProgress() ? 1 : 0) != 0, (String)"Task '%s' can only be retried when it is failed or handling failure. It is now %s.", (Object[])new Object[]{this.getTitle(), this.getStatus()});
        this.postponedDueToBlackout = false;
        return this.execute(targetId, new TaskRetryOperation(this));
    }

    @Override
    public void setScheduledStartDate(Date scheduledStartDate) {
        if (this.getScheduledStartDate() != null && !this.getScheduledStartDate().equals(scheduledStartDate) || this.getScheduledStartDate() == null && scheduledStartDate != null) {
            this.postponedDueToBlackout = false;
            this.originalScheduledStartDate = null;
        }
        super.setScheduledStartDate(scheduledStartDate);
    }

    protected Changes startNow(String targetId, boolean shouldBePending) {
        Preconditions.checkState((!shouldBePending || this.isPending() ? 1 : 0) != 0, (String)"Task '%s' can only be started manually when it is pending. It is now %s.", (Object[])new Object[]{this.getTitle(), this.getStatus()});
        return this.execute(targetId, new TaskStartOperation(this));
    }

    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        if (this.mustDelayDueToBlackout()) {
            return this.delayUntilBlackoutEnd();
        }
        List<String> unboundVariables = this.getUnboundRequiredVariables();
        if (!unboundVariables.isEmpty()) {
            return this.askForInput(unboundVariables);
        }
        if (this.shouldPreconditionBeChecked()) {
            return this.executePrecondition();
        }
        return this.executeTask(targetId, operation);
    }

    private Changes askForInput(List<String> unboundVariables) {
        Changes changes = new Changes();
        this.backupTaskIfNecessary(changes);
        this.status = TaskStatus.WAITING_FOR_INPUT;
        changes.update((ConfigurationItem)this);
        changes.addOperation(new TaskWaitingForInputOperation(this, unboundVariables));
        return changes;
    }

    private Changes executePrecondition() {
        Changes changes = new Changes();
        this.backupTaskIfNecessary(changes);
        this.status = TaskStatus.PRECONDITION_IN_PROGRESS;
        this.generateExecutionId();
        changes.update((ConfigurationItem)this);
        this.freezeVariablesOrFailTask(changes);
        if (this.isPreconditionInProgress()) {
            changes.addPostAction(new ExecutePreconditionAction(this));
        }
        return changes;
    }

    private Changes executeTask(String targetId, TaskStartOrRetryOperation operation) {
        Changes changes = new Changes();
        this.checkOwnId(targetId);
        this.backupTaskIfNecessary(changes);
        this.status = TaskStatus.IN_PROGRESS;
        if (!this.hasStartDate()) {
            this.setStartDate(new Date());
        }
        changes.addOperation(operation);
        this.freezeVariablesOrFailTask(changes);
        return changes;
    }

    private void freezeVariablesOrFailTask(Changes changes) {
        Set<String> unresolvedVariables = this.freezeVariables(changes, false);
        if (!unresolvedVariables.isEmpty()) {
            String variableNames = unresolvedVariables.stream().collect(Collectors.joining(", "));
            changes.addAll(this.fail(this.getId(), FailureReasons.UNRESOLVED_VARIABLES.format(variableNames)));
        }
    }

    private void backupTaskIfNecessary(Changes changes) {
        if (this.getPhase().equals(this.getContainer()) && this.status == TaskStatus.PLANNED) {
            changes.addTaskToBackup(this);
        }
    }

    private boolean shouldPreconditionBeChecked() {
        return this.isPreconditionEnabled() && this.hasPrecondition() && !this.isPreconditionInProgress();
    }

    private boolean mustDelayDueToBlackout() {
        BlackoutMetadata metadata = this.getBlackoutMetadata();
        return this.isDelayDuringBlackout() && !this.isPreconditionInProgress() && metadata != null && metadata.isInBlackout(new Date());
    }

    private Changes delayUntilBlackoutEnd() {
        Changes changes = new Changes();
        if (!this.isPostponedDueToBlackout() && this.getScheduledStartDate() != null) {
            this.setOriginalScheduledStartDate(this.scheduledStartDate);
        }
        this.setPostponedDueToBlackout(true);
        this.scheduledStartDate = this.getBlackoutMetadata().getEndOfBlackout(new Date());
        this.waitForScheduledStartDate = true;
        changes.addAll(this.delayStartup());
        return changes;
    }

    private Changes delayStartup() {
        Changes changes = new Changes();
        this.backupTaskIfNecessary(changes);
        this.status = TaskStatus.PENDING;
        changes.update((ConfigurationItem)this);
        changes.addOperation(new TaskDelayOperation(this));
        return changes;
    }

    private BlackoutMetadata getBlackoutMetadata() {
        return (BlackoutMetadata)this.getRelease().get$metadata().get(BlackoutMetadata.BLACKOUT());
    }

    public Changes markAsDone(String targetId, TaskStatus status) {
        this.checkOwnId(targetId);
        Preconditions.checkArgument((boolean)status.isOneOf(TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.COMPLETED_IN_ADVANCE, TaskStatus.SKIPPED_IN_ADVANCE), (String)"Status is %s but must be either COMPLETED, SKIPPED, COMPLETE_IN_ADVANCE or SKIPPED_IN_ADVANCE", (Object[])new Object[]{status});
        Changes changes = new Changes();
        boolean endRecovery = this.isFailureHandlerInProgress() && status == TaskStatus.SKIPPED;
        logger.debug("markAsDone(" + this.title + "): " + (Object)((Object)this.status) + " -> " + (Object)((Object)status));
        this.setStatus(status);
        this.setStartAndEndDatesIfEmpty();
        if (this.isOverdue()) {
            this.hasBeenDelayed = true;
        }
        if (status == TaskStatus.COMPLETED) {
            this.freezeVariables(changes, true);
            this.resetFlag();
            changes.update((ConfigurationItem)this);
            changes.addOperation(new TaskCompleteOperation(this, false));
        } else if (status == TaskStatus.SKIPPED) {
            this.freezeVariables(changes, true);
            this.resetFlag();
            changes.update((ConfigurationItem)this);
            changes.addOperation(new TaskSkipOperation(this, false));
        } else if (status == TaskStatus.COMPLETED_IN_ADVANCE) {
            this.setStartDate(this.getEndDate());
            changes.update((ConfigurationItem)this);
            changes.addOperation(new TaskCompleteOperation(this, true));
        } else if (status == TaskStatus.SKIPPED_IN_ADVANCE) {
            this.setStartDate(this.getEndDate());
            changes.update((ConfigurationItem)this);
            changes.addOperation(new TaskSkipOperation(this, true));
        }
        if (endRecovery) {
            changes.addOperation(new TaskEndRecoveryOperation(this));
        }
        return changes;
    }

    public Changes fail(String targetId, String failReason) {
        return this.fail(targetId, failReason, User.AUTHENTICATED_USER);
    }

    public Changes fail(String targetId, String failReason, User user) {
        this.checkOwnId(targetId);
        Changes changes = new Changes();
        if (this.isFailing() || this.isFailed()) {
            return changes;
        }
        changes.update((ConfigurationItem)this);
        changes.addComment(this, user, failReason);
        changes.addOperation(new TaskFailOperation(this, failReason));
        if (this.isTaskFailureHandlerEnabled() && this.isFailureHandlerEnabled() && !this.isFailureHandlerInProgress() && !this.isDefunct()) {
            if (this.hasFailureHandlerScript() && TaskRecoverOp.RUN_SCRIPT == this.taskRecoverOp && this.getRelease().getScriptUsername() == null) {
                changes.addComment(this, User.SYSTEM, "Failure handler script could not run because no scriptUser is defined on Release level.");
                this.setStatus(TaskStatus.FAILED);
                return changes;
            }
            ++this.failuresCount;
            this.setStatus(TaskStatus.FAILURE_HANDLER_IN_PROGRESS);
            this.generateExecutionId();
            changes.addOperation(new TaskStartRecoveryOperation(this));
            changes.addPostAction(new ExecuteFailureHandlerAction(this));
        } else if (!this.isDefunct()) {
            boolean endRecovery = this.isFailureHandlerInProgress();
            ++this.failuresCount;
            this.setStatus(TaskStatus.FAILED);
            if (endRecovery) {
                changes.addOperation(new TaskEndRecoveryOperation(this));
            }
        }
        return changes;
    }

    public Changes reopen() {
        this.setStatus(TaskStatus.PLANNED);
        this.setEndDate(null);
        this.setStartDate(null);
        Changes changes = new Changes();
        changes.update((ConfigurationItem)this);
        changes.addOperation(new TaskReopenOperation(this));
        return changes;
    }

    private void checkOwnId(String targetId) {
        Preconditions.checkArgument((boolean)this.getId().equals(targetId), (String)"Attempt to access subtask '%s' of leaf task '%s'", (Object[])new Object[]{targetId, this.getId()});
    }

    public Changes abort() {
        Changes changes = new Changes();
        if (!this.isDone()) {
            this.setStatus(TaskStatus.ABORTED);
            if (!this.hasStartDate()) {
                this.setStartDate(new Date());
            }
            this.setEndDate(new Date());
            changes.addOperation(new TaskAbortOperation(this));
            changes.update((ConfigurationItem)this);
        }
        return changes;
    }

    @Override
    public boolean hasBeenStarted() {
        return this.status != null && this.status.hasBeenStarted();
    }

    @PublicApiMember
    public boolean hasBeenFlagged() {
        return this.hasBeenFlagged;
    }

    public int getFlaggedCount() {
        return this.hasBeenFlagged() ? 1 : 0;
    }

    public int getDelayedCount() {
        return this.hasBeenDelayed() ? 1 : 0;
    }

    @PublicApiMember
    public boolean hasBeenDelayed() {
        return this.hasBeenDelayed;
    }

    @PublicApiMember
    public int getFailuresCount() {
        return this.failuresCount;
    }

    public void setHasBeenFlagged(boolean hasBeenFlagged) {
        this.hasBeenFlagged = hasBeenFlagged;
    }

    public void setHasBeenDelayed(boolean hasBeenDelayed) {
        this.hasBeenDelayed = hasBeenDelayed;
    }

    public void setFailuresCount(int failuresCount) {
        this.failuresCount = failuresCount;
    }

    @Override
    public boolean isDone() {
        return this.status != null && this.status.isDone();
    }

    public boolean isDoneInAdvance() {
        return this.status != null && this.status.isDoneInAdvance();
    }

    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct() && !this.isDoneInAdvance();
    }

    @Override
    public boolean isAborted() {
        return this.status == TaskStatus.ABORTED;
    }

    public boolean isNotYetReached() {
        return this.isPlanned() || this.isDoneInAdvance();
    }

    public boolean isPlanned() {
        return this.status != null && this.status == TaskStatus.PLANNED;
    }

    @Override
    public boolean isActive() {
        return this.status != null && this.status.isActive();
    }

    public boolean isInProgress() {
        return this.status == TaskStatus.IN_PROGRESS;
    }

    public boolean isPending() {
        return this.status == TaskStatus.PENDING;
    }

    public boolean isWaitingForInput() {
        return this.status == TaskStatus.WAITING_FOR_INPUT;
    }

    public boolean isFailed() {
        return this.status == TaskStatus.FAILED;
    }

    public boolean isFailing() {
        return this.status == TaskStatus.FAILING;
    }

    public boolean isCompletedInAdvance() {
        return this.status == TaskStatus.COMPLETED_IN_ADVANCE;
    }

    public boolean isSkipped() {
        return this.status == TaskStatus.SKIPPED;
    }

    public boolean isSkippedInAdvance() {
        return this.status == TaskStatus.SKIPPED_IN_ADVANCE;
    }

    public boolean isPreconditionInProgress() {
        return this.status == TaskStatus.PRECONDITION_IN_PROGRESS;
    }

    public boolean isFailureHandlerInProgress() {
        return this.status == TaskStatus.FAILURE_HANDLER_IN_PROGRESS;
    }

    private boolean hasPrecondition() {
        return !StringUtils.isEmpty((Object)this.precondition);
    }

    protected boolean hasFailureHandlerScript() {
        return this.taskFailureHandlerEnabled && !Strings.isBlank((String)this.failureHandler);
    }

    protected boolean hasPhaseRecoverOp() {
        return this.phaseRecoverOp != null;
    }

    protected boolean hasTaskRecoverOp() {
        return this.taskRecoverOp != null;
    }

    public boolean isMovable() {
        return this.isPlanned() || this.isDoneInAdvance();
    }

    public boolean isAssignedTo(Team team) {
        return team.getTeamName().equals(this.getTeam());
    }

    public boolean isGate() {
        return this instanceof GateTask;
    }

    public boolean isTaskGroup() {
        return this instanceof TaskGroup;
    }

    public boolean isParallelGroup() {
        return this instanceof ParallelGroup;
    }

    @PublicApiMember
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean isPreconditionEnabled() {
        return (Boolean)this.getProperty("preconditionEnabled");
    }

    public boolean isFailureHandlerEnabled() {
        return (Boolean)this.getProperty("failureHandlerEnabled");
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void generateExecutionId() {
        this.setExecutionId(UUID.randomUUID().toString());
    }

    public void deleteAttachment(String attachmentId) {
        CiHelper.removeCisWithId(this.attachments, attachmentId);
    }

    public Changes resetToPlanned() {
        Changes changes = new Changes();
        this.setStatus(TaskStatus.PLANNED);
        this.setStartDate(null);
        this.setEndDate(null);
        this.setOverdueNotified(false);
        this.setDueSoonNotified(false);
        this.setFailuresCount(0);
        this.setHasBeenFlagged(false);
        this.setHasBeenDelayed(false);
        changes.update((ConfigurationItem)this);
        for (Comment comment : this.comments) {
            changes.remove(comment.getId());
        }
        this.comments.clear();
        return changes;
    }

    @Override
    public void setFlagStatus(FlagStatus flagStatus) {
        super.setFlagStatus(flagStatus);
        Release release = this.getRelease();
        if (release != null) {
            release.updateRealFlagStatus();
        }
        if (flagStatus != FlagStatus.OK) {
            this.hasBeenFlagged = true;
        }
    }

    @Override
    public Release getRelease() {
        return this.getPhase() != null ? this.getPhase().getRelease() : null;
    }

    @Override
    public String getDisplayPath() {
        return this.getPhase().getDisplayPath() + " / " + this.getTitle();
    }

    public String getReleaseOwner() {
        return this.getPhase().getReleaseOwner();
    }

    public List<Task> getAllTasks() {
        return Collections.singletonList(this);
    }

    @Override
    public List<PlanItem> getChildren() {
        return new ArrayList<PlanItem>();
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        this.facets.forEach(facet -> facet.accept(visitor));
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        return Arrays.asList(new PropertyUsagePoint((ConfigurationItem)this, "title"), new PropertyUsagePoint((ConfigurationItem)this, "description"), new PropertyUsagePoint((ConfigurationItem)this, "owner"), new PropertyUsagePoint((ConfigurationItem)this, "precondition"));
    }

    public Set<String> freezeVariables(Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet<String> unresolvedVariables = new HashSet<String>();
        Release release = this.getPhase().getRelease();
        Map<String, String> variables = release.getAllStringVariableValues();
        Map<String, String> passwordVariables = release.getPasswordVariableValues();
        changes.update((ConfigurationItem)this);
        this.setTitle(VariableHelper.replaceAll(this.getTitle(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setDescription(VariableHelper.replaceAll(this.getDescription(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setOwner(VariableHelper.replaceAll(this.getOwner(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        if (this.isPreconditionEnabled()) {
            this.setPrecondition(VariableHelper.replaceAll(this.precondition, variables, unresolvedVariables, freezeEvenIfUnresolved));
        }
        unresolvedVariables.addAll(this.freezeInputVariableMapping(changes));
        unresolvedVariables.addAll(this.freezeVariablesInCustomFields(variables, passwordVariables, changes, freezeEvenIfUnresolved));
        this.facets.forEach(facet -> {
            unresolvedVariables.addAll(facet.freezeVariables(variables, changes, freezeEvenIfUnresolved));
            unresolvedVariables.addAll(this.freezeInputVariableMapping(changes, facet.getVariableMapping(), (ConfigurationItem)facet));
        });
        return unresolvedVariables;
    }

    private Set<String> freezeInputVariableMapping(Changes changes) {
        return this.freezeInputVariableMapping(changes, this.variableMapping, (ConfigurationItem)this);
    }

    private Set<String> freezeInputVariableMapping(Changes changes, Map<String, String> variableMapping, ConfigurationItem rootCi) {
        HashSet<String> unresolvedVariables = new HashSet<String>();
        Iterator<String> iterator = variableMapping.keySet().iterator();
        while (iterator.hasNext()) {
            CiProperty ciProperty;
            String fqPropertyName = iterator.next();
            Optional<CiProperty> ciPropertyOptional = CiProperty.of(rootCi, fqPropertyName);
            if (!ciPropertyOptional.isPresent() || !this.shouldFreezeVariableMapping(ciProperty = ciPropertyOptional.get())) continue;
            Optional<Object> variableValue = this.resolveVariable(variableMapping.get(fqPropertyName));
            if (variableValue.isPresent()) {
                ciProperty.setValue(variableValue.get());
                changes.update(ciProperty.getParentCi());
            } else {
                unresolvedVariables.add(variableMapping.get(fqPropertyName));
            }
            iterator.remove();
        }
        return unresolvedVariables;
    }

    protected boolean shouldFreezeVariableMapping(CiProperty property) {
        return true;
    }

    private Optional<Object> resolveVariable(String variable) {
        Release release = this.getPhase().getRelease();
        String variableKey = VariableHelper.withoutVariableSyntax(variable);
        if (variableKey == null) {
            logger.debug("variableKey is null for variable {}", (Object)variable);
        }
        if (release.getGlobalVariables() == null) {
            logger.debug("Release global variables is null");
        }
        return Stream.of(() -> Optional.ofNullable(release.getVariablesByKeys().get(variableKey)).map(Variable::getValue), () -> Optional.ofNullable(release.getGlobalVariables()).map(gv -> gv.getVariablesByKeys().get(variableKey)).map(Variable::getValue)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public List<Variable> getInputVariables() {
        return this.getReferencedVariables(input -> {
            boolean isNotOutputVariable = input.getType() != VariableReference.VariableUsageType.SCRIPT_RESULT;
            boolean isUsedOutsideUserInputTask = input.getUsagePoints().stream().anyMatch(usagePoint -> !(usagePoint instanceof UserInputTaskUsagePoint));
            return isUsedOutsideUserInputTask && isNotOutputVariable;
        });
    }

    public List<Variable> getReferencedVariables() {
        return this.getReferencedVariables(x -> true);
    }

    private List<Variable> getReferencedVariables(Predicate<VariableReference> filter) {
        Set<String> keys = this.getReferencedVariableKeys(filter);
        List<Variable> releaseVariables = this.getRelease().getVariables();
        return releaseVariables.stream().filter(input -> keys.contains(input.getKey())).collect(Collectors.toList());
    }

    private Set<String> getReferencedVariableKeys(Predicate<VariableReference> filter) {
        return this.collectVariableReferences().stream().filter(filter).map(input -> VariableHelper.withoutVariableSyntax(input.getKey())).collect(Collectors.toSet());
    }

    protected List<String> getUnboundRequiredVariables() {
        ArrayList<String> unbound = new ArrayList<String>();
        this.getInputVariables().forEach(v -> {
            if (v.getRequiresValue() && v.isValueEmpty()) {
                unbound.add(VariableHelper.withVariableSyntax(v.getKey()));
            }
        });
        return unbound;
    }

    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        return Collections.emptySet();
    }

    public boolean isWaitForScheduledStartDate() {
        return this.waitForScheduledStartDate;
    }

    public void setWaitForScheduledStartDate(boolean waitForScheduledStartDate) {
        this.waitForScheduledStartDate = waitForScheduledStartDate;
    }

    public boolean isDelayDuringBlackout() {
        return this.delayDuringBlackout;
    }

    public void setDelayDuringBlackout(boolean delayDuringBlackout) {
        if (!delayDuringBlackout) {
            this.postponedDueToBlackout = false;
        }
        this.delayDuringBlackout = delayDuringBlackout;
    }

    private void resetFlag() {
        this.setFlagStatus(FlagStatus.OK);
        this.setFlagComment("");
    }

    public void checkDatesValidity() {
        this.checkDatesValidity(this.scheduledStartDate, this.dueDate, this.plannedDuration);
    }

    public boolean isAutomated() {
        return (Boolean)this.getProperty("automated");
    }

    public boolean ownerHasBeenReassigned(Task task) {
        return !Objects.equals(this.getOwner(), task.getOwner());
    }

    public boolean teamHasBeenReassigned(Task task) {
        return !Objects.equals(this.getTeam(), task.getTeam());
    }

    public boolean delayDuringBlackoutHasChanged(Task task) {
        return this.isDelayDuringBlackout() != task.isDelayDuringBlackout();
    }

    public boolean failureHandlerHasChanged(Task task) {
        return this.getTaskRecoverOp() != task.getTaskRecoverOp() || !Objects.equals(this.getFailureHandler(), task.getFailureHandler());
    }

    public boolean preconditionHasChanged(Task task) {
        return !Objects.equals(this.getPrecondition(), task.getPrecondition());
    }

    public Type getTaskType() {
        return this instanceof CustomScriptTask ? ((CustomScriptTask)this).getPythonScript().getType() : this.type;
    }

    public boolean isStillExecutingScript(String executionId) {
        return (this.isInProgress() || this.isPreconditionInProgress() || this.isFailureHandlerInProgress()) && Objects.equals(this.executionId, executionId);
    }

    private Set<VariableReference> collectVariableReferences() {
        return VariableCollectingVisitor.collectFrom(this);
    }

    public boolean resumeOnRecovery() {
        return false;
    }

    public boolean failOnRecovery() {
        return this.isAutomated() && this.isInProgress() || this.isPreconditionInProgress();
    }

    public boolean isPostponedDueToBlackout() {
        return this.postponedDueToBlackout;
    }

    public void setPostponedDueToBlackout(boolean delay) {
        this.postponedDueToBlackout = delay;
    }

    public Date getOriginalScheduledStartDate() {
        return this.originalScheduledStartDate;
    }

    public void setOriginalScheduledStartDate(Date originalDate) {
        this.originalScheduledStartDate = originalDate;
    }

    public boolean isDueSoon() {
        double elapsedDurationFraction = this.getElapsedDurationFraction();
        return !this.isOverdue() && elapsedDurationFraction >= 0.75;
    }

    public double getElapsedDurationFraction() {
        Date startDate = this.getStartOrScheduledDate();
        if (startDate == null) {
            return 0.0;
        }
        Date now = new Date(DateTimeUtils.currentTimeMillis());
        return this.getOrCalculateDueDate().map(dueDate -> this.getElapsedDurationFraction(startDate, now, (Date)dueDate)).orElse(0.0);
    }

    private Double getElapsedDurationFraction(Date startDate, Date now, Date dueDate) {
        long startDateTime = startDate.getTime();
        long nowTime = now.getTime();
        long dueDateTime = dueDate.getTime();
        long millisecondsPassedSinceStartDate = nowTime - startDateTime;
        long startDateTillDueDateDuration = dueDateTime - startDateTime;
        return (double)millisecondsPassedSinceStartDate / (double)startDateTillDueDateDuration;
    }

    public boolean shouldNotifyDueSoon() {
        return !this.dueSoonNotified && this.isDueSoon();
    }

    public boolean isDueSoonNotified() {
        return this.dueSoonNotified;
    }

    public void setDueSoonNotified(boolean dueSoonNotified) {
        this.dueSoonNotified = dueSoonNotified;
    }

    public void deleteTask(Task task) {
    }

    public void replaceTask(Task task) {
    }

    public Comment findComment(String commentId) {
        return this.comments.stream().filter(comment -> comment.getId().equals(commentId)).findFirst().orElseGet(null);
    }

    public void updateComment(Comment originalComment, Comment updatedComment) {
        int index = this.comments.indexOf((Object)originalComment);
        if (index != -1) {
            this.comments.set(index, updatedComment);
        }
    }

    public void clearComments() {
        this.comments.clear();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void lock() {
        this.setLocked(true);
    }

    @Override
    public void unlock() {
        this.setLocked(false);
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }
}

