package com.xebialabs.xlrelease.plugins.dashboard.domain;

import java.util.List;
import java.util.stream.Collectors;

import static java.util.Arrays.stream;

public enum TileScope {
    RELEASE("release"),
    FOLDER("folder"),
    GLOBAL("global"),
    HOME("home");

    private String value;

    TileScope(final String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static final List<String> ALL_VALUES = stream(values()).map(TileScope::getValue).collect(Collectors.toList());
}
