package com.xebialabs.xlrelease.events;

import java.lang.annotation.*;

import net.engio.mbassy.listener.Handler;

/**
 * The domain events can be used by plugins to get notified when an action happens with a release, task, configuration etc. 
 * You can subscribe to these events using the [[Subscribe]] annotation. Notes about the event handling:
 *
 *  - any exceptions thrown by event handlers will be logged and ignored.
 *
 *  - use asynchronous version [[AsyncSubscribe]] to guarantee that your handler method will be executed in a different
 * thread
 *
 *  - use synchronized version [[SynchronizedSubscribe]] to guarantee that your handler method will be invoked in a thread-safe manner,
 * that is, no other running message publication will be able to invoke this or any other synchronized handler of the same listener until
 * the handler completed
 */

@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Handler
@Target({ElementType.METHOD})
public @interface Subscribe {
}
