package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.reflect.ConfigurationItemPostConstructor;
import com.xebialabs.deployit.plugin.api.reflect.Process;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

@Process(type = "xlrelease.ReferenceVariable")
public class ReferenceVariablePostConstructor implements ConfigurationItemPostConstructor {

    @Override
    public void process(ConfigurationItem configurationItem) {
        ReferenceVariable variable = (ReferenceVariable) configurationItem;
        String valueProviderId = variable.getId() == null ? null : variable.getId().concat("/valueProvider");
        CiProvider provider = Type.valueOf(CiProvider.class).getDescriptor().newInstance(valueProviderId);
        variable.setValueProvider(provider);
    }
}
