package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.google.common.base.Preconditions.checkArgument;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class PasswordStringVariable extends Variable.VariableWithValue<String> {

    @PublicApiMember
    @Property(required = false, password = true, description =
            "Password value of the release variable or default password value of the template variable")
    protected String value;

    @PublicApiMember
    @Property(required = false, description = "Indicates this value is stored externally", nested = true)
    protected ExternalVariableValue externalVariableValue;

    @PublicApiMember
    @Property(required = false, defaultValue = "false", description = "If checked variable value will be multiline text ")
    protected boolean multiline;

    @PublicApiMember
    @Override
    public String getValue() {
        return value;
    }

    @Override
    public String getEmptyValue() {
        return "";
    }

    @PublicApiMember
    @Override
    public void setValue(final String value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        this.setValue(newValue != null ? newValue.toString() : null);
    }

    @PublicApiMember
    public boolean isMultiline() {
        return multiline;
    }

    @PublicApiMember
    public void setMultiline(final boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public boolean isPassword() {
        return true;
    }

    public String getValueAsString() {
        return formatValueAsString(getValue());
    }

    public String getEmptyValueAsString() {
        return formatValueAsString(getEmptyValue());
    }

    @Override
    public boolean isValueAssignableFrom(final Object value) {
        return value instanceof String;
    }

    private String formatValueAsString(Object valueToFormat) {
        return String.valueOf(valueToFormat);
    }

    public ExternalVariableValue getExternalVariableValue() {
        return externalVariableValue;
    }

    public void setExternalVariableValue(final ExternalVariableValue externalVariableValue) {
        this.externalVariableValue = externalVariableValue;
    }

    public void checkExternalPasswordVariable() {
        if (externalVariableValue != null) {
            checkArgument(!requiresValue && !showOnReleaseStart,
                    "Password variables with external values must have requiresValue and showOnReleaseStart flags unchecked");
        }
    }
}
