package com.xebialabs.xlrelease.domain.status;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum PhaseStatus {
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed"),
    FAILING("failing"),
    FAILED("failed"),
    SKIPPED("skipped"),
    ABORTED("aborted");

    private final String value;

    PhaseStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public boolean hasBeenStarted() {
        return this != PLANNED;
    }

    public boolean isActive() {
        return isOneOf(IN_PROGRESS, FAILED, FAILING);
    }

    public boolean isOneOf(PhaseStatus... statuses) {
        for (PhaseStatus status : statuses) {
            if (this == status) {
                return true;
            }
        }

        return false;
    }
}
