package com.xebialabs.xlrelease.domain.runner

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import java.util
import scala.beans.BeanProperty

@Metadata(label = "Digital.ai Release runner registry settings",
  description = "Defines Release runner executor Pod registry mappings and registry service accounts")
class RemoteRunnerRegistrySettings extends Configuration {
  @BeanProperty
  @XLProperty(asContainment = true, label = "Image mappings",
    description = "A mapping of image url, it can be full or partial image url (key and value can define registry host," +
      " organization, repository and a tag with version), left and right value must match in number of parameters they define.",
    required = false)
  var imageUrlMappings: util.Map[String, String] = new util.HashMap[String, String]()


  @BeanProperty
  @XLProperty(asContainment = true, label = "Registry pull secrets",
    description = "A mapping of image url to Service Account that contains credentials for registry",
    required = false)
  var registryPullSecretMappings: util.Map[String, String] = new util.HashMap[String, String]()

}
