package com.xebialabs.xlrelease.domain.runner

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.domain.{Configuration, RemoteExecution}

@Metadata(label = "Base Release job runner", description = "", virtual = true)
abstract class JobRunner extends Configuration {
  def isEnabled: Boolean

  def capacity: Integer

  def evictionTime: Integer

  def getCapabilities: java.util.Set[String]

  def registrySettings: RemoteRunnerRegistrySettings

  def start(): Unit

  def stop(): Unit

  def configure(): Unit

  def delete(): Unit

  def abortJob(jobId: Long, executionId: String): Unit

  def isEncryptJobData(): Boolean

  def execute(remoteExecution: RemoteExecution): String

  def idleTimeToLive: Integer

  def isAvailable: Boolean
}
