package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.BaseConfiguration

sealed trait ConfigurationEvent extends XLReleaseEvent

/**
  * Event published when a new configuration is created.
  * @param conf the created configuration.
  */
case class ConfigurationCreatedEvent(conf: BaseConfiguration) extends ConfigurationEvent

/**
  * Event published when a configuration is updated.
  * @param updated the updated configuration.
  */
case class ConfigurationUpdatedEvent(updated: BaseConfiguration) extends ConfigurationEvent

/**
  * Event published when a configuration is deleted.
  * @param conf the deleted configuration.
  */
case class ConfigurationDeletedEvent(conf: BaseConfiguration) extends ConfigurationEvent

/**
  * Event published when a configuration is copied.
  * @param original the original copy of a configuration.
  * @param newId the new id of a configuration.
  */
case class ConfigurationCopiedEvent(original: BaseConfiguration, newId: String) extends ConfigurationEvent
