package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.{Comment, Task}

/**
  * Common interface for domain events related to comments modification.
  */
sealed trait CommentEvent extends XLReleaseEvent

/**
  * Event published when a comment is created on a task.
  * @param task the task which was commented.
  * @param comment the comment instance.
  * @param author username of the author of the comment.
  * @param createdByUser flag to differentiate if the comment was created by user or by any script task
  */
case class CommentCreatedEvent(task: Task, comment: Comment, author: String, createdByUser: Boolean = false) extends CommentEvent

/**
  * Event published when a comment has been updated. This practically means that the text of the comment
  * has been changed.
  * @param task the task to which the comment belongs.
  * @param original the original comment instance.
  * @param updated the updated comment instance, with the changed text.
  */
case class CommentUpdatedEvent(task: Task, original: Comment, updated: Comment) extends CommentEvent

/**
  * Event published when a comment has been deleted.
  * @param task the task to which the comment belongs.
  * @param comment a copy of the deleted comment.
  */
case class CommentDeletedEvent(task: Task, comment: Comment) extends CommentEvent
