package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.Attachment

/**
  * Common interface for domain events related to attachment modification.
  */
sealed trait AttachmentEvent extends XLReleaseEvent

/**
  * Event published when an attachment is created. Attachments are always added to a release, but task attachments
  * are also linked to from tasks. Therefore this event also contains the container ID to easily determine if it is
  * a release or task attachment.
  * @param containerId the ID of the task or release in which the attachment was created.
  * @param attachment the created attachment.
  */
case class AttachmentCreatedEvent(containerId: String, attachment: Attachment) extends AttachmentEvent

/**
  * Event published when an attachment is deleted.
  * @param containerId the ID of the task or release in which the attachment was created.
  * @param attachment the deleted attachment.
  */
case class AttachmentDeletedEvent(containerId: String, attachment: Attachment) extends AttachmentEvent
