package com.xebialabs.xlrelease.domain.environments;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import java.util.ArrayList;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Environment extends BaseConfiguration {
    @Property(description = "Name of the environment")
    private String title;

    @Property(description = "External system Unique correlation ID for Target", readonly = true)
    private String correlationUid;

    @Property(required = false, description = "Environment description")
    private String description;

    @Property(description = "Environment stage")
    private EnvironmentStage stage;

    @Property(required = false)
    private List<EnvironmentLabel> labels = new ArrayList<>();

    @Property(required = false, nested = true)
    private DeploymentTarget deploymentTarget;

    @PublicApiMember
    public String getDescription() {
        return description;
    }

    @PublicApiMember
    public void setDescription(final String description) {
        this.description = description;
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    public String getCorrelationUid() {
        return correlationUid;
    }

    public void setCorrelationUid(String correlationUid) {
        this.correlationUid = correlationUid;
    }

    @PublicApiMember
    public EnvironmentStage getStage() {
        return stage;
    }

    @PublicApiMember
    public void setStage(EnvironmentStage stage) {
        this.stage = stage;
    }

    public List<EnvironmentLabel> getLabels() {
        return labels;
    }

    public void setLabels(final List<EnvironmentLabel> labels) {
        this.labels = labels;
    }

    public DeploymentTarget getDeploymentTarget() {
        return deploymentTarget;
    }

    public void setDeploymentTarget(DeploymentTarget deploymentTarget) {
        this.deploymentTarget = deploymentTarget;
    }
}
