package com.xebialabs.xlrelease.domain.distributed.events

import com.xebialabs.xlrelease.domain.status.TaskStatus

/**
 * Common interface for domain events related to task status.
 */
sealed trait DistributedTaskStatusEvent extends DistributedXLReleaseEvent {
  def containerId: String
  def taskStatus: TaskStatus
}

/**
 * Event published when the task status has been changed.
 * @param containerId the ID of the task whose status has been changed.
 * @param taskStatus new task status after change
 */
case class DistributedTaskStatusChangeEvent(containerId: String, taskStatus: TaskStatus) extends DistributedTaskStatusEvent
